/*
 * Decompiled with CFR 0.152.
 */
package ev.to;

import fig.basic.IOUtils;
import fig.basic.Option;
import fig.exec.Execution;
import goblin.Taxon;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import ma.MultiAlignment;
import nuts.io.IO;
import pty.RootedTree;
import pty.io.WalsAnn;

public abstract class PhyloTools
implements Runnable {
    private static PhyloToolsOptions options = new PhyloToolsOptions();
    protected File workingDir = null;

    public abstract File createTree(File var1);

    @Override
    public void run() {
        try {
            MultiAlignment msa = MultiAlignment.parseMSFToMultiAlignment(PhyloTools.options.msfFile);
            this.workingDir = IO.getTempDir("temp-phylo");
            IO.writeToDisk(Execution.getFile("tree.newick"), RootedTree.Util.toNewick(this.inferTree(msa)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RootedTree inferTree(MultiAlignment msa) {
        HashMap<String, Taxon> map = new HashMap<String, Taxon>();
        File phylipFile = new File(this.workingDir, "converted.phylip");
        PhyloTools.toPhylip(msa, map, phylipFile, PhyloTools.options.replaceUToT);
        File phymlOutTree = this.createTree(phylipFile);
        String newickStr = IO.file2String(phymlOutTree);
        for (String id : map.keySet()) {
            newickStr = newickStr.replaceAll(id, ((Taxon)map.get(id)).toString());
        }
        return RootedTree.Util.fromNewickString(newickStr);
    }

    public void setWorkingDir(File dir) {
        this.workingDir = dir;
    }

    public static void toPhylip(MultiAlignment msa, Map<String, Taxon> map, File phylipFile, boolean replaceUToT) {
        PrintWriter out = IOUtils.openOutHard(phylipFile);
        MultiAlignment.LinearizedAlignmentMatrix lam = msa.createAlignmentMatrix();
        out.println(" " + msa.getSequences().keySet().size() + " " + lam.nCols());
        int i = 0;
        for (Taxon lang : msa.getSequences().keySet()) {
            String newName = "X" + i++ + "X";
            if (newName.length() > 10) {
                throw new RuntimeException();
            }
            map.put(newName, lang);
            out.print(WalsAnn.cleanForPhylip(newName));
            String line = lam.stringWithGaps(lang, '-');
            if (replaceUToT) {
                line = line.replaceAll("U", "T");
            }
            out.print(line + "\n");
        }
        out.close();
    }

    public static class PhyloToolsOptions {
        @Option
        public String msfFile = null;
        @Option
        public boolean replaceUToT = true;
    }
}

