/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.remote;

import fig.basic.Option;
import fig.exec.remote.DummyExecutorService;
import fig.exec.remote.EnsembleExecutorService;
import fig.exec.remote.ExecutorServiceWrapper;
import fig.exec.remote.PollingExecutorService;
import fig.exec.remote.RemoteExecutorServiceProxy;
import fig.exec.remote.RemoteExecutors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Executors;

public class RemoteOpts {
    @Option(gloss="Ports to check for ExecWorkers")
    public static ArrayList<Integer> ports;
    @Option(gloss="Maximum number of workers to use")
    public static int maxWorkers;
    @Option(gloss="Run jobs in several threads (for the PSI batch cluster); overrides use of remote machines")
    public static int numThreads;

    public static PollingExecutorService getConfiguredExecutorPool() {
        if (numThreads > 0) {
            return new ExecutorServiceWrapper(Executors.newFixedThreadPool(numThreads));
        }
        RemoteExecutorServiceProxy r = RemoteExecutors.getRemoteExecutorPool();
        DummyExecutorService e = new DummyExecutorService();
        return new EnsembleExecutorService(Arrays.asList(e, r));
    }

    static {
        maxWorkers = 0;
        numThreads = 0;
    }
}

