/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.exec.servlet.Basket;
import fig.exec.servlet.BasketFactory;
import fig.exec.servlet.DirSource;
import fig.exec.servlet.FieldListMap;
import fig.exec.servlet.FileSource;
import fig.exec.servlet.MyException;
import fig.exec.servlet.Trail;
import fig.exec.servlet.UpdateQueue;
import fig.exec.servlet.UpdateSpec;
import fig.exec.servlet.View;
import java.io.File;
import java.util.Collections;

public class BasketDB
extends View<Basket> {
    private static final String indexFile = "_index.index";
    private static final String clipboardName = "clipboard";
    private Basket clipboardBasket;
    private BasketFactory factory;

    public BasketDB(Trail trail, DirSource source, BasketFactory factory) {
        this.trail = trail;
        this.source = source;
        this.factory = factory;
        this.clipboardBasket = this.newBasket(clipboardName);
        this.addItemHard(this.clipboardBasket);
    }

    private Basket newBasket(String name) {
        FileSource childSource = new FileSource((DirSource)this.source, this.nameToFile(name));
        return this.factory.newBasket(this.childTrail(name), childSource);
    }

    @Override
    public FieldListMap getMetadataFields() {
        return new FieldListMap();
    }

    @Override
    public FieldListMap getItemsFields() {
        return new Basket(null, this.source).getMetadataFields();
    }

    @Override
    public void update(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        this.updateItemsFromFile(spec, Collections.singletonList(this.clipboardBasket), new FileSource((DirSource)this.source, indexFile), Collections.EMPTY_LIST);
        this.updateChildren(spec, priority);
    }

    @Override
    protected File getGroundedIndexPath() {
        return ((DirSource)this.source).getPath(indexFile);
    }

    @Override
    protected Basket newItem(String name) {
        return this.newBasket(name);
    }

    @Override
    protected String itemToSpec(Basket item) throws MyException {
        if (item == this.clipboardBasket) {
            return null;
        }
        return super.itemToSpec(item);
    }

    public Basket getClipboardBasket() {
        return this.clipboardBasket;
    }

    private String nameToFile(String name) {
        return name + ".index";
    }
}

