/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import fig.basic.IOUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nuts.util.Counter;

public class BayesRiskMinimizer<T> {
    private final LossFct<T> lossFct;
    private final boolean useFrank;
    public static LevenshteinLoss levenshteinLoss = new LevenshteinLoss();

    public BayesRiskMinimizer(LossFct<T> lossFct) {
        this(lossFct, false);
    }

    public BayesRiskMinimizer(LossFct<T> lossFct, boolean frank) {
        this.lossFct = lossFct;
        this.useFrank = frank;
    }

    public T findMin(Counter<T> elementMultiplicities) {
        if (elementMultiplicities.size() == 0) {
            throw new RuntimeException("Empty set given to bayes risk minimizer");
        }
        T min = null;
        double minValue = Double.POSITIVE_INFINITY;
        for (T currentElt : this.candidates(elementMultiplicities.keySet())) {
            double currentValue = this.sumOfLosses(currentElt, elementMultiplicities);
            if (!(currentValue < minValue)) continue;
            minValue = currentValue;
            min = currentElt;
        }
        return min;
    }

    private Set<T> candidates(Set<T> keySet) {
        if (!this.useFrank) {
            return keySet;
        }
        HashSet<String> base = new HashSet<String>();
        for (T item : keySet) {
            base.add(item.toString());
        }
        HashSet<String> result = new HashSet<String>();
        Set<String> suffixes = this.suffixes(base);
        for (String prefix : this.prefixes(base)) {
            for (String suffix : suffixes) {
                result.add(prefix + suffix);
            }
        }
        return result;
    }

    private Set<String> prefixes(Set<String> base) {
        HashSet<String> result = new HashSet<String>();
        for (String word : base) {
            for (int i = 0; i < word.length() + 1; ++i) {
                result.add(word.substring(0, i));
            }
        }
        return result;
    }

    private Set<String> suffixes(Set<String> base) {
        HashSet<String> result = new HashSet<String>();
        for (String word : base) {
            for (int i = 0; i < word.length() + 1; ++i) {
                result.add(word.substring(i, word.length()));
            }
        }
        return result;
    }

    private double sumOfLosses(T currentElt, Counter<T> elementMultiplicities) {
        double sum = 0.0;
        for (T otherElement : elementMultiplicities.keySet()) {
            sum += elementMultiplicities.getCount(otherElement) * this.lossFct.loss(currentElt, otherElement);
        }
        return sum;
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        Counter counterInput = (Counter)IOUtils.openBinIn("data/core_dump_counter_1201738944217").readObject();
        List listInput = (List)IOUtils.openBinIn("data/core_dump_sampleList_1201738944217").readObject();
        BayesRiskMinimizer<String> newImpl = new BayesRiskMinimizer<String>(new LevenshteinLoss(), false);
        System.out.println("new: " + newImpl.findMin(counterInput));
        pepper.editmodel.BayesRiskMinimizer oldImpl = new pepper.editmodel.BayesRiskMinimizer();
        System.out.println("old: " + oldImpl.findBestWord(listInput));
    }

    public static class LevenshteinLoss
    implements LossFct<String> {
        @Override
        public double loss(String t1, String t2) {
            return pepper.editmodel.BayesRiskMinimizer.computeDist(t1, t2);
        }
    }

    public static interface LossFct<T> {
        public double loss(T var1, T var2);
    }
}

