/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.StrUtils;
import fig.exec.Execution;
import goblin.BioDataLoaderAdaptor;
import goblin.CognateSet;
import goblin.DataLoaderInterface;
import goblin.HLParams;
import goblin.HLParamsUpdater;
import goblin.Taxon;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ma.AffineGapAlignmentSampler;
import ma.SequenceType;
import nuts.maxent.FeatureExtractor;
import nuts.maxent.LabeledInstance;
import nuts.util.Counter;
import pepper.Encodings;
import pepper.PhonemeEqClass;
import sage.FatFeatureExtractor;
import sage.RegexFeatureTemplate;

public class HLFeatureExtractor
implements FeatureExtractor<LabeledInstance<HLParams.HLContext, HLParams.HLOutcome>, Object> {
    private static final long serialVersionUID = 1L;
    private static Boolean _collapseLanguage = null;
    @Option(gloss="List of feature templates to be used")
    public ArrayList<HLFeatureTemplate> featureTemplates = new ArrayList<HLFeatureTemplate>(Arrays.asList(HLFeatureTemplate.FINEST));
    @Option
    public String fixedRuleList = "";
    @Option
    public String blancketPath = "";
    private Counter blancket = null;
    private double[][] globalLogPm = null;
    private RegexFeatureTemplate regexFT = null;
    public static AffineGapAlignmentSampler.CompiledTKFParams compiledTKF = null;

    public static boolean collapseLanguage() {
        return false;
    }

    public final Counter getBlancket() {
        if (this.blancket == null) {
            this.blancket = HLParamsUpdater.restoreCounter(this.blancketPath);
        }
        return this.blancket;
    }

    public static void setIgnoreLanguages(boolean ignore) {
    }

    public void setIgnoreLanguages(FatFeatureExtractor ffe) {
    }

    public void setFeatureTemplates(HLFeatureTemplate ... templates) {
        this.featureTemplates = new ArrayList();
        for (HLFeatureTemplate template : templates) {
            this.featureTemplates.add(template);
        }
    }

    public void init(DataLoaderInterface loader) {
        this.init(loader, null);
    }

    public void init(DataLoaderInterface loader, FatFeatureExtractor ffe) {
        LogInfo.track("Initializing HLFeatureExtractor");
        this.setIgnoreLanguages(ffe);
        if (!this.fixedRuleList.equals("")) {
            this.loadFixedRuleList(loader.getCognateSet().getLanguages());
        }
        if (this.featureTemplates.contains((Object)HLFeatureTemplate.GLOBAL_LM)) {
            this.constructGlobalPhonemeModel(loader.getCognateSet(), Encodings.getGlobalEncodings());
        }
        if (this.featureTemplates.contains((Object)HLFeatureTemplate.CTMC)) {
            if (!Encodings.getGlobalEncodings().equals(Encodings.proteinEncodings(true)) && !Encodings.getGlobalEncodings().equals(Encodings.dnaEncodings())) {
                throw new RuntimeException();
            }
            BioDataLoaderAdaptor bdla = (BioDataLoaderAdaptor)loader;
            SequenceType sType = bdla.getSequenceType();
            compiledTKF = sType.defaultTKFParams().compile(bdla.branchDiscretLength);
        }
        LogInfo.end_track();
    }

    private void constructGlobalPhonemeModel(CognateSet cs, Encodings enc) {
        throw new RuntimeException();
    }

    public void loadFixedRuleList(Collection<Taxon> allLanguages) {
        if (this.fixedRuleList.equals("")) {
            return;
        }
        LogInfo.track("Loading fixed rule list");
        this.regexFT = RegexFeatureTemplate.load(new File(this.fixedRuleList));
        this.regexFT.debug(allLanguages);
        LogInfo.end_track();
    }

    public static void main(String[] args) {
    }

    public Double getGlobalLogPm(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance) {
        if (instance.getLabel().isSpecial()) {
            return null;
        }
        int prev = instance.getInput().prev;
        int cur = instance.getLabel().outcome;
        return this.globalLogPm[prev][cur];
    }

    public static boolean isStopInsertion(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance) {
        return instance.getInput().type == HLParams.ChoiceType.INS && instance.getLabel().isSpecial();
    }

    public static boolean isPhonemeInsertion(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance) {
        return instance.getInput().type == HLParams.ChoiceType.INS && !instance.getLabel().isSpecial();
    }

    public static boolean isDeletion(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance) {
        return instance.getInput().type == HLParams.ChoiceType.SUBDEL && instance.getLabel().isSpecial();
    }

    public static boolean isSubstitution(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance) {
        return instance.getInput().type == HLParams.ChoiceType.SUBDEL && !instance.getLabel().isSpecial();
    }

    public static boolean isSelfSubstitution(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance) {
        return HLFeatureExtractor.isSubstitution(instance) && instance.getLabel().outcome == instance.getInput().top;
    }

    public static boolean isRootModel(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance) {
        return instance.getInput().isRoot();
    }

    public static List<String> modifiedFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance) {
        Encodings enc = instance.getInput().enc;
        return HLFeatureExtractor.modifiedFeatures(instance.getInput().top, instance.getLabel().outcome, enc);
    }

    public static List<String> modifiedFeatures(int c1Code, int c2Code, Encodings enc) {
        PhonemeEqClass eq1 = enc.phoneId2EqClassObject(c1Code);
        PhonemeEqClass eq2 = enc.phoneId2EqClassObject(c2Code);
        ArrayList<String> newValues = new ArrayList<String>();
        if (eq1.isVowel() != eq2.isVowel()) {
            return null;
        }
        for (PhonemeEqClass.PhonemeFeatureTypes pft : eq1.isVowel() ? PhonemeEqClass.vowelFeatureTypes : PhonemeEqClass.consFeatureTypes) {
            if (eq1.getFeature(pft).equals(eq2.getFeature(pft))) continue;
            newValues.add(eq2.getFeature(pft));
        }
        Collections.sort(newValues);
        return newValues;
    }

    public void saveDebug(String file, Encodings enc, Set<Taxon> allLangs) {
        PrintWriter output = IOUtils.openOutHard(Execution.getFile(file));
        for (Taxon lang : allLangs) {
            for (HLParams.HLContext ctxt : HLParams.allHLContexts(enc, lang)) {
                for (HLParams.HLOutcome outcome : ctxt.allOutcomes()) {
                    output.append("OPERATION:" + HLParams.format(ctxt, outcome) + "\n");
                    Counter<Object> cur = new Counter<Object>();
                    for (HLFeatureTemplate hLFeatureTemplate : this.featureTemplates) {
                        hLFeatureTemplate.extractFeatures(new LabeledInstance<HLParams.HLContext, HLParams.HLOutcome>(outcome, ctxt), cur, this);
                    }
                    for (HLFeatureTemplate hLFeatureTemplate : cur) {
                        output.append("\t" + (Object)((Object)hLFeatureTemplate) + "\t" + cur.getCount((Object)hLFeatureTemplate) + "\n");
                    }
                }
            }
        }
        output.close();
    }

    public static String reversibleSubstitution(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance) {
        if (!HLFeatureExtractor.isSubstitution(instance)) {
            return null;
        }
        int top = instance.getInput().top;
        int bot = instance.getLabel().outcome;
        Encodings enc = instance.getInput().enc;
        char topChar = enc.phoneId2Char(top);
        char botChar = enc.phoneId2Char(bot);
        if (top <= bot) {
            return "[" + topChar + " <-> " + botChar + "]";
        }
        return "[" + botChar + " <-> " + topChar + "]";
    }

    public static String bigram(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, boolean collapsed) {
        if (instance.getLabel().isSpecial()) {
            throw new RuntimeException();
        }
        char prevChar = instance.getInput().prevChar();
        char curChar = instance.getLabel().outcomeChar();
        return "[" + HLFeatureExtractor.map(instance, prevChar, collapsed) + " " + HLFeatureExtractor.map(instance, curChar, collapsed) + "]";
    }

    public static String unigram(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, boolean collapsed) {
        if (instance.getLabel().isSpecial()) {
            throw new RuntimeException();
        }
        char curChar = instance.getLabel().outcomeChar();
        return "[" + HLFeatureExtractor.map(instance, curChar, collapsed) + "]";
    }

    public static char map(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, char c, boolean collapsed) {
        return HLFeatureExtractor.map(instance.getInput().enc, c, collapsed);
    }

    public static char map(Encodings enc, char c, boolean collapsed) {
        if (!collapsed || enc.boundChar() == c) {
            return c;
        }
        return enc.phoneId2EqClassObject(enc.char2PhoneId(c)).isVowel() ? (char)'V' : 'C';
    }

    public static void lmFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, Counter<Object> features, boolean global, boolean collapsed) {
        boolean useNewLMSmoothing = true;
        String namePrefix = "I[" + (global ? "" : "LANGUAGE=" + instance.getInput().botLang + "," + (useNewLMSmoothing ? "" : "IS-ROOT=" + instance.getInput().isRoot() + ","));
        features.incrementCount(namePrefix + "UNI=" + HLFeatureExtractor.unigram(instance, collapsed) + "]", 1.0);
        features.incrementCount(namePrefix + "BI=" + HLFeatureExtractor.bigram(instance, collapsed) + "]", 1.0);
        if (instance.getInput().isRoot() && useNewLMSmoothing) {
            namePrefix = namePrefix + "IS-ROOT,";
            features.incrementCount(namePrefix + "UNI=" + HLFeatureExtractor.unigram(instance, collapsed) + "]", 1.0);
            features.incrementCount(namePrefix + "BI=" + HLFeatureExtractor.bigram(instance, collapsed) + "]", 1.0);
        }
    }

    public Set<Object> allPossibleFeatures(Encodings enc, Set<Taxon> languages) {
        HashSet<Object> result = new HashSet<Object>();
        for (HLFeatureTemplate template : this.featureTemplates) {
            result.addAll(this.allPossibleFeatures(enc, languages, template));
        }
        return result;
    }

    public Set<Object> allPossibleFeatures(Encodings enc, Set<Taxon> languages, HLFeatureTemplate template) {
        if (HLFeatureExtractor.collapseLanguage()) {
            languages = Collections.singleton(Taxon.dummy);
        }
        Counter<Object> result = new Counter<Object>();
        LogInfo.track("Enumerating all possible features");
        int i = 0;
        for (Taxon lang : languages) {
            LogInfo.logs("Lang " + i++ + "/" + languages.size());
            for (HLParams.HLContext ctxt : HLParams.allHLContexts(enc, lang)) {
                for (HLParams.HLOutcome out : ctxt.allOutcomes()) {
                    template.extractFeatures(new LabeledInstance<HLParams.HLContext, HLParams.HLOutcome>(out, ctxt), result, this);
                }
            }
        }
        LogInfo.end_track();
        return result.keySet();
    }

    public static String getTKFFeatureName(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> li) {
        Counter<Object> temp = new Counter<Object>();
        if (li.getInput().isRoot()) {
            return "I[LANGUAGE=" + li.getInput().botLang + ",IS-ROOT,UNI=[" + li.getLabel().outcomeChar() + "]]";
        }
        for (Object key : temp.keySet()) {
            temp.removeKey(key);
        }
        HLFeatureTemplate.LOCAL_PHONEME_FAITH.extractFeatures(li, temp, null);
        if (temp.keySet().size() != 1) {
            throw new RuntimeException();
        }
        return temp.keySet().iterator().next().toString();
    }

    public String toString(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance) {
        Counter<Object> features = this.extractFeatures(instance);
        ArrayList<String> orderedFeatures = new ArrayList<String>();
        for (Object f : features.keySet()) {
            orderedFeatures.add(f.toString() + "=" + features.getCount(f));
        }
        Collections.sort(orderedFeatures);
        StringBuilder result = new StringBuilder();
        result.append('[');
        result.append(StrUtils.join(orderedFeatures, ","));
        result.append(']');
        return result.toString();
    }

    @Override
    public Counter<Object> extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance) {
        Counter<Object> result = new Counter<Object>();
        this.extractFeatures(instance, result);
        return result;
    }

    public void extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, Counter<Object> features) {
        for (HLFeatureTemplate template : this.featureTemplates) {
            template.extractFeatures(instance, features, this);
        }
    }

    @Override
    public double regularizationFactor(Object feature) {
        return 1.0;
    }

    public static enum HLFeatureTemplate {
        REVERSIBLE_TYPE(false){
            public static final String REVERSIBLE_INDEL = "I[REVERSIBLE_INDEL]";
            public static final String REVERSIBLE_SUB = "I[REVERSIBLE_SUB]";

            @Override
            public void extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, Counter<Object> features, HLFeatureExtractor ext) {
                if (HLFeatureExtractor.isStopInsertion(instance)) {
                    features.incrementCount(REVERSIBLE_SUB, 1.0);
                } else if (HLFeatureExtractor.isPhonemeInsertion(instance)) {
                    features.incrementCount(REVERSIBLE_INDEL, 1.0);
                } else if (HLFeatureExtractor.isDeletion(instance)) {
                    features.incrementCount(REVERSIBLE_INDEL, 1.0);
                } else if (HLFeatureExtractor.isSubstitution(instance)) {
                    features.incrementCount(REVERSIBLE_SUB, 1.0);
                } else if (!HLFeatureExtractor.isRootModel(instance)) {
                    throw new RuntimeException("Undefined type in REVERSIBLE_TYPE");
                }
            }
        }
        ,
        REVERSIBLE_SUB(false){

            @Override
            public void extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, Counter<Object> features, HLFeatureExtractor ext) {
                String feature = HLFeatureExtractor.reversibleSubstitution(instance);
                if (feature != null) {
                    features.incrementCount("I" + feature, 1.0);
                }
            }
        }
        ,
        LOCAL_LM(true){

            @Override
            public void extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, Counter<Object> features, HLFeatureExtractor ext) {
                if (instance.getLabel().isSpecial()) {
                    return;
                }
                HLFeatureExtractor.lmFeatures(instance, features, false, false);
            }
        }
        ,
        GLOBAL_INDIC_LM(false){

            @Override
            public void extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, Counter<Object> features, HLFeatureExtractor ext) {
                if (instance.getLabel().isSpecial()) {
                    return;
                }
                HLFeatureExtractor.lmFeatures(instance, features, true, false);
            }
        }
        ,
        LOCAL_COL_LM(true){

            @Override
            public void extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, Counter<Object> features, HLFeatureExtractor ext) {
                if (instance.getLabel().isSpecial()) {
                    return;
                }
                HLFeatureExtractor.lmFeatures(instance, features, false, true);
            }
        }
        ,
        GLOBAL_COL_INDIC_LM(false){

            @Override
            public void extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, Counter<Object> features, HLFeatureExtractor ext) {
                if (instance.getLabel().isSpecial()) {
                    return;
                }
                HLFeatureExtractor.lmFeatures(instance, features, true, true);
            }
        }
        ,
        GLOBAL_LM(false){

            @Override
            public void extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, Counter<Object> features, HLFeatureExtractor ext) {
                if (instance.getLabel().isSpecial()) {
                    return;
                }
                String prefix = "I[IS-ROOT=" + instance.getInput().isRoot() + "]";
                features.incrementCount(prefix + ",GLOBAL_LM", ext.getGlobalLogPm(instance));
            }
        }
        ,
        GLOBAL_LM_BIAS(false){

            @Override
            public void extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, Counter<Object> features, HLFeatureExtractor ext) {
                if (instance.getLabel().isSpecial()) {
                    return;
                }
                String prefix = "I[IS-ROOT=" + instance.getInput().isRoot() + "]";
                features.incrementCount(prefix + ",GLOBAL_LM_BIAS", 1.0);
            }
        }
        ,
        GLOBAL_PHONEME_FAITH(false){

            @Override
            public void extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, Counter<Object> features, HLFeatureExtractor ext) {
                if (HLFeatureExtractor.isSubstitution(instance)) {
                    features.incrementCount("I[" + instance.getInput().topChar() + "->" + instance.getLabel().outcomeChar() + "]", 1.0);
                } else if (HLFeatureExtractor.isDeletion(instance)) {
                    features.incrementCount("I[" + instance.getInput().topChar() + "-><>]", 1.0);
                } else if (HLFeatureExtractor.isPhonemeInsertion(instance)) {
                    features.incrementCount("I[<>->" + instance.getLabel().outcomeChar() + "]", 1.0);
                }
            }
        }
        ,
        LOCAL_PHONEME_FAITH(true){

            @Override
            public void extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, Counter<Object> features, HLFeatureExtractor ext) {
                Taxon lang = instance.getInput().botLang;
                if (HLFeatureExtractor.isSubstitution(instance)) {
                    features.incrementCount("I[" + instance.getInput().topChar() + "->" + instance.getLabel().outcomeChar() + "@" + lang + "]", 1.0);
                } else if (HLFeatureExtractor.isDeletion(instance)) {
                    features.incrementCount("I[" + instance.getInput().topChar() + "-><>@" + lang + "]", 1.0);
                } else if (HLFeatureExtractor.isPhonemeInsertion(instance)) {
                    features.incrementCount("I[<>->" + instance.getLabel().outcomeChar() + "@" + lang + "]", 1.0);
                } else if (HLFeatureExtractor.isStopInsertion(instance)) {
                    features.incrementCount("I[<>->STOP@" + lang + "]", 1.0);
                }
            }
        }
        ,
        LOCAL_BOUNDED_FEAT_DELTA_PHONEME_FAITH(true){

            @Override
            public void extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, Counter<Object> features, HLFeatureExtractor ext) {
                Taxon lang = instance.getInput().botLang;
                if (HLFeatureExtractor.isSubstitution(instance)) {
                    List<String> delta = HLFeatureExtractor.modifiedFeatures(instance);
                    if (delta != null && delta.size() < 3) {
                        features.incrementCount("I[" + instance.getInput().topChar() + "->+" + delta + "@" + lang + "]", 1.0);
                    }
                } else if (HLFeatureExtractor.isDeletion(instance)) {
                    features.incrementCount("I[" + instance.getInput().topChar() + "-><>@" + lang + "]", 1.0);
                } else if (HLFeatureExtractor.isPhonemeInsertion(instance)) {
                    features.incrementCount("I[<>->" + instance.getLabel().outcomeChar() + "@" + lang + "]", 1.0);
                }
            }
        }
        ,
        VOW_CONS_SUB_DONT_MATCH(false){
            public static final String APPROX2VOW = "I[APPROX->VOW]";
            public static final String VOW2APPROX = "I[VOW->APPROX]";
            public static final String VOW2CONS = "I[VOW->CONS]";
            public static final String CONS2VOW = "I[CONS->VOW]";

            @Override
            public void extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, Counter<Object> features, HLFeatureExtractor ext) {
                Encodings enc = instance.getInput().enc;
                if (!HLFeatureExtractor.isSubstitution(instance) || instance.getInput().top == enc.boundId() || instance.getLabel().outcome == enc.boundId()) {
                    return;
                }
                PhonemeEqClass eq1 = enc.phoneId2EqClassObject(instance.getInput().top);
                PhonemeEqClass eq2 = enc.phoneId2EqClassObject(instance.getLabel().outcome);
                if (eq1.isVowel() == eq2.isVowel()) {
                    return;
                }
                if (!eq1.isVowel() && eq1.getFeature(PhonemeEqClass.PhonemeFeatureTypes.MANNER).equals("approximant")) {
                    features.incrementCount(APPROX2VOW, 1.0);
                } else if (!eq2.isVowel() && eq2.getFeature(PhonemeEqClass.PhonemeFeatureTypes.MANNER).equals("approximant")) {
                    features.incrementCount(VOW2APPROX, 1.0);
                } else if (eq1.isVowel()) {
                    features.incrementCount(VOW2CONS, 1.0);
                } else if (eq2.isVowel()) {
                    features.incrementCount(CONS2VOW, 1.0);
                } else {
                    throw new RuntimeException("Internal error in VOW_CONS_SUB_DONT_MATCH");
                }
            }
        }
        ,
        FEATURES_DIFFER(false){

            @Override
            public void extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, Counter<Object> features, HLFeatureExtractor ext) {
                Encodings enc = instance.getInput().enc;
                if (!HLFeatureExtractor.isSubstitution(instance) || instance.getInput().top == enc.boundId() || instance.getLabel().outcome == enc.boundId()) {
                    return;
                }
                PhonemeEqClass eq1 = enc.phoneId2EqClassObject(instance.getInput().top);
                PhonemeEqClass eq2 = enc.phoneId2EqClassObject(instance.getLabel().outcome);
                if (eq1.isVowel() != eq2.isVowel()) {
                    return;
                }
                for (PhonemeEqClass.PhonemeFeatureTypes pft : eq1.isVowel() ? PhonemeEqClass.vowelFeatureTypes : PhonemeEqClass.consFeatureTypes) {
                    if (eq1.getFeature(pft).equals(eq2.getFeature(pft))) continue;
                    features.incrementCount("I[FEATURE-" + (Object)((Object)pft) + "-DIFFER:" + eq1.getFeature(pft) + "->" + eq2.getFeature(pft) + "]", 1.0);
                }
            }
        }
        ,
        FEATURES_MATCH(false){

            @Override
            public void extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, Counter<Object> features, HLFeatureExtractor ext) {
                Encodings enc = instance.getInput().enc;
                if (!HLFeatureExtractor.isSubstitution(instance) || instance.getInput().top == enc.boundId() || instance.getLabel().outcome == enc.boundId()) {
                    return;
                }
                PhonemeEqClass eq1 = enc.phoneId2EqClassObject(instance.getInput().top);
                PhonemeEqClass eq2 = enc.phoneId2EqClassObject(instance.getLabel().outcome);
                if (eq1.isVowel() != eq2.isVowel()) {
                    return;
                }
                for (PhonemeEqClass.PhonemeFeatureTypes pft : eq1.isVowel() ? PhonemeEqClass.vowelFeatureTypes : PhonemeEqClass.consFeatureTypes) {
                    if (!eq1.getFeature(pft).equals(eq2.getFeature(pft))) continue;
                    features.incrementCount("I[FEATURE-" + (Object)((Object)pft) + "-MATCHES]", 1.0);
                }
            }
        }
        ,
        FINEST(true){

            @Override
            public void extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, Counter<Object> features, HLFeatureExtractor ext) {
                features.incrementCount(instance.toString(), 1.0);
            }
        }
        ,
        CTMC(false){

            @Override
            public void extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, Counter<Object> features, HLFeatureExtractor ext) {
                if (HLFeatureExtractor.isSubstitution(instance)) {
                    int x = instance.getInput().top;
                    int y = instance.getLabel().outcome;
                    features.incrementCount("CTMC", Math.log(compiledTKF.transition(x, y)));
                }
            }
        }
        ,
        TYPE(false){
            public static final String INSERTION = "INSERT";
            public static final String DELETION = "DELETION";
            public static final String SUBSTITUTION = "SUBSTITUTION";
            public static final String SELFSUBSTITUTION = "SELFSUBSTITUTION";
            public static final String INSERTIONSTOP = "INSERTIONSTOP";

            @Override
            public void extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, Counter<Object> features, HLFeatureExtractor ext) {
                if (HLFeatureExtractor.isStopInsertion(instance)) {
                    features.incrementCount(INSERTIONSTOP, 1.0);
                } else if (HLFeatureExtractor.isPhonemeInsertion(instance)) {
                    features.incrementCount(INSERTION, 1.0);
                } else if (HLFeatureExtractor.isDeletion(instance)) {
                    features.incrementCount(DELETION, 1.0);
                } else if (HLFeatureExtractor.isSelfSubstitution(instance)) {
                    features.incrementCount(SELFSUBSTITUTION, 1.0);
                } else if (HLFeatureExtractor.isSubstitution(instance)) {
                    features.incrementCount(SUBSTITUTION, 1.0);
                } else if (!HLFeatureExtractor.isRootModel(instance)) {
                    throw new RuntimeException("Internal error in TYPE");
                }
            }
        }
        ,
        LANGUAGE_TYPE(true){
            public static final String INSERTION = "INSERT";
            public static final String DELETION = "DELETION";
            public static final String SUBSTITUTION = "SUBSTITUTION";
            public static final String SELFSUBSTITUTION = "SELFSUBSTITUTION";
            public static final String INSERTIONSTOP = "INSERTIONSTOP";

            @Override
            public void extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, Counter<Object> features, HLFeatureExtractor ext) {
                String langString = ",lang=" + instance.getInput().botLang;
                if (HLFeatureExtractor.isStopInsertion(instance)) {
                    features.incrementCount(INSERTIONSTOP + langString, 1.0);
                } else if (HLFeatureExtractor.isPhonemeInsertion(instance)) {
                    features.incrementCount(INSERTION + langString, 1.0);
                } else if (HLFeatureExtractor.isDeletion(instance)) {
                    features.incrementCount(DELETION + langString, 1.0);
                } else if (HLFeatureExtractor.isSelfSubstitution(instance)) {
                    features.incrementCount(SELFSUBSTITUTION + langString, 1.0);
                } else if (HLFeatureExtractor.isSubstitution(instance)) {
                    features.incrementCount(SUBSTITUTION + langString, 1.0);
                } else if (!HLFeatureExtractor.isRootModel(instance)) {
                    throw new RuntimeException("Internal error in TYPE");
                }
            }
        }
        ,
        FINE_INDEL(false){

            @Override
            public void extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, Counter<Object> features, HLFeatureExtractor ext) {
                if (HLFeatureExtractor.isStopInsertion(instance)) {
                    features.incrementCount("INSERTIONSTOP,top=" + instance.getInput().topChar(), 1.0);
                    features.incrementCount("INSERTIONSTOP,prev=" + instance.getInput().prevChar(), 1.0);
                } else if (HLFeatureExtractor.isPhonemeInsertion(instance)) {
                    features.incrementCount("INSERT,top=" + instance.getInput().topChar(), 1.0);
                    features.incrementCount("INSERT,prev=" + instance.getInput().prevChar(), 1.0);
                } else if (HLFeatureExtractor.isDeletion(instance)) {
                    features.incrementCount("DELETION,top=" + instance.getInput().topChar(), 1.0);
                    features.incrementCount("DELETION,prev=" + instance.getInput().prevChar(), 1.0);
                }
            }
        }
        ,
        BLANKET(false){
            public static final String STRING = "BLANKET";

            @Override
            public void extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, Counter<Object> features, HLFeatureExtractor ext) {
                String feature = HLFeatureExtractor.getTKFFeatureName(instance);
                double w = ext.getBlancket().getCount(feature);
                features.incrementCount(STRING, w);
            }
        }
        ,
        EXTRA_FINE_INDEL(false){

            @Override
            public void extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, Counter<Object> features, HLFeatureExtractor ext) {
                if (HLFeatureExtractor.isStopInsertion(instance)) {
                    features.incrementCount("INSERTIONSTOP,top=" + instance.getInput().topChar() + ",prev=" + instance.getInput().prevChar(), 1.0);
                } else if (HLFeatureExtractor.isPhonemeInsertion(instance)) {
                    features.incrementCount("INSERT,top=,prev=" + instance.getInput().prevChar(), 1.0);
                } else if (HLFeatureExtractor.isDeletion(instance)) {
                    features.incrementCount("DELETION,top=,prev=" + instance.getInput().prevChar(), 1.0);
                }
            }
        }
        ,
        FIXED_RULE_LIST(true){

            @Override
            public void extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, Counter<Object> features, HLFeatureExtractor ext) {
                ext.regexFT.extractFeatures(instance, features);
            }
        };

        private boolean usesLanguageField;

        private HLFeatureTemplate(boolean ulf) {
            this.usesLanguageField = ulf;
        }

        public abstract void extractFeatures(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> var1, Counter<Object> var2, HLFeatureExtractor var3);
    }
}

