/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import goblin.AlignmentSampler;
import goblin.DerivationTree;
import goblin.DirectedTreeSampler;
import goblin.EditsTracker;
import goblin.HLParams;
import goblin.ObservationsTracker;
import goblin.ParamsTracker;
import goblin.Taxon;
import goblin.TreeSamplers;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import ma.AffineGapAlignmentSampler;
import ma.LongGapAlignmentSampler;
import nuts.math.MeasureZeroException;
import nuts.util.Arbre;
import nuts.util.CollUtils;
import pepper.Encodings;

public class LineageSampler
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final ObservationsTracker obsTracker;
    private final AlignmentSamplerInterface alignSampler;
    private final Arbre<DerivationTree.LineagedNode> lineagedTree;
    private final Taxon smallMoveLang;
    private final boolean useIndepChain;
    private Arbre<LineageTransitions> compiledTransitionsTree = null;
    private DirectedTreeSampler.InitialDistribution rootDistribution = null;
    private DirectedTreeSampler.StdDirectedTreeSampler directedTreeSampler = null;
    private final TreeSamplers.AncestryMCMCKernelOptions options;
    private TreeSamplers.AncestryMCMCKernelOptions.RestrictType restrictType;
    public final Set<Taxon> languagesToResample;
    private double annealExp = 1.0;
    private double pathLogPr = Double.NaN;
    private static List<String> allStringsCache;
    private static int cacheMaxLength;
    private List<String> _indepCache = null;
    private static int MAXSIZE;
    private static double[][] table;

    public Arbre<DerivationTree.LineagedNode> getInitialLineagedTree() {
        return this.lineagedTree.copy();
    }

    public Encodings getEncodings() {
        return this.alignSampler.getEncodings();
    }

    public LineageSampler(ObservationsTracker obsTracker, Arbre<DerivationTree.LineagedNode> lineagedTree, AlignmentSamplerInterface alignSampler, TreeSamplers.AncestryMCMCKernelOptions options) {
        this(obsTracker, lineagedTree, alignSampler, options, null, false);
    }

    public LineageSampler(ObservationsTracker obsTracker, Arbre<DerivationTree.LineagedNode> lineagedTree, AlignmentSamplerInterface alignSampler, TreeSamplers.AncestryMCMCKernelOptions options, Taxon smallMoveLang, boolean useIndepChain) {
        this.smallMoveLang = smallMoveLang;
        this.options = options;
        this.languagesToResample = this.languagesToResample(smallMoveLang, lineagedTree, obsTracker);
        this.obsTracker = obsTracker;
        this.lineagedTree = lineagedTree;
        this.alignSampler = alignSampler;
        this.useIndepChain = useIndepChain;
    }

    private Set<Taxon> languagesToResample(Taxon smallMoveLang, Arbre<DerivationTree.LineagedNode> lineagedTree, ObservationsTracker obsTracker) {
        ArrayList<Taxon> all = new ArrayList<Taxon>(ObservationsTracker.allObservationsTracker(DerivationTree.derivation(lineagedTree)).observedLanguages());
        all.removeAll(obsTracker.observedLanguages());
        if (smallMoveLang == null) {
            this.restrictType = TreeSamplers.AncestryMCMCKernelOptions.RestrictType.FALSE;
            return new HashSet<Taxon>(all);
        }
        this.restrictType = this.options.restrictToObservedSymbols;
        return Collections.singleton(smallMoveLang);
    }

    public LineageSampler newInstance(Arbre<DerivationTree.LineagedNode> lineagedTree) {
        if (this.useIndepChain) {
            throw new RuntimeException();
        }
        return new LineageSampler(this.obsTracker, lineagedTree, this.alignSampler, this.options, this.smallMoveLang, this.useIndepChain);
    }

    public void setAnnealExp(double exp) {
        this.annealExp = exp;
    }

    public double getAnnealExp() {
        return this.annealExp;
    }

    private void compile() {
        if (this.directedTreeSampler == null) {
            Set<Character> allowedSymbols = this.restrictType != TreeSamplers.AncestryMCMCKernelOptions.RestrictType.FALSE ? this.allowedSymbols(this.lineagedTree.root()) : null;
            this.compiledTransitionsTree = this.lineagedTree.preOrderMap(new LineageCompilerMap(allowedSymbols));
            this.rootDistribution = this.createInitialDistribution(this.topWordsAndNeighbors(this.compiledTransitionsTree), this.lineagedTree.root().getContents().getDerivationNode().getLanguage());
            this.directedTreeSampler = DirectedTreeSampler.createSampler(this.compiledTransitionsTree, this.rootDistribution, false, Double.NaN, false);
        }
    }

    private List<String> topWordsAndNeighbors(Arbre<LineageTransitions> compiledTransitionsTree) {
        LineageTransitions child = compiledTransitionsTree.getChildren().get(0).getContents();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < child.nTopStates(); ++i) {
            String fullWord = child.topStateIndex2Word(i);
            DerivationTree.WindowSwap ws = child.topWindowSwap(i);
            DerivationTree.Window win = ws.swappedWindow();
            int left = win.left();
            int right = win.right();
            boolean padToLeft = false;
            boolean padToRight = false;
            if (left > 0) {
                --left;
            } else {
                padToLeft = true;
            }
            if (right < fullWord.length()) {
                ++right;
            } else {
                padToRight = true;
            }
            win = new DerivationTree.Window(left, right);
            String curStr = win.slice(fullWord);
            if (padToLeft) {
                curStr = this.getEncodings().boundChar() + curStr;
            }
            if (padToRight) {
                curStr = curStr + this.getEncodings().boundChar();
            }
            result.add(curStr);
        }
        return result;
    }

    private Set<Character> allowedSymbols(Arbre<DerivationTree.LineagedNode> tree) {
        HashSet<Character> result = new HashSet<Character>();
        if (this.obsTracker.isObserved(tree.getContents().getDerivationNode().getLanguage())) {
            String word = tree.getContents().getDerivationNode().getWord();
            DerivationTree.Window currentWindow = this.restrictType == TreeSamplers.AncestryMCMCKernelOptions.RestrictType.WIN ? tree.getContents().getWindow() : new DerivationTree.Window(0, word.length());
            for (int i = currentWindow.left(); i < currentWindow.right(); ++i) {
                result.add(Character.valueOf(word.charAt(i)));
            }
        }
        for (Arbre<DerivationTree.LineagedNode> child : tree.getChildren()) {
            result.addAll(this.allowedSymbols(child));
        }
        return result;
    }

    public Arbre<DerivationTree.LineagedNode> sample(Random rand) throws MeasureZeroException {
        this.compile();
        try {
            this.directedTreeSampler.setAnnealExp(this.annealExp);
            Arbre<Integer> rawSample = this.directedTreeSampler.sample(rand);
            this.pathLogPr = this.directedTreeSampler.logQ(rawSample);
            return this.decompileSample(this.compiledTransitionsTree, rawSample, rand);
        }
        catch (MeasureZeroException mze) {
            this.pathLogPr = Double.NaN;
            throw mze;
        }
    }

    public double getSumLogPr() {
        this.compile();
        return this.directedTreeSampler.getSumLogPr();
    }

    public double estimateScores(Arbre<DerivationTree.LineagedNode> state) throws MeasureZeroException {
        this.compile();
        try {
            Arbre<Integer> transformedSample = this.transformSample(state, this.compiledTransitionsTree);
            this.pathLogPr = this.directedTreeSampler.logQ(transformedSample);
            return this.pathLogPr;
        }
        catch (MeasureZeroException mze) {
            this.pathLogPr = Double.NaN;
            throw mze;
        }
    }

    private Arbre<Integer> transformSample(Arbre<DerivationTree.LineagedNode> state, Arbre<LineageTransitions> compiledTransitionsTree) throws MeasureZeroException {
        int nChildren = state.getChildren().size();
        if (nChildren != compiledTransitionsTree.getChildren().size()) {
            throw new RuntimeException("Internal error in transformSamle");
        }
        String word = state.getContents().getDerivationNode().getWord();
        Integer currentIndex = compiledTransitionsTree.isRoot() ? compiledTransitionsTree.getChildren().get(0).getContents().getTopIndex(word) : compiledTransitionsTree.getContents().getBottomIndex(word);
        if (currentIndex == null) {
            throw new MeasureZeroException("Chain not reversible!");
        }
        ArrayList children = new ArrayList();
        for (int i = 0; i < nChildren; ++i) {
            children.add(this.transformSample(state.getChildren().get(i), compiledTransitionsTree.getChildren().get(i)));
        }
        return new Arbre<Integer>(currentIndex, children);
    }

    public double pathLogPr() {
        return this.pathLogPr;
    }

    private Arbre<DerivationTree.LineagedNode> decompileSample(Arbre<LineageTransitions> currentTrans, Arbre<Integer> currentSampleTree, Random rand) {
        DerivationTree.LineagedNode newLineagedNode;
        int bottomSample = currentSampleTree.getContents();
        if (currentTrans.isRoot()) {
            LineageTransitions childTrans = currentTrans.getChildren().get(0).getContents();
            DerivationTree.WindowSwap topWindowSwap = childTrans.topWindowSwap(bottomSample);
            DerivationTree.Window newWindow = topWindowSwap.swappedWindow();
            String newWord = topWindowSwap.swappedWord();
            Taxon language = childTrans.topLang;
            assert (currentTrans.getChildren().size() < 2 || currentTrans.getChildren().get(1).getContents().topWindowSwap(bottomSample).swappedWord().equals(newWord));
            DerivationTree.DerivationNode newDerivationNode = new DerivationTree.DerivationNode(language, newWord);
            newLineagedNode = new DerivationTree.LineagedNode(newDerivationNode, newWindow);
        } else {
            int topSample = currentSampleTree.getParent().getContents();
            LineageTransitions trans = currentTrans.getContents();
            DerivationTree.Derivation newDerivation = trans.sampleDerivationGivenTransition(rand, topSample, bottomSample);
            DerivationTree.WindowSwap bottomWindowSwap = trans.bottomWindowSwap(bottomSample);
            DerivationTree.Window newWindow = bottomWindowSwap.swappedWindow();
            String newWord = bottomWindowSwap.swappedWord();
            Taxon language = trans.bottomLang;
            DerivationTree.DerivationNode newDeriationNode = new DerivationTree.DerivationNode(language, newWord, newDerivation);
            newLineagedNode = new DerivationTree.LineagedNode(newDeriationNode, newWindow);
        }
        Arbre<DerivationTree.LineagedNode> result = Arbre.arbre(newLineagedNode);
        for (int i = 0; i < currentTrans.getChildren().size(); ++i) {
            Arbre<DerivationTree.LineagedNode> currentChild = this.decompileSample(currentTrans.getChildren().get(i), currentSampleTree.getChildren().get(i), rand);
            assert (currentChild.getContents().getDerivationNode().getDerivation().getAncestorWord().equals(newLineagedNode.getDerivationNode().getWord()));
            result.addLeaves(currentChild);
        }
        return result;
    }

    private double meanLengthOfObservedSeqns() {
        double total = 0.0;
        double n = 0.0;
        for (Arbre<DerivationTree.LineagedNode> node : this.lineagedTree.nodes()) {
            if (!this.obsTracker.isObserved(node.getContents().getDerivationNode().getLanguage())) continue;
            total += (double)node.getContents().getDerivationNode().getWord().length();
            n += 1.0;
        }
        return total / n;
    }

    private DirectedTreeSampler.InitialDistribution createInitialDistribution(List<String> words, Taxon lang) {
        double[] prs = new double[words.size()];
        for (int i = 0; i < prs.length; ++i) {
            prs[i] = this.alignSampler.getRootPr(words.get(i), lang);
        }
        return new DirectedTreeSampler.ArrayInitialDistribution(prs);
    }

    public final double getFullLogPr(Arbre<DerivationTree.DerivationNode> sample) {
        double result = 0.0;
        result = sample.isRoot() ? (result += this.alignSampler.getFullRootLogPr(sample.getContents().getWord(), sample.getContents().getLanguage())) : (result += this.alignSampler.sumFullLogPr(sample.getContents().getLanguage(), sample.getParent().getContents().getWord(), sample.getContents().getWord()));
        if (result == Double.NEGATIVE_INFINITY) {
            throw new RuntimeException("Internal error in LineageSamler.getFullLogPr");
        }
        for (Arbre<DerivationTree.DerivationNode> child : sample.getChildren()) {
            result += this.getFullLogPr(child);
        }
        return result;
    }

    public String toString() {
        if (this.compiledTransitionsTree == null) {
            return "Not compiled yet";
        }
        return this.compiledTransitionsTree.preOrderMap(new LinTransPrintMap()).deepToString();
    }

    private static Integer getIndex(String newWord, String originalWord, DerivationTree.Window originalWindow, List<String> substitutes) {
        DerivationTree.Window newWindow;
        String outsideStr2;
        int rightOffSet = originalWord.length() - originalWindow.right();
        int newRight = newWord.length() - rightOffSet;
        if (newRight < originalWindow.left() || newRight > newWord.length()) {
            return null;
        }
        String subString = newWord.substring(originalWindow.left(), newRight);
        String outsideStr1 = new DerivationTree.WindowSwap(originalWindow, originalWord, "").swappedWord();
        if (!outsideStr1.equals(outsideStr2 = new DerivationTree.WindowSwap(newWindow = new DerivationTree.Window(originalWindow.left(), newRight), newWord, "").swappedWord())) {
            return null;
        }
        int index = Collections.binarySearch(substitutes, subString);
        if (index < 0) {
            return null;
        }
        return index;
    }

    private List<String> substituteStrings(DerivationTree.LineagedNode node, Set<Character> allowedSymbols) {
        if (this.obsTracker.isObserved(LineageSampler.language(node))) {
            return Collections.singletonList(LineageSampler.windowSubstring(node));
        }
        return this.nbhd(LineageSampler.windowSubstring(node), this.getEncodings(), allowedSymbols, LineageSampler.language(node));
    }

    private static String windowSubstring(DerivationTree.LineagedNode node) {
        String word = node.getDerivationNode().getWord();
        DerivationTree.Window window = node.getWindow();
        return word.substring(window.left(), window.right());
    }

    private static Taxon language(DerivationTree.LineagedNode node) {
        return node.getDerivationNode().getLanguage();
    }

    private static List<String> allStrings(int maxLength, Encodings enc, Set<Character> allowedSymbols) {
        if (allowedSymbols != null) {
            throw new RuntimeException("Internal error in LineageSampler.allowedSymbols");
        }
        if (cacheMaxLength == maxLength) {
            return allStringsCache;
        }
        cacheMaxLength = maxLength;
        allStringsCache = new ArrayList<String>();
        allStringsCache.add("".intern());
        for (int currentLength = 1; currentLength <= maxLength; ++currentLength) {
            ArrayList<String> currentLengthStrings = new ArrayList<String>();
            for (String smallerLengthString : allStringsCache) {
                if (smallerLengthString.length() != currentLength - 1) continue;
                for (int i = 0; i < enc.getNumberOfPhonemes(); ++i) {
                    if (enc.getBoundaryPhoneId() == i) continue;
                    currentLengthStrings.add((smallerLengthString + enc.phoneId2Char(i)).intern());
                }
            }
            allStringsCache.addAll(currentLengthStrings);
        }
        assert (CollUtils.isSet(allStringsCache));
        return allStringsCache;
    }

    private List<String> nbhd(String current, Encodings enc, Set<Character> allowedSymbols, Taxon lang) {
        int pos;
        if (!this.languagesToResample.contains(lang)) {
            return Collections.singletonList(current);
        }
        if (this.useIndepChain) {
            return this.indepChainNbhd(current);
        }
        HashSet result = CollUtils.set();
        result.add(current.intern());
        Set<Integer> phoneIdxs = LineageSampler.phoneIdx(allowedSymbols, enc);
        for (pos = 0; pos < current.length(); ++pos) {
            for (int phoneIdx : phoneIdxs) {
                char cChar;
                if (enc.getBoundaryPhoneId() == phoneIdx || (cChar = enc.phoneId2Char(phoneIdx)) == current.charAt(pos)) continue;
                result.add(LineageSampler.substitute(current, pos, cChar).intern());
            }
        }
        for (pos = 0; pos <= current.length(); ++pos) {
            for (int phoneIdx : phoneIdxs) {
                if (enc.getBoundaryPhoneId() == phoneIdx) continue;
                result.add(LineageSampler.insertion(current, pos, enc.phoneId2Char(phoneIdx)).intern());
            }
        }
        for (pos = 0; pos < current.length(); ++pos) {
            result.add(LineageSampler.deletion(current, pos).intern());
        }
        return new ArrayList<String>(result);
    }

    private List<String> indepChainNbhd(String current) {
        if (this._indepCache != null) {
            return this._indepCache;
        }
        HashSet<String> set = new HashSet<String>();
        for (Arbre<DerivationTree.LineagedNode> node : this.lineagedTree.root().nodes()) {
            if (!this.obsTracker.isObserved(node.getContents().getDerivationNode().getLanguage())) continue;
            set.add(node.getContents().getDerivationNode().getWord());
        }
        this._indepCache = new ArrayList<String>(set);
        if (!this._indepCache.contains(current)) {
            throw new RuntimeException();
        }
        return this._indepCache;
    }

    private static Set<Integer> phoneIdx(Set<Character> allowedSymbols, Encodings enc) {
        HashSet<Integer> result = new HashSet<Integer>();
        if (allowedSymbols == null) {
            for (int phoneIdx = 0; phoneIdx < enc.getNumberOfPhonemes(); ++phoneIdx) {
                result.add(phoneIdx);
            }
        } else {
            for (Character currentChar : allowedSymbols) {
                result.add(enc.char2PhoneId(currentChar.charValue()));
            }
        }
        return result;
    }

    private static String substitute(String s, int pos, char substitute) {
        return s.substring(0, pos) + substitute + s.substring(pos + 1, s.length());
    }

    private static String insertion(String s, int pos, char inserted) {
        return s.substring(0, pos) + inserted + s.substring(pos, s.length());
    }

    private static String deletion(String s, int pos) {
        return s.substring(0, pos) + s.substring(pos + 1, s.length());
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException, MeasureZeroException {
        LineageSampler sampler = LineageSampler.restoreHeldout("data/core_dump_fwd1201057370747");
        LineageSampler revSampler = LineageSampler.restoreHeldout("data/core_dump_rev1201057370747");
        revSampler.estimateScores(sampler.getInitialLineagedTree());
    }

    public static void saveLineageSampler(LineageSampler sampler, String filePath) throws IOException {
        ObjectOutputStream oos = IOUtils.openBinOut(filePath);
        oos.writeObject(sampler);
        oos.close();
    }

    public static LineageSampler restoreHeldout(String filePath) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = IOUtils.openBinIn(filePath);
        return (LineageSampler)ois.readObject();
    }

    static {
        cacheMaxLength = -1;
        MAXSIZE = 7;
        table = new double[MAXSIZE][MAXSIZE + 1];
    }

    public static class FissionBasedAlignmentSampler
    implements AlignmentSamplerInterface {
        private final ParamsTracker params;
        private final EditsTracker editsTracker;
        private DerivationTree.Derivation d;
        private DerivationTree.Window top;
        private DerivationTree.Window bottom;
        private Taxon bottomLanguage;

        public EditsTracker getEditsTracker() {
            return this.editsTracker;
        }

        @Override
        public void setAnneal(double anneal) {
            if (anneal != 1.0) {
                throw new RuntimeException("Anneal unsup in Fission");
            }
        }

        @Override
        public void init(DerivationTree.Derivation d, DerivationTree.Window top, DerivationTree.Window bottom, Taxon bottomNodeId) {
            this.d = d;
            this.top = top;
            this.bottom = bottom;
            this.bottomLanguage = bottomNodeId;
        }

        @Override
        public Encodings getEncodings() {
            return this.params.getEncodings();
        }

        @Override
        public DerivationTree.Derivation sample(Random rand) {
            AlignmentSampler sampler = new AlignmentSampler(this.params.getEditParam(this.bottomLanguage), this.d, this.bottom, this.top, table);
            try {
                sampler.sample(rand);
            }
            catch (MeasureZeroException mze) {
                throw new RuntimeException(mze);
            }
            AlignmentSampler.PartialAlignmentSample partialAlignment = sampler.getSample();
            this.editsTracker.update(this.bottomLanguage, partialAlignment.getEditsList());
            return partialAlignment.getDerivation();
        }

        @Override
        public double sumPr() {
            AlignmentSampler sampler = new AlignmentSampler(this.params.getEditParam(this.bottomLanguage), this.d, this.bottom, this.top, table);
            return sampler.getMarginalPr();
        }

        public FissionBasedAlignmentSampler(ParamsTracker params, EditsTracker editsTracker) {
            this.params = params;
            this.editsTracker = editsTracker;
        }

        @Override
        public double getRootPr(String word, Taxon lang) {
            return Math.exp(this.params.getRootPhonemeModel().getLogProb(word));
        }

        @Override
        public double sumFullLogPr(Taxon bottomNodeId, String top, String bottom) {
            DerivationTree.Window fullTopWin = new DerivationTree.Window(0, top.length());
            DerivationTree.Window fullBotWin = new DerivationTree.Window(0, bottom.length());
            AlignmentSampler sampler = new AlignmentSampler(this.params.getEditParam(this.bottomLanguage), this.d, fullBotWin, fullTopWin, table);
            return sampler.getMarginalPr();
        }

        @Override
        public double getFullRootLogPr(String word, Taxon lang) {
            return this.getRootPr(word, lang);
        }
    }

    public static class LongGapAlignmentSamplerAdaptor
    implements AlignmentSamplerInterface {
        private final Map<Taxon, ? extends AffineGapAlignmentSampler.GapAlignmentParams> params;
        private final HLParams hlParams;
        private DerivationTree.Derivation d;
        private DerivationTree.Window topWindow;
        private DerivationTree.Window bottomWindow;
        private String topStr;
        private String bottomStr;
        private Taxon bottomNodeId;
        private double anneal = 1.0;
        public static final int CACHED_ARRAY_SIZE = 7;
        private final double[][][] _survTable = new double[3][7][7];
        private final double[][][] _deathTable = new double[3][7][7];
        private final double[][] _table = new double[7][7];

        @Override
        public void setAnneal(double anneal) {
            this.anneal = anneal;
        }

        public LongGapAlignmentSamplerAdaptor(Map<Taxon, AffineGapAlignmentSampler.GapAlignmentParams> params) {
            this.params = params;
            this.hlParams = null;
        }

        public LongGapAlignmentSamplerAdaptor(HLParams hlParams) {
            this.params = hlParams.getBranchParams();
            this.hlParams = hlParams;
        }

        @Override
        public Encodings getEncodings() {
            return this.params.values().iterator().next().getEncodings();
        }

        @Override
        public double getRootPr(String word, Taxon lang) {
            if (this.hlParams == null) {
                throw new RuntimeException("HLParams should not be null in getRootPr");
            }
            String segment = word.substring(1, word.length());
            char prefix = word.charAt(0);
            return this.hlParams.getRootPr(prefix, segment, lang);
        }

        @Override
        public double getFullRootLogPr(String word, Taxon lang) {
            if (this.hlParams == null) {
                throw new RuntimeException("HLParams should not be null in getFullRootLogPr");
            }
            return this.hlParams.getRootLogPr(word, lang);
        }

        @Override
        public void init(DerivationTree.Derivation d, DerivationTree.Window top, DerivationTree.Window bottom, Taxon bottomNodeId) {
            this.bottomNodeId = bottomNodeId;
            this.d = d;
            this.topWindow = top;
            this.bottomWindow = bottom;
            this.topStr = d.getAncestorWord().substring(top.left(), top.right());
            this.bottomStr = d.getCurrentWord().substring(bottom.left(), bottom.right());
        }

        public static DerivationTree.Derivation replaceDerivation(DerivationTree.Derivation original, DerivationTree.Window topWindow, DerivationTree.Window bottomWindow, DerivationTree.Derivation newD) {
            int length = original.getCurrentWord().length();
            int[] ancestors = new int[length];
            for (int i = 0; i < length; ++i) {
                if (bottomWindow.contains(i)) {
                    int relIndex = i - bottomWindow.left();
                    if (newD.hasAncestor(relIndex)) {
                        int ancestorAbsIndex = newD.ancestor(relIndex) + topWindow.left();
                        assert (topWindow.contains(ancestorAbsIndex));
                        ancestors[i] = ancestorAbsIndex;
                        continue;
                    }
                    ancestors[i] = -1;
                    continue;
                }
                if (original.hasAncestor(i)) {
                    ancestors[i] = original.ancestor(i);
                    assert (!topWindow.contains(original.ancestor(i)));
                    continue;
                }
                ancestors[i] = -1;
            }
            return new DerivationTree.Derivation(ancestors, original.getAncestorWord(), original.getCurrentWord());
        }

        @Override
        public DerivationTree.Derivation sample(Random rand) {
            AffineGapAlignmentSampler sampler = this.createSampler(this.anneal);
            DerivationTree.Derivation newD = null;
            try {
                newD = sampler.sample(rand);
            }
            catch (LongGapAlignmentSampler.ArithmeticPrecisionException ape) {
                LogInfo.warning("Warning: an underflow occurred in sample().. backtracking to max");
                try {
                    newD = sampler.mode();
                }
                catch (MeasureZeroException e) {
                    throw new RuntimeException("Should not get here");
                }
            }
            catch (MeasureZeroException mze) {
                throw new RuntimeException(mze);
            }
            DerivationTree.Derivation result = LongGapAlignmentSamplerAdaptor.replaceDerivation(this.d, this.topWindow, this.bottomWindow, newD);
            assert (result.isMonotonic());
            return result;
        }

        @Override
        public double sumPr() {
            AffineGapAlignmentSampler sampler = this.createSampler(1.0);
            double result = Double.NaN;
            result = sampler.getSumPr();
            return result;
        }

        private AffineGapAlignmentSampler createSampler(double anneal) {
            AffineGapAlignmentSampler.GapAlignmentParams param = this.params.get(this.bottomNodeId);
            AffineGapAlignmentSampler sampler = null;
            sampler = this.hlParams == null ? AffineGapAlignmentSampler.createAffineGapAlignmentSampler(this.topStr, this.bottomStr, param) : AffineGapAlignmentSampler.createHLAlignmentSampler(this.topWindow, this.bottomWindow, this.d, (HLParams.HLBranchParams)param, this._survTable, this._deathTable, this._table);
            sampler.setExponent(anneal);
            return sampler;
        }

        @Override
        public double sumFullLogPr(Taxon bottomNodeId, String top, String bottom) {
            AffineGapAlignmentSampler.GapAlignmentParams param = this.params.get(bottomNodeId);
            AffineGapAlignmentSampler sampler = AffineGapAlignmentSampler.createAffineGapAlignmentSampler(top, bottom, param);
            sampler.activateLogMode();
            return sampler.getSumLogPr();
        }

        public static class NaNException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            public NaNException(String msg) {
                super(msg);
            }
        }
    }

    public static class ReversedAlignmentModelAdaptor
    implements AlignmentSamplerInterface {
        private final AlignmentSamplerInterface asi;

        public ReversedAlignmentModelAdaptor(AlignmentSamplerInterface in) {
            this.asi = in;
        }

        @Override
        public Encodings getEncodings() {
            return this.asi.getEncodings();
        }

        @Override
        public double getRootPr(String word, Taxon lang) {
            System.err.println("Warning: not tested..");
            return this.asi.getRootPr(word, lang);
        }

        @Override
        public void init(DerivationTree.Derivation d, DerivationTree.Window top, DerivationTree.Window bottom, Taxon bottomNodeId) {
            this.asi.init(d.invert(), bottom, top, bottomNodeId);
        }

        @Override
        public DerivationTree.Derivation sample(Random rand) {
            return this.asi.sample(rand).invert();
        }

        @Override
        public void setAnneal(double anneal) {
            this.asi.setAnneal(anneal);
        }

        @Override
        public double sumFullLogPr(Taxon bottomNodeId, String top, String bottom) {
            return this.asi.sumFullLogPr(bottomNodeId, bottom, top);
        }

        @Override
        public double sumPr() {
            return this.asi.sumPr();
        }

        @Override
        public double getFullRootLogPr(String word, Taxon lang) {
            throw new RuntimeException("Unsup op");
        }
    }

    public static interface AlignmentSamplerInterface {
        public void init(DerivationTree.Derivation var1, DerivationTree.Window var2, DerivationTree.Window var3, Taxon var4);

        public double sumPr();

        public DerivationTree.Derivation sample(Random var1);

        public Encodings getEncodings();

        public double getRootPr(String var1, Taxon var2);

        public double getFullRootLogPr(String var1, Taxon var2);

        public void setAnneal(double var1);

        public double sumFullLogPr(Taxon var1, String var2, String var3);
    }

    public class LineageTransitions
    implements DirectedTreeSampler.TransitionKernel {
        private static final long serialVersionUID = 1L;
        private final DirectedTreeSampler.TransitionKernel kernel;
        private final AlignmentSamplerInterface alignSampler;
        private final List<String> currentSubstituteStrings;
        private final List<String> parentSubstituteStrings;
        private final Taxon topLang;
        private final Taxon bottomLang;
        private final DerivationTree.Derivation derivation;
        private final DerivationTree.Window bottomOriginalWindow;
        private final DerivationTree.Window topOriginalWindow;
        private final String topOriginalWord;
        private final String bottomOriginalWord;

        public String toString() {
            return "Top:" + this.parentSubstituteStrings + "\nBot:" + this.currentSubstituteStrings + "\n" + this.kernel.toString();
        }

        public Integer getBottomIndex(String word) {
            return LineageSampler.getIndex(word, this.bottomOriginalWord, this.bottomOriginalWindow, this.currentSubstituteStrings);
        }

        public Integer getTopIndex(String word) {
            return LineageSampler.getIndex(word, this.topOriginalWord, this.topOriginalWindow, this.parentSubstituteStrings);
        }

        public LineageTransitions(Arbre<DerivationTree.LineagedNode> lineagedTree, List<String> parentSubstituteStrings, List<String> currentSubstituteStrings, AlignmentSamplerInterface alignSampler) {
            assert (CollUtils.isSet(parentSubstituteStrings) && CollUtils.isSet(currentSubstituteStrings));
            assert (!lineagedTree.isRoot());
            this.alignSampler = alignSampler;
            DerivationTree.LineagedNode lineagedNode = lineagedTree.getContents();
            this.bottomLang = lineagedNode.getDerivationNode().getLanguage();
            this.topLang = lineagedTree.getParent().getContents().getDerivationNode().getLanguage();
            this.currentSubstituteStrings = new ArrayList<String>(currentSubstituteStrings);
            this.parentSubstituteStrings = new ArrayList<String>(parentSubstituteStrings);
            Collections.sort(this.currentSubstituteStrings);
            Collections.sort(this.parentSubstituteStrings);
            this.derivation = lineagedNode.getDerivationNode().getDerivation();
            this.bottomOriginalWindow = lineagedNode.getWindow();
            this.topOriginalWindow = lineagedTree.getParent().getContents().getWindow();
            this.topOriginalWord = this.derivation.getAncestorWord();
            this.bottomOriginalWord = this.derivation.getCurrentWord();
            this.kernel = this.constructKernel();
        }

        private DerivationTree.WindowSwap windowSwap(int stateIndex, boolean isTop) {
            DerivationTree.Window originalWindow = isTop ? this.topOriginalWindow : this.bottomOriginalWindow;
            String originalWord = isTop ? this.topOriginalWord : this.bottomOriginalWord;
            String substituteString = (isTop ? this.parentSubstituteStrings : this.currentSubstituteStrings).get(stateIndex);
            return new DerivationTree.WindowSwap(originalWindow, originalWord, substituteString);
        }

        public DerivationTree.WindowSwap topWindowSwap(int s) {
            return this.windowSwap(s, true);
        }

        public DerivationTree.WindowSwap bottomWindowSwap(int s) {
            return this.windowSwap(s, false);
        }

        public String topStateIndex2Word(int s) {
            return this.topWindowSwap(s).swappedWord();
        }

        public String bottomStateIndex2Word(int s) {
            return this.bottomWindowSwap(s).swappedWord();
        }

        private DirectedTreeSampler.TransitionKernel constructKernel() {
            this.alignSampler.setAnneal(1.0);
            double[][] prs = new double[this.parentSubstituteStrings.size()][this.currentSubstituteStrings.size()];
            for (int topIndex = 0; topIndex < this.parentSubstituteStrings.size(); ++topIndex) {
                DerivationTree.WindowSwap topSwap = this.topWindowSwap(topIndex);
                for (int bottomIndex = 0; bottomIndex < this.currentSubstituteStrings.size(); ++bottomIndex) {
                    DerivationTree.WindowSwap bottomSwap = this.bottomWindowSwap(bottomIndex);
                    DerivationTree.Derivation swappedDerivation = this.derivation.windowSwap(topSwap, bottomSwap);
                    this.alignSampler.init(swappedDerivation, topSwap.swappedWindow(), bottomSwap.swappedWindow(), this.bottomLang);
                    prs[topIndex][bottomIndex] = this.alignSampler.sumPr();
                }
            }
            return new DirectedTreeSampler.ArrayTransitionKernel(prs);
        }

        public DerivationTree.Derivation sampleDerivationGivenTransition(Random rand, int topIndex, int bottomIndex) {
            this.alignSampler.setAnneal(LineageSampler.this.getAnnealExp());
            DerivationTree.WindowSwap topSwap = this.topWindowSwap(topIndex);
            DerivationTree.WindowSwap bottomSwap = this.bottomWindowSwap(bottomIndex);
            DerivationTree.Derivation d = this.derivation.windowSwap(topSwap, bottomSwap);
            DerivationTree.Derivation swappedDeriv = this.derivation.windowSwap(topSwap, bottomSwap);
            this.alignSampler.init(swappedDeriv, topSwap.swappedWindow(), bottomSwap.swappedWindow(), this.bottomLang);
            return this.alignSampler.sample(rand);
        }

        @Override
        public int nTopStates() {
            return this.kernel.nTopStates();
        }

        @Override
        public int nBottomStates() {
            return this.kernel.nBottomStates();
        }

        @Override
        public double pr(int currentState, int nextState) {
            return this.kernel.pr(currentState, nextState);
        }

        @Override
        public int sample(int currentState, Random rand) {
            return this.kernel.sample(currentState, rand);
        }
    }

    public static class LinTransPrintMap
    extends Arbre.ArbreMap<LineageTransitions, String> {
        @Override
        public String map(Arbre<LineageTransitions> currentDomainNode) {
            String word = currentDomainNode.isRoot() ? currentDomainNode.getChildren().get(0).getContents().topOriginalWord : currentDomainNode.getContents().bottomOriginalWord;
            Taxon lang = currentDomainNode.isRoot() ? currentDomainNode.getChildren().get(0).getContents().topLang : currentDomainNode.getContents().bottomLang;
            DerivationTree.Window win = currentDomainNode.isRoot() ? currentDomainNode.getChildren().get(0).getContents().topOriginalWindow : currentDomainNode.getContents().bottomOriginalWindow;
            int stateSize = currentDomainNode.isRoot() ? currentDomainNode.getChildren().get(0).getContents().nTopStates() : currentDomainNode.getContents().nBottomStates();
            word = "..." + word.substring(win.left(), win.right()) + "...";
            return lang.toString() + ":" + word + " (" + stateSize + " states)";
        }
    }

    private class LineageCompilerMap
    extends Arbre.ArbreMap<DerivationTree.LineagedNode, LineageTransitions>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Set<Character> allowedSymbols;

        public LineageCompilerMap(Set<Character> allowedSymbol) {
            this.allowedSymbols = allowedSymbol;
        }

        @Override
        public LineageTransitions map(Arbre<DerivationTree.LineagedNode> tree) {
            if (tree.isRoot()) {
                return null;
            }
            DerivationTree.LineagedNode lineage = tree.getContents();
            List parentSubstituteStrings = LineageSampler.this.substituteStrings(tree.getParent().getContents(), this.allowedSymbols);
            List currentSubstitueStrings = LineageSampler.this.substituteStrings(lineage, this.allowedSymbols);
            return new LineageTransitions(tree, parentSubstituteStrings, currentSubstitueStrings, LineageSampler.this.alignSampler);
        }
    }

    public static class LineageSizeExceededException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public LineageSizeExceededException(Arbre<DerivationTree.LineagedNode> lineagedTree) {
            super("Lineage of initial state exceeds max lineage: \n" + lineagedTree.deepToString());
        }
    }
}

