/*
 * Decompiled with CFR 0.152.
 */
package ma;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import ma.MultiAlignment;

public class PrepareCorpus {
    public static void main(String[] args) throws Exception {
    }

    private static int nProteinsInFile(String msfFile) throws IOException {
        MultiAlignment ma = null;
        try {
            ma = MultiAlignment.parseMSFToMultiAlignment(msfFile);
        }
        catch (Exception e) {
            throw new RuntimeException("problem with " + msfFile);
        }
        return ma.getSequences().size();
    }

    private static int maxProteinL(String msfFile) throws IOException {
        MultiAlignment ma = MultiAlignment.parseMSFToMultiAlignment(msfFile);
        int max = Integer.MIN_VALUE;
        for (String seq : ma.getSequences().values()) {
            if (seq.length() <= max) continue;
            max = seq.length();
        }
        return max;
    }

    private static void checkHeldout(Set<String> heldoutProteins, File heldoutDir, File currentDir, String fileName) {
        for (String protein : heldoutProteins) {
            if (!PrepareCorpus.proteinName(fileName).equals(protein)) continue;
            File ori = new File(currentDir, fileName);
            String newName = fileName.replaceAll("ref.", "ref0");
            File dest = new File(heldoutDir, newName);
            ori.renameTo(dest);
            return;
        }
    }

    public static String proteinName(String fileName) {
        return fileName.replaceAll("[_]ref.*", "").replaceAll("[.].*", "");
    }

    public static String proteinName(File file) {
        return PrepareCorpus.proteinName(file.getName());
    }
}

