/*
 * Decompiled with CFR 0.152.
 */
package nuts.io;

import fig.basic.CharEncUtils;
import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.OptionsParser;
import fig.basic.StrUtils;
import fig.exec.Execution;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import nuts.io.BufferedReaderIterator;
import nuts.io.CSVReaderIterator;
import nuts.io.IteratorWrapper;
import nuts.lang.ProductIterator;
import nuts.lang.StringUtils;
import nuts.tui.Table;
import nuts.util.CollUtils;
import nuts.util.EasyFormat;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;

public class IO {
    private static Set<String> sentMessages = CollUtils.set();

    public static String cleanFileName(String str) {
        return str.replaceAll("[~/\\?%*:|\"<>]", "_");
    }

    public static File fileFromResource(String path) {
        ClassLoader resourcesloader = IO.class.getClassLoader();
        return new File(resourcesloader.getResource(path).getFile());
    }

    public static void run(String[] args, Object ... objects) {
        File execs;
        File state = new File("state");
        if (!state.exists()) {
            state.mkdir();
        }
        if ((execs = new File(state, "execs")).exists()) {
            execs.mkdir();
        }
        Execution.monitor = true;
        Execution.makeThunk = false;
        Execution.create = true;
        Execution.useStandardExecPoolDirStrategy = true;
        Execution.run(args, objects);
    }

    public static void runLight(String[] args, Object ... objects) {
        OptionsParser op = new OptionsParser(objects);
        if (!op.doParse(args)) {
            System.exit(1);
        }
        ((Runnable)objects[0]).run();
    }

    public static void parseOptions(String[] args, Object ... objects) {
        OptionsParser op = new OptionsParser(objects);
        if (!op.doParse(args)) {
            System.exit(1);
        }
    }

    public static File getTempDir() {
        return IO.getTempDir("temp");
    }

    public static File getTempDir(String descr) {
        String path = Execution.getFile(descr);
        if (path == null) {
            path = "./";
        }
        File temps = new File(path);
        temps.mkdir();
        File f = new File(temps, "time=" + System.currentTimeMillis() + ",thread=" + Thread.currentThread().getId());
        f.mkdir();
        return f;
    }

    public static boolean rmDir(File f) {
        for (File f2 : IO.ls(f)) {
            if (f2.delete()) continue;
            return false;
        }
        boolean result = f.delete();
        return result;
    }

    public static void appendLine(String fileInExec, String key, String value) {
        PrintWriter out = IOUtils.openOutAppendHard(Execution.getFile(fileInExec));
        out.append((key != null ? key + "\t" : "") + value + '\n');
        out.close();
    }

    public static void appendLine(String fileInExec, int i, SummaryStatistics stat) {
        IO.appendLine(fileInExec, "" + i, EasyFormat.fmt2(stat.getMean()));
    }

    public static String appendSuffix(String baseName, String suffix) {
        if (suffix == null || suffix.equals("")) {
            return baseName;
        }
        return baseName + "." + suffix;
    }

    public static String nameWithoutExtension(File file) {
        String name = file.getName();
        if (!name.contains(".")) {
            return name;
        }
        return StringUtils.selectFirstRegex("^(.*)(?:[.][^.]*)$", name);
    }

    public static String extension(File file) {
        String fileName = file.getName();
        if (!fileName.contains(".")) {
            return null;
        }
        return StringUtils.selectFirstRegex("[.]([^.]*)$", fileName);
    }

    public static List<File> locate(File root, String suffixFilter) {
        return IO.locate(root, IO.suffixFilter(suffixFilter));
    }

    public static List<File> locate(File root, FilenameFilter filter) {
        ArrayList<File> result = new ArrayList<File>();
        IO.locate(root, result, filter);
        return result;
    }

    private static void locate(File root, List<File> files, FilenameFilter fileFilter) {
        if (root.isFile() && fileFilter.accept(root.getParentFile(), root.getName())) {
            files.add(root);
        }
        if (root.isDirectory()) {
            File[] children = root.listFiles();
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                IO.locate(child, files, fileFilter);
            }
        }
    }

    public static List<File> ls(File basePath) {
        return IO.ls(basePath, null);
    }

    public static List<String> ls(String basePath, String suffixFilter) {
        ArrayList<String> result = new ArrayList<String>();
        for (File f : IO.ls(new File(basePath), suffixFilter)) {
            result.add(f.getPath());
        }
        return result;
    }

    public static FilenameFilter suffixFilter(final String ... suffixesWithoutPeriod) {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String file) {
                if (suffixesWithoutPeriod == null || suffixesWithoutPeriod.equals("")) {
                    return true;
                }
                for (String suffixWithoutPeriod : suffixesWithoutPeriod) {
                    if (!file.toUpperCase().matches(".*[.]" + suffixWithoutPeriod.toUpperCase() + "$")) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static List<File> ls(File basePath, String suffixFilter) {
        FilenameFilter filter;
        FilenameFilter filenameFilter = filter = suffixFilter == null || suffixFilter.equals("") ? new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return true;
            }
        } : IO.suffixFilter(suffixFilter);
        if (!basePath.isDirectory()) {
            throw new RuntimeException("Directory does not exists:" + basePath);
        }
        ArrayList<File> result = new ArrayList<File>();
        for (File item : basePath.listFiles(filter)) {
            result.add(item);
        }
        Collections.sort(result);
        return result;
    }

    public static String f2s(String path) {
        return IO.f2s(new File(path));
    }

    public static void cp(File src, File dest) {
        if (dest.isDirectory()) {
            dest = new File(dest, src.getName());
        }
        IO.writeToDisk(dest, IO.f2s(src));
    }

    public static String f2s(File path) {
        StringBuilder result = new StringBuilder();
        for (String line : IO.i(path)) {
            result.append(line);
            result.append('\n');
        }
        return result.toString();
    }

    public static List<String> f2l(File path) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : IO.i(path)) {
            result.add(line);
        }
        return result;
    }

    public static Iterable<String> i(String path) {
        try {
            BufferedReader reader = IOUtils.openIn(path);
            return IteratorWrapper.IW(new BufferedReaderIterator(reader));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static Iterable<List<String>> iCSV(File file) {
        return IO.iCSV(file.getPath());
    }

    public static Iterable<List<String>> iCSV(String path) {
        return CSVReaderIterator.iterate(IOUtils.openInHard(path));
    }

    public static List<Map<String, String>> iCSVMap(File path) {
        return IO.iCSVMap(path.getAbsolutePath());
    }

    public static List<Map<String, String>> iCSVMap(String path) {
        return IO.iCSVMap(IO.iCSV(path));
    }

    public static List<Map<String, String>> iCSVMap(BufferedReader reader) {
        return IO.iCSVMap(CSVReaderIterator.iterate(reader));
    }

    public static List<Map<String, String>> iCSVMap(Iterable<List<String>> iterable) {
        List<String> firstLine = null;
        ArrayList<Map<String, String>> result = CollUtils.list();
        for (List<String> line : iterable) {
            try {
                if (IO.trivialLine(line)) continue;
                if (firstLine == null) {
                    if (line.get(0).charAt(0) == '#') {
                        line.set(0, line.get(0).substring(1));
                    }
                    firstLine = line;
                    continue;
                }
                HashMap cur = CollUtils.map();
                for (int i = 0; i < line.size(); ++i) {
                    if (line.get(i) == null || line.get(i).equals("")) continue;
                    cur.put(firstLine.get(i), line.get(i));
                }
                result.add(cur);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while reading csv. Problematic line is: " + line + "\nDetails");
            }
        }
        return result;
    }

    private static boolean trivialLine(List<String> line) {
        if (line == null) {
            return true;
        }
        if (line.size() == 0) {
            return true;
        }
        return line.size() == 1 && (line.get(0) == null || line.get(0).length() == 0);
    }

    public static Iterable<String> i(File file) {
        return IO.i(file.getPath());
    }

    public static Iterable<List<String>> i(File ... paths) {
        String[] converted = new String[paths.length];
        for (int i = 0; i < converted.length; ++i) {
            converted[i] = paths[i].getPath();
        }
        return IO.i(converted);
    }

    public static Iterable<List<String>> i(String ... paths) {
        try {
            ArrayList<BufferedReaderIterator> readerIterators = new ArrayList<BufferedReaderIterator>();
            for (String path : paths) {
                readerIterators.add(new BufferedReaderIterator(IOUtils.openIn(path)));
            }
            ProductIterator prodIt = new ProductIterator(readerIterators);
            return IteratorWrapper.IW(prodIt);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static Iterable<String> si() {
        try {
            BufferedReader reader = CharEncUtils.getReader(System.in);
            return IteratorWrapper.IW(new BufferedReaderIterator(reader));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void so(Object string) {
        IO.sos(string + "\n");
    }

    public static void so() {
        IO.sos("\n");
    }

    public static void sos(Object string) {
        try {
            PrintWriter out = CharEncUtils.getWriter(System.out);
            out.append(string.toString());
            out.flush();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void se(Object string) {
        IO.ses(string + "\n");
    }

    public static void se() {
        IO.ses("\n");
    }

    public static void ses(Object string) {
        try {
            PrintWriter out = CharEncUtils.getWriter(System.err);
            out.append(string.toString());
            out.flush();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void fs(String file, ReadFile rf) {
        try {
            BufferedReader br = IOUtils.openIn(file);
            String line = null;
            while ((line = br.readLine()) != null && rf.process(line)) {
            }
            br.close();
        }
        catch (IOException e) {
            rf.handleIOException(e);
        }
    }

    public static void fs(String file, WriteFile wf) {
        try {
            PrintWriter out = IOUtils.openOut(file);
            wf.setOut(out);
            wf.process();
            out.close();
        }
        catch (IOException e) {
            wf.handleIOException(e);
        }
    }

    public static void main(String[] args) {
        System.out.println(System.getenv("PATH"));
        System.out.println(System.getProperty("user.home"));
        System.out.println(IO.call("ls"));
    }

    public static String call(String executablePathAndArgs) {
        return IO.call(executablePathAndArgs, null, ResultCodeBehavior.WARN);
    }

    public static String callSafely(String executablePathAndArgs) {
        return IO.call(executablePathAndArgs, null, ResultCodeBehavior.RAISE);
    }

    public static String callQuiet(String executablePathAndArgs) {
        return IO.call(executablePathAndArgs, null, ResultCodeBehavior.IGNORE);
    }

    public static String call(String executablePathAndArgs, String inputStreamContents) {
        return IO.call(executablePathAndArgs, inputStreamContents, ResultCodeBehavior.WARN);
    }

    public static String callSafely(String executablePathAndArgs, String inputStreamContents) {
        return IO.call(executablePathAndArgs, inputStreamContents, ResultCodeBehavior.RAISE);
    }

    public static String callQuiet(String executablePathAndArgs, String inputStreamContents) {
        return IO.call(executablePathAndArgs, inputStreamContents, ResultCodeBehavior.IGNORE);
    }

    public static String call(String executablePathAndArgs, String inputStreamContents, ResultCodeBehavior behavior) {
        return IO.call(executablePathAndArgs, inputStreamContents, behavior, Long.MAX_VALUE, null);
    }

    public static String call(String executablePathAndArgs, String inputStreamContents, File workingDir) {
        return IO.call(executablePathAndArgs, inputStreamContents, ResultCodeBehavior.IGNORE, Long.MAX_VALUE, workingDir);
    }

    public static String call(String executablePathAndArgs, String inputStreamContents, final ResultCodeBehavior behavior, long maxDelay, File workingDir) {
        executablePathAndArgs = IO.checkBinExists(executablePathAndArgs);
        StringBuilder result = new StringBuilder();
        Process _proc = null;
        try {
            Process proc;
            String[] split = executablePathAndArgs.split("\\s+");
            ProcessBuilder pb = new ProcessBuilder(Arrays.asList(split));
            if (workingDir != null) {
                pb.directory(workingDir);
            }
            pb.redirectErrorStream(true);
            _proc = proc = pb.start();
            Timer timer = new Timer();
            if (maxDelay != Long.MAX_VALUE) {
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        behavior.process("Command timed out");
                        proc.destroy();
                    }
                }, maxDelay);
            }
            InputStream stdout = proc.getInputStream();
            InputStreamReader stdoutReader = new InputStreamReader(stdout);
            BufferedReader stdoutBufferedReader = new BufferedReader(stdoutReader);
            String line = null;
            if (inputStreamContents != null) {
                OutputStream stdin = proc.getOutputStream();
                PrintWriter pw = new PrintWriter(stdin);
                pw.append(inputStreamContents);
                pw.close();
            }
            while ((line = stdoutBufferedReader.readLine()) != null) {
                result.append(line + "\n");
            }
            int resultCode = proc.waitFor();
            if (resultCode != 0) {
                behavior.process("Command had suspicious return code (" + resultCode + ")\nCommand:" + executablePathAndArgs + "\nOutput:\n" + result);
            }
            timer.cancel();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            if (_proc != null) {
                try {
                    _proc.getErrorStream().close();
                    _proc.getInputStream().close();
                    _proc.getOutputStream().close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return result.toString();
    }

    public static String checkBinExists(String executablePathAndArgs) {
        String which;
        Object[] fields = executablePathAndArgs.split("\\s+");
        if (new File(fields[0]).exists()) {
            return executablePathAndArgs;
        }
        if (fields.length > 0 && (which = IO.call("/usr/bin/which " + fields[0])).length() > 0) {
            fields[0] = which.replace("\n", "");
            return StrUtils.join(fields);
        }
        throw new RuntimeException("exec does not exist: " + fields[0] + "\ncommand: " + Arrays.toString(fields));
    }

    public static void writeToDisk(File file, String contents) {
        IO.writeToDisk(file.getPath(), contents);
    }

    public static void writeToDisk(File file, List<String> lines) {
        IO.writeToDisk(file.getPath(), StrUtils.join(lines, "\n") + "\n");
    }

    public static void writeToDisk(File file, double[][] mtx) {
        Table t = Table.fromMatrix(mtx, false, false, true);
        IO.writeToDisk(file, t.toString());
    }

    public static void writeToDisk(File file, double[] vec) {
        double[][] mtx = new double[][]{vec};
        Table t = Table.fromMatrix(mtx, false, false, true);
        IO.writeToDisk(file, t.toString());
    }

    public static void writeToDisk(String file, String contents) {
        try {
            PrintWriter out = IOUtils.openOut(file);
            out.append(contents);
            out.close();
        }
        catch (Exception e) {
            LogInfo.warning("Could not write to disk:" + file);
        }
    }

    public static String file2String(File path) {
        StringBuilder result = new StringBuilder();
        for (String line : IO.i(path)) {
            result.append(line + '\n');
        }
        return result.toString();
    }

    public static void warnOnce(String string) {
        if (sentMessages.contains(string)) {
            return;
        }
        sentMessages.add(string);
        LogInfo.warning(string);
    }

    public static enum ResultCodeBehavior {
        IGNORE{

            @Override
            void process(String warnMsg) {
            }
        }
        ,
        WARN{

            @Override
            void process(String warnMsg) {
                LogInfo.warning(warnMsg);
            }
        }
        ,
        STDERR{

            @Override
            public void process(String warnMsg) {
                System.err.println(warnMsg);
            }
        }
        ,
        RAISE{

            @Override
            void process(String warnMsg) {
                throw new RuntimeException(warnMsg);
            }
        };


        abstract void process(String var1);
    }

    public static abstract class WriteFile {
        private PrintWriter out;

        private void setOut(PrintWriter out) {
            this.out = out;
        }

        public final void write(String string) {
            this.out.append(string);
        }

        public void handleIOException(IOException e) {
            throw new RuntimeException(e);
        }

        public abstract void process();
    }

    public static abstract class ReadFile {
        public abstract boolean process(String var1);

        public void handleIOException(IOException e) {
            throw new RuntimeException(e);
        }
    }
}

