/*
 * Decompiled with CFR 0.152.
 */
package nuts.math;

import fig.basic.DoubleRef;
import fig.basic.IOUtils;
import fig.basic.Pair;
import fig.basic.UnorderedPair;
import fig.prob.SampleUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.imageio.ImageIO;
import nuts.io.IO;
import nuts.math.CliqueVisitor;
import nuts.math.GMFct;
import nuts.math.Graph;
import nuts.math.Graphs;
import nuts.math.HashGraph;
import nuts.math.SemiGraph;
import nuts.math.TabularGMFct;
import nuts.math.TreeSumProd;
import nuts.util.CollUtils;
import nuts.util.Indexer;
import nuts.util.MathUtils;

public final class GMFctUtils {
    public static final String stateSpaceSizeFileName = "state-space-size";
    public static final String chainLengthFileName = "chain-length";
    public static final String gridSideName = "grid-side";

    public static <V> String toString(final GMFct<V> fct) {
        final StringBuilder result = new StringBuilder();
        GMFctUtils.visit(fct, new CliqueVisitor<V>(){

            @Override
            public void visitEdge(V n1, V n2, int s1, int s2) {
                result.append("" + n1 + "," + n2 + "@" + s1 + "," + s2 + "=" + fct.get(n1, n2, s1, s2) + "\n");
            }

            @Override
            public void visitVertex(V n, int s) {
                result.append("" + n + "@" + s + "=" + fct.get(n, s) + "\n");
            }
        });
        return result.toString();
    }

    public static <V extends Comparable<V>> boolean hasPositiveMeasure(GMFct<V> pots) {
        try {
            TabularGMFct<V> tabularGMFct = TreeSumProd.computeMoments(pots);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static <V> Indexer<Object> createIndexer(GMFct<V> fct) {
        Indexer<Object> index = new Indexer<Object>();
        for (Object f : fct.graph().vertexSet()) {
            for (int s = 0; s < fct.nStates(f); ++s) {
                index.addToIndex((Object[])new Object[]{Pair.makePair(f, s)});
            }
        }
        for (UnorderedPair unorderedPair : Graphs.edgeSet(fct.graph())) {
            for (int s0 = 0; s0 < fct.nStates(unorderedPair.getFirst()); ++s0) {
                for (int s1 = 0; s1 < fct.nStates(unorderedPair.getSecond()); ++s1) {
                    index.addToIndex((Object[])new Object[]{new UnorderedPair(Pair.makePair(unorderedPair.getFirst(), s0), Pair.makePair(unorderedPair.getSecond(), s1))});
                }
            }
        }
        return index;
    }

    public static void writeChainToDisk(File folderToCreate, GMFct<Integer> gmFct) {
        if (folderToCreate.exists()) {
            if (!folderToCreate.isDirectory()) {
                throw new RuntimeException("Trying to overwrite a non-mrf file " + folderToCreate);
            }
            for (File sub : IO.ls(folderToCreate, "mtx")) {
                sub.delete();
            }
        }
        try {
            PrintWriter out;
            int i;
            folderToCreate.mkdir();
            int graphSize = gmFct.graph().vertexSet().size();
            for (int i2 = 1; i2 < graphSize - 1; ++i2) {
                if (gmFct.graph().nbrs(i2).size() == 2) continue;
                throw new RuntimeException("Not a chain!");
            }
            int stspsize = gmFct.nStates(0);
            for (i = 1; i < graphSize; ++i) {
                if (stspsize == gmFct.nStates(i)) continue;
                throw new RuntimeException();
            }
            IO.writeToDisk(new File(folderToCreate, stateSpaceSizeFileName), "" + stspsize);
            IO.writeToDisk(new File(folderToCreate, chainLengthFileName), "" + graphSize);
            for (i = 1; i < graphSize; ++i) {
                out = IOUtils.openOutEasy(new File(folderToCreate, "pair." + (i - 1) + "-" + i + ".mtx"));
                for (int prev = 0; prev < stspsize; ++prev) {
                    for (int cur = 0; cur < stspsize; ++cur) {
                        out.print("" + gmFct.get(i - 1, i, prev, cur) + " ");
                    }
                    out.print("\n");
                }
                out.close();
            }
            for (i = 0; i < graphSize; ++i) {
                out = IOUtils.openOutEasy(new File(folderToCreate, "single." + i + ".mtx"));
                for (int s = 0; s < stspsize; ++s) {
                    out.print("" + gmFct.get(i, s) + " ");
                    out.print("\n");
                }
                out.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Problem while trying to write graphical model to disk:\n" + e);
        }
    }

    public static TabularGMFct<Integer> readGridOneNodeMarginals(File mrfFolder) {
        try {
            int gridSide = Integer.parseInt(IO.i(new File(mrfFolder, gridSideName)).iterator().next());
            int stateSpaceSize = Integer.parseInt(IO.i(new File(mrfFolder, stateSpaceSizeFileName)).iterator().next());
            Graphs.Grid graph = Graphs.boundedGrid(2, gridSide);
            HashMap sizes = CollUtils.map();
            for (int i = 0; i < gridSide * gridSide; ++i) {
                sizes.put(i, stateSpaceSize);
            }
            TabularGMFct<Integer> result = GMFctUtils.zeroes(graph, sizes);
            for (int i = 0; i < gridSide * gridSide; ++i) {
                int[] coords = graph.int2coord(i);
                int s = 0;
                for (String line : IO.i(new File(mrfFolder, "single.(" + coords[0] + "," + coords[1] + ").mtx"))) {
                    if (line.matches("^\\s*$")) continue;
                    result.set(i, s, Double.parseDouble(line));
                    ++s;
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem while reading graphical model:\n" + e);
        }
    }

    public static int[][] readImage(File f) {
        try {
            BufferedImage input = ImageIO.read(f);
            BufferedImage im = new BufferedImage(input.getWidth(), input.getHeight(), 12);
            Graphics2D g2d = im.createGraphics();
            g2d.drawImage((Image)input, 0, 0, null);
            Raster raster = im.getData();
            ImageIO.write((RenderedImage)im, "PNG", new File("rendered_lena.png"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static void writeGridOneNodeMarginals(File folderToCreate, GMFct<Integer> gmFct) {
        if (folderToCreate.exists()) {
            if (!folderToCreate.isDirectory()) {
                throw new RuntimeException("Trying to overwrite a non-mrf file " + folderToCreate);
            }
            for (File sub : IO.ls(folderToCreate, "mtx")) {
                sub.delete();
            }
        }
        try {
            folderToCreate.mkdir();
            int graphSize = gmFct.graph().vertexSet().size();
            int stspsize = gmFct.nStates(0);
            if (!(gmFct.graph() instanceof Graphs.Grid)) {
                throw new RuntimeException();
            }
            for (int i = 1; i < graphSize; ++i) {
                if (stspsize == gmFct.nStates(i)) continue;
                throw new RuntimeException();
            }
            Graphs.Grid g = (Graphs.Grid)gmFct.graph();
            IO.writeToDisk(new File(folderToCreate, stateSpaceSizeFileName), "" + stspsize);
            IO.writeToDisk(new File(folderToCreate, gridSideName), "" + g.L);
            for (int i = 0; i < graphSize; ++i) {
                int[] coords = g.int2coord(i);
                PrintWriter out = IOUtils.openOutEasy(new File(folderToCreate, "single.(" + coords[0] + "," + coords[1] + ").mtx"));
                for (int s = 0; s < stspsize; ++s) {
                    out.print("" + gmFct.get(i, s) + " ");
                    out.print("\n");
                }
                out.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Problem while trying to write graphical model to disk:\n" + e);
        }
    }

    public static GMFct<Integer> readChain(File mrfFolder) {
        try {
            int i;
            int length = Integer.parseInt(IO.i(new File(mrfFolder, chainLengthFileName)).iterator().next());
            int stateSpaceSize = Integer.parseInt(IO.i(new File(mrfFolder, stateSpaceSizeFileName)).iterator().next());
            Graph<Integer> graph = Graphs.chainGraph(length);
            HashMap sizes = CollUtils.map();
            for (int i2 = 0; i2 < length; ++i2) {
                sizes.put(i2, stateSpaceSize);
            }
            TabularGMFct<Integer> result = GMFctUtils.zeroes(graph, sizes);
            for (i = 1; i < length; ++i) {
                int prev = 0;
                for (String line : IO.i(new File(mrfFolder, "pair." + (i - 1) + "-" + i + ".mtx"))) {
                    if (line.matches("^\\s*$")) continue;
                    String[] fields = line.split("\\s+");
                    for (int cur = 0; cur < stateSpaceSize; ++cur) {
                        result.set(i - 1, i, prev, cur, Double.parseDouble(fields[cur]));
                    }
                    ++prev;
                }
            }
            for (i = 0; i < length; ++i) {
                int s = 0;
                for (String line : IO.i(new File(mrfFolder, "single." + i + ".mtx"))) {
                    if (line.matches("^\\s*$")) continue;
                    result.set(i, s, Double.parseDouble(line));
                    ++s;
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem while reading graphical model:\n" + e);
        }
    }

    public static void main(String[] args) {
        Random rand = new Random();
        int side = 10;
        int length = side * side;
        int stateSpaceSize = 2;
        Graphs.Grid graph = Graphs.boundedGrid(2, side);
        HashMap sizes = CollUtils.map();
        for (int i = 0; i < length; ++i) {
            sizes.put(i, stateSpaceSize);
        }
        TabularGMFct<Integer> result = GMFctUtils.zeroes(graph, sizes);
        for (int i = 0; i < length; ++i) {
            for (int s = 0; s < stateSpaceSize; ++s) {
                result.set(i, s, rand.nextDouble());
            }
        }
        long time = System.currentTimeMillis();
        File f = new File("temp", "gm-" + time);
        GMFctUtils.writeGridOneNodeMarginals(f, result);
        TabularGMFct<Integer> mrf = GMFctUtils.readGridOneNodeMarginals(f);
        File f2 = new File("temp", "gm-" + time + "-2");
        GMFctUtils.writeGridOneNodeMarginals(f2, mrf);
    }

    public static <V> int getEdgePotentialIndex(Indexer<Object> indexer, V node1, V node2, int s1, int s2) {
        return indexer.o2i(new UnorderedPair<Pair<V, Integer>, Pair<V, Integer>>(Pair.makePair(node1, s1), Pair.makePair(node2, s2)));
    }

    public static <V> int getNodePotentialIndex(Indexer<Object> indexer, V node, int s) {
        return indexer.o2i(Pair.makePair(node, s));
    }

    public static <V extends Comparable<V>> List<GMFct<V>> split(final GMFct<V> g) {
        ArrayList<GMFct<V>> result = new ArrayList<GMFct<V>>();
        Set<Set<V>> eqClasses = Graphs.connectedComponents(g.graph());
        for (final Set<V> eqClass : eqClasses) {
            final HashGraph subgraph = new HashGraph(new SemiGraph<V>(){

                @Override
                public boolean hasSemiEdge(V one, V two) {
                    return g.graph().hasEdge(one, two);
                }

                @Override
                public Set<V> vertexSet() {
                    return eqClass;
                }
            });
            GMFct current = new GMFct<V>(){

                @Override
                public double get(V n1, V n2, int s1, int s2) {
                    if (!eqClass.contains(n1) || !eqClass.contains(n2)) {
                        throw new RuntimeException();
                    }
                    return g.get(n1, n2, s1, s2);
                }

                @Override
                public double get(V n, int s) {
                    return g.get(n, s);
                }

                @Override
                public Graph<V> graph() {
                    return subgraph;
                }

                @Override
                public int nStates(V node) {
                    return g.nStates(node);
                }
            };
            result.add(current);
        }
        return result;
    }

    public static <V extends Comparable<V>> double evalFctByProductAt(GMFct<V> fct, Map<V, Integer> point) {
        double result = 1.0;
        for (UnorderedPair<V, V> edge : Graphs.edgeSet(fct.graph())) {
            result *= fct.get((Comparable)edge.getFirst(), (Comparable)edge.getSecond(), point.get(edge.getFirst()), point.get(edge.getSecond()));
        }
        for (Comparable vertex : fct.graph().vertexSet()) {
            result *= fct.get(vertex, point.get(vertex));
        }
        return result;
    }

    public static <V extends Comparable<V>> GMFct<V> fromSamples(GMFct<V> model, Collection<Map<V, Integer>> samples) {
        TabularGMFct<Comparable> result = GMFctUtils.zeroes(model);
        double weight = 1.0 / (double)samples.size();
        for (Map<V, Integer> current : samples) {
            for (Comparable comparable : model.graph().vertexSet()) {
                result.increment(comparable, current.get(comparable), weight);
            }
            for (UnorderedPair unorderedPair : Graphs.edgeSet(model.graph())) {
                Comparable node1 = (Comparable)unorderedPair.getFirst();
                Comparable node2 = (Comparable)unorderedPair.getSecond();
                int v1 = current.get(node1);
                int v2 = current.get(node2);
                result.increment(node1, node2, v1, v2, weight);
            }
        }
        return result;
    }

    public static <V extends Comparable<V>> Map<V, Integer> sample(GMFct<V> moments, Random rand) {
        if (!Graphs.isForest(moments.graph())) {
            throw new RuntimeException();
        }
        moments = GMFctUtils.computeMarginals(moments);
        HashMap result = new HashMap();
        for (Comparable ccRep : Graphs.connectedComponentsReps(moments.graph())) {
            GMFctUtils.sample(moments, ccRep, null, -1, result, rand);
        }
        return result;
    }

    private static <V extends Comparable<V>> void sample(GMFct<V> moments, V node, V parentNode, int parentState, Map<V, Integer> result, Random rand) {
        double[] choices = new double[moments.nStates(node)];
        for (int s = 0; s < choices.length; ++s) {
            choices[s] = parentNode == null ? moments.get(node, s) : moments.get(node, parentNode, s, parentState) / moments.get(parentNode, parentState);
        }
        if (!MathUtils.isProb(choices)) {
            throw new RuntimeException();
        }
        int choice = SampleUtils.sampleMultinomial(rand, choices);
        result.put((Integer)node, choice);
        for (Comparable nbr : moments.graph().nbrs(node)) {
            if (parentNode != null && parentNode.equals(nbr)) continue;
            GMFctUtils.sample(moments, nbr, node, choice, result, rand);
        }
    }

    public static <V extends Comparable<V>> GMFct<V> restrict(final GMFct<V> f, final Graph<V> g) {
        return new GMFct<V>(){

            @Override
            public double get(V n1, V n2, int s1, int s2) {
                return f.get(n1, n2, s1, s2);
            }

            @Override
            public double get(V n, int s) {
                return f.get(n, s);
            }

            @Override
            public Graph<V> graph() {
                return g;
            }

            @Override
            public int nStates(V node) {
                return f.nStates(node);
            }
        };
    }

    public static <V extends Comparable<V>> double logLL(GMFct<V> moments, Map<V, Integer> sample) {
        if (!Graphs.isForest(moments.graph())) {
            throw new RuntimeException();
        }
        moments = GMFctUtils.computeMarginals(moments);
        double result = 0.0;
        for (Comparable ccRep : Graphs.connectedComponentsReps(moments.graph())) {
            result += GMFctUtils.logLL(moments, ccRep, null, -1, sample);
        }
        return result;
    }

    private static <V extends Comparable<V>> double logLL(GMFct<V> moments, V node, V parentNode, int parentState, Map<V, Integer> sample) {
        double result = 0.0;
        result = parentNode == null ? (result += Math.log(moments.get(node, sample.get(node)))) : (result += Math.log(moments.get(node, parentNode, sample.get(node), parentState)) - Math.log(moments.get(parentNode, parentState)));
        for (Comparable nbr : moments.graph().nbrs(node)) {
            if (parentNode != null && parentNode.equals(nbr)) continue;
            result += GMFctUtils.logLL(moments, nbr, node, sample.get(node), sample);
        }
        return result;
    }

    public static <V extends Comparable<V>> TabularGMFct<V> computeMarginals(final GMFct<V> gf) {
        final TabularGMFct<V> result = new TabularGMFct<V>(gf.graph(), GMFctUtils.domain(gf));
        GMFctUtils.visit(result, new CliqueVisitor<V>(){

            @Override
            public void visitEdge(V n1, V n2, int s1, int s2) {
                result.set(n1, n2, s1, s2, gf.get(n1, n2, s1, s2));
            }

            @Override
            public void visitVertex(V n, int s) {
                result.set(n, s, Double.NaN);
            }
        });
        for (UnorderedPair<V, V> edge : Graphs.edgeSet(gf.graph())) {
            GMFctUtils._computeMarginals(gf, (Comparable)edge.getFirst(), (Comparable)edge.getSecond(), result);
            GMFctUtils._computeMarginals(gf, (Comparable)edge.getSecond(), (Comparable)edge.getFirst(), result);
        }
        return result;
    }

    private static <V extends Comparable<V>> void _computeMarginals(GMFct<V> gf, V first, V second, TabularGMFct<V> tg) {
        int nStates = tg.nStates(first);
        for (int s = 0; s < nStates; ++s) {
            double cur = GMFctUtils.__computeMarginals(gf, s, first, second);
            if (!MathUtils.isCloseToProb(cur)) {
                throw new RuntimeException("Should be a pr:" + cur);
            }
            if (!Double.isNaN(tg.get(first, s)) && !MathUtils.close(tg.get(first, s), cur)) {
                throw new RuntimeException("Marginal " + tg.get(first, s) + " not consistent with " + cur);
            }
            tg.set(first, s, cur);
        }
    }

    private static <V extends Comparable<V>> double __computeMarginals(GMFct<V> gf, int s, V first, V second) {
        double sum = 0.0;
        for (int s2 = 0; s2 < gf.nStates(second); ++s2) {
            sum += gf.get(first, second, s, s2);
        }
        return sum;
    }

    public static <V extends Comparable<V>> void checkIsPotential(final GMFct<V> pot) {
        GMFctUtils.visit(pot, new CliqueVisitor<V>(){

            @Override
            public void visitEdge(V n1, V n2, int s1, int s2) {
                if (pot.get(n1, n2, s1, s2) < 0.0) {
                    throw new RuntimeException();
                }
            }

            @Override
            public void visitVertex(V n, int s) {
                if (pot.get(n, s) < 0.0) {
                    throw new RuntimeException();
                }
            }
        });
    }

    public static <V> void visit(GMFct<V> gf, CliqueVisitor<V> visitor) {
        int s1;
        for (Object f : gf.graph().vertexSet()) {
            for (s1 = 0; s1 < gf.nStates(f); ++s1) {
                visitor.visitVertex(f, s1);
            }
        }
        for (UnorderedPair unorderedPair : Graphs.edgeSet(gf.graph())) {
            for (s1 = 0; s1 < gf.nStates(unorderedPair.getFirst()); ++s1) {
                for (int s2 = 0; s2 < gf.nStates(unorderedPair.getSecond()); ++s2) {
                    visitor.visitEdge(unorderedPair.getFirst(), unorderedPair.getSecond(), s1, s2);
                }
            }
        }
    }

    public static <V extends Comparable<V>> double entropy(GMFct<V> moments) {
        if (!Graphs.isForest(moments.graph())) {
            throw new RuntimeException();
        }
        moments = GMFctUtils.computeMarginals(moments);
        EntropyGraphProcessor<V> gp = new EntropyGraphProcessor<V>(moments);
        Graph<V> graph = moments.graph();
        for (Comparable ccRep : Graphs.connectedComponentsReps(moments.graph())) {
            Graphs.dfs(graph, ccRep, gp);
        }
        return gp.cEntropy;
    }

    public static <V extends Comparable<V>> TabularGMFct<V> zeroes(GMFct<V> model) {
        return GMFctUtils.cnst(model, 0.0);
    }

    public static <V extends Comparable<V>> TabularGMFct<V> zeroes(Graph<V> graph, Map<V, Integer> randomVariableDom) {
        return GMFctUtils.cnst(new TabularGMFct<V>(graph, randomVariableDom), 0.0);
    }

    public static TabularGMFct<Integer> chainGraphicalModel(int nNodes, int nStates, double initialValue) {
        Graph<Integer> graph = Graphs.chainGraph(nNodes);
        HashMap randomVariableDom = CollUtils.map();
        for (int node = 0; node < nNodes; ++node) {
            randomVariableDom.put(node, nStates);
        }
        return GMFctUtils.cnst(new TabularGMFct<Integer>(graph, randomVariableDom), initialValue);
    }

    public static <V extends Comparable<V>> TabularGMFct<V> ones(GMFct<V> model) {
        return GMFctUtils.cnst(model, 1.0);
    }

    public static <V extends Comparable<V>> TabularGMFct<V> ones(Graph<V> graph, Map<V, Integer> randomVariableDom) {
        return GMFctUtils.cnst(new TabularGMFct<V>(graph, randomVariableDom), 1.0);
    }

    public static <V extends Comparable<V>> TabularGMFct<V> cnst(GMFct<V> model, final double cnst) {
        final TabularGMFct<V> result = new TabularGMFct<V>(model.graph(), GMFctUtils.domain(model));
        GMFctUtils.visit(model, new CliqueVisitor<V>(){

            @Override
            public void visitEdge(V n1, V n2, int s1, int s2) {
                result.set(n1, n2, s1, s2, cnst);
            }

            @Override
            public void visitVertex(V n, int s) {
                result.set(n, s, cnst);
            }
        });
        return result;
    }

    public static <V extends Comparable<V>> TabularGMFct<V> log(final GMFct<V> f) {
        final TabularGMFct<V> result = new TabularGMFct<V>(f.graph(), GMFctUtils.domain(f));
        GMFctUtils.visit(f, new CliqueVisitor<V>(){

            @Override
            public void visitEdge(V n1, V n2, int s1, int s2) {
                result.set(n1, n2, s1, s2, Math.log(f.get(n1, n2, s1, s2)));
            }

            @Override
            public void visitVertex(V n, int s) {
                result.set(n, s, Math.log(f.get(n, s)));
            }
        });
        return result;
    }

    public static <V extends Comparable<V>> TabularGMFct<V> exp(final GMFct<V> f) {
        final TabularGMFct<V> result = new TabularGMFct<V>(f.graph(), GMFctUtils.domain(f));
        GMFctUtils.visit(f, new CliqueVisitor<V>(){

            @Override
            public void visitEdge(V n1, V n2, int s1, int s2) {
                result.set(n1, n2, s1, s2, Math.exp(f.get(n1, n2, s1, s2)));
            }

            @Override
            public void visitVertex(V n, int s) {
                result.set(n, s, Math.exp(f.get(n, s)));
            }
        });
        return result;
    }

    public static <V> Map<V, Integer> domain(GMFct<V> model) {
        HashMap<V, Integer> result = new HashMap<V, Integer>();
        for (V vertex : model.graph().vertexSet()) {
            result.put(vertex, model.nStates(vertex));
        }
        return result;
    }

    public static <V extends Comparable<V>> boolean compatible(GMFct<V> f1, GMFct<V> f2) {
        if (!Graphs.equals(f1.graph(), f2.graph())) {
            return false;
        }
        return GMFctUtils.domain(f1).equals(GMFctUtils.domain(f2));
    }

    public static <V extends Comparable<V>> double dotProd(final GMFct<V> f1, final GMFct<V> f2) {
        if (!GMFctUtils.compatible(f1, f2)) {
            throw new RuntimeException();
        }
        final DoubleRef result = new DoubleRef(0.0);
        CliqueVisitor visitor = new CliqueVisitor<V>(){

            @Override
            public void visitEdge(V n1, V n2, int s1, int s2) {
                result.value += f1.get(n1, n2, s1, s2) * f2.get(n1, n2, s1, s2);
            }

            @Override
            public void visitVertex(V n, int s) {
                result.value += f1.get(n, s) * f2.get(n, s);
            }
        };
        GMFctUtils.visit(f1, visitor);
        return result.value;
    }

    private static class EntropyGraphProcessor<V extends Comparable<V>>
    implements Graphs.GraphProcessor<V> {
        double cEntropy = 0.0;
        private final GMFct<V> edgePosteriors;

        public EntropyGraphProcessor(GMFct<V> edgePosteriors) {
            this.edgePosteriors = edgePosteriors;
        }

        @Override
        public void process(V vertex, V parent, Set<V> visited) {
            this.cEntropy = parent == null ? (this.cEntropy += this.entropy(vertex)) : (this.cEntropy += this.cEntropy(vertex, parent));
        }

        private double cEntropy(V node, V parent) {
            double sum = 0.0;
            for (int parentState = 0; parentState < this.edgePosteriors.nStates(parent); ++parentState) {
                double cDenom = this.edgePosteriors.get(parent, parentState);
                for (int currentState = 0; currentState < this.edgePosteriors.nStates(node); ++currentState) {
                    double edgePost = this.edgePosteriors.get(node, parent, currentState, parentState);
                    sum -= edgePost * Math.log(edgePost / cDenom);
                }
            }
            return sum;
        }

        private double entropy(V node) {
            double sum = 0.0;
            for (int i = 0; i < this.edgePosteriors.nStates(node); ++i) {
                sum -= this.edgePosteriors.get(node, i) * Math.log(this.edgePosteriors.get(node, i));
            }
            return sum;
        }
    }

    public static final class SimpleGraphFct<V extends Comparable<V>>
    implements GMFct<V> {
        private final double[][] pot;
        private final Graph<V> graph;

        public SimpleGraphFct(double[][] _pot, Graph<V> graph) {
            this.graph = graph;
            this.pot = _pot;
            this.checkSymm(_pot);
        }

        private void checkSymm(double[][] _pot) {
            for (int i = 0; i < _pot.length; ++i) {
                for (int j = 0; j < _pot.length; ++j) {
                    if (_pot[i][j] == _pot[j][i]) continue;
                    throw new RuntimeException();
                }
            }
        }

        @Override
        public int nStates(V node) {
            return this.pot.length;
        }

        @Override
        public double get(V n1, V n2, int s1, int s2) {
            return this.pot[s1][s2];
        }

        @Override
        public Graph<V> graph() {
            return this.graph;
        }

        @Override
        public double get(V n, int s) {
            return 1.0;
        }
    }
}

