/*
 * Decompiled with CFR 0.152.
 */
package nuts.math;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import nuts.tui.Table;
import nuts.util.MathUtils;
import org.jblas.DoubleMatrix;
import org.jblas.MatrixFunctions;

public class MtxUtils {
    public static void plusEqual(double[] target, double[] unmodifiedSource, double sourceScale) {
        if (target.length != unmodifiedSource.length) {
            throw new RuntimeException();
        }
        for (int i = 0; i < target.length; ++i) {
            target[i] = target[i] + sourceScale * unmodifiedSource[i];
        }
    }

    public static void normalizeWeights(double[] unormalized) {
        double sum = 0.0;
        for (double x : unormalized) {
            if (x < 0.0) {
                throw new RuntimeException();
            }
            sum += x;
        }
        if (sum == 0.0) {
            throw new RuntimeException();
        }
        int i = 0;
        while (i < unormalized.length) {
            int n = i++;
            unormalized[n] = unormalized[n] / sum;
        }
    }

    public static void normalizeWeightsByRow(double[][] unormalizedTransitionMtx) {
        for (double[] row : unormalizedTransitionMtx) {
            MtxUtils.normalizeWeights(row);
        }
    }

    public static Matrix id(int size) {
        Matrix result = new Matrix(size, size);
        for (int i = 0; i < size; ++i) {
            result.set(i, i, 1.0);
        }
        return result;
    }

    public static Matrix zeroes(int size) {
        return new Matrix(size, size);
    }

    public static Matrix diag(double[] diagValues) {
        int size = diagValues.length;
        Matrix result = new Matrix(size, size);
        for (int i = 0; i < size; ++i) {
            result.set(i, i, diagValues[i]);
        }
        return result;
    }

    public static void logInPlace(double[] n) {
        for (int i = 0; i < n.length; ++i) {
            n[i] = Math.log(n[i]);
        }
    }

    public static Matrix exp(Matrix M) {
        EigenvalueDecomposition ed = new EigenvalueDecomposition(M);
        Matrix V = ed.getV();
        return MtxUtils.exp(V, V.inverse(), ed.getD());
    }

    public static double[][] exp(double[][] M) {
        return MtxUtils.exp(new Matrix(M)).getArray();
    }

    public static void main(String[] args) {
        double[][] test = new double[][]{{-1.0, 1.0, 0.0}, {0.0, -1.0, 1.0}, {0.0, 0.0, 0.0}};
        System.out.println(Table.toString(test));
        System.out.println(Table.toString(MtxUtils.exp(test)));
        DoubleMatrix dm = new DoubleMatrix((double[][])test);
        System.out.println(Table.toString(MatrixFunctions.expm((DoubleMatrix)dm).toArray2()));
    }

    public static Matrix exp(Matrix V, Matrix Vinv, Matrix D2) {
        int size = V.getColumnDimension();
        Matrix expD = new Matrix(size, size);
        for (int i = 0; i < size; ++i) {
            expD.set(i, i, Math.exp(D2.get(i, i)));
        }
        Matrix result = V.times(expD).times(Vinv);
        for (int row = 0; row < V.getRowDimension(); ++row) {
            double sum = 0.0;
            for (int col = 0; col < V.getColumnDimension(); ++col) {
                sum += result.get(row, col);
            }
            MathUtils.checkClose(sum, 1.0);
        }
        return result;
    }

    public static double[] topEigenvector(Matrix M) {
        int size = M.getColumnDimension();
        assert (MtxUtils.hasPositiveEntries(M));
        EigenvalueDecomposition ed = M.eig();
        Matrix D2 = ed.getD();
        double[] imag = ed.getImagEigenvalues();
        int argmax = -1;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < size; ++i) {
            if (!(Math.abs(D2.get(i, i)) > max) || imag[i] != 0.0) continue;
            max = Math.abs(D2.get(i, i));
            argmax = i;
        }
        if (argmax == -1) {
            throw new RuntimeException("Bad matrix:\n" + Table.toString(M));
        }
        double sign = ed.getV().get(0, argmax) < 0.0 ? -1.0 : 1.0;
        double[] result = new double[size];
        for (int i = 0; i < size; ++i) {
            result[i] = ed.getV().get(i, argmax) * sign;
        }
        return result;
    }

    public static double[] topEigenvector(double[][] M) {
        return MtxUtils.topEigenvector(new Matrix(M));
    }

    public static boolean hasPositiveEntries(Matrix m) {
        for (int i = 0; i < m.getRowDimension(); ++i) {
            for (int j = 0; j < m.getColumnDimension(); ++j) {
                if (!(m.get(i, j) <= 0.0)) continue;
                return false;
            }
        }
        return true;
    }

    public static Matrix kronecker(Matrix A, Matrix B) {
        Matrix result = new Matrix(A.getRowDimension() * B.getRowDimension(), A.getColumnDimension() * B.getColumnDimension());
        for (int ar = 0; ar < A.getRowDimension(); ++ar) {
            for (int ac = 0; ac < A.getColumnDimension(); ++ac) {
                double a = A.get(ar, ac);
                for (int br = 0; br < B.getRowDimension(); ++br) {
                    for (int bc = 0; bc < B.getColumnDimension(); ++bc) {
                        result.set(B.getRowDimension() * ar + br, B.getColumnDimension() * ac + bc, a * B.get(br, bc));
                    }
                }
            }
        }
        return result;
    }

    public static Matrix star(Matrix m) {
        return MtxUtils.id(m.getColumnDimension()).minusEquals(m).inverse();
    }

    public static double[][] transpose(double[][] mtx) {
        int d1 = mtx.length;
        int d2 = mtx[0].length;
        double[][] transpose = new double[d2][d1];
        for (int i1 = 0; i1 < d1; ++i1) {
            for (int i2 = 0; i2 < d2; ++i2) {
                transpose[i2][i1] = mtx[i1][i2];
            }
        }
        return transpose;
    }

    private static void testKron() {
        double[][] atran = new double[][]{{0.0, 1.0, 0.0, 5.0}, {0.0, 0.0, 0.0, 6.0}, {0.0, 0.0, 0.0, 7.0}};
        double[][] btran = new double[][]{{1.0, 2.0}, {4.0, 5.0}, {6.0, 7.0}, {8.0, 9.0}};
        Matrix a = new Matrix((double[][])atran);
        Matrix b = new Matrix((double[][])btran);
        System.out.println(Table.toString(a));
        System.out.println(Table.toString(b));
        System.out.println(Table.toString(MtxUtils.kronecker(a, b)));
    }
}

