/*
 * Decompiled with CFR 0.152.
 */
package nuts.remote;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import java.io.File;
import java.io.PrintWriter;
import java.util.regex.Pattern;
import nuts.io.IO;
import nuts.lang.StringUtils;

public class ExecuteLaunchPad
implements Runnable {
    public static final Pattern launchPattern = Pattern.compile("^\\s*[>]\\s*(.*)$");
    public static final Pattern execLine = Pattern.compile("^\\s*Execution directory[:]\\s*(.*)$");

    public static void main(String[] args) {
        IO.run(args, new ExecuteLaunchPad());
    }

    @Override
    public void run() {
        while (this.executeCmd()) {
        }
    }

    private boolean executeCmd() {
        boolean found = false;
        File newLaunchPadFileBackup = new File("state", ".launchPad1");
        PrintWriter out = IOUtils.openOutHard(newLaunchPadFileBackup);
        File launchPadFile = new File("state", "launchPad");
        for (String currentLine : IO.i(launchPadFile)) {
            if (!found && launchPattern.matcher(currentLine).matches()) {
                found = true;
                if ((currentLine = StringUtils.selectFirstRegex(launchPattern, currentLine)).matches("^\\s*[>]\\s*java.*")) {
                    throw new RuntimeException("Do not write the java cmd in the launch pad, it's added for you");
                }
                String exec = ">";
                try {
                    exec = ExecuteLaunchPad.launchGetExec(currentLine) + ":";
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                currentLine = exec + currentLine;
            }
            out.println(currentLine);
        }
        out.close();
        if (!found) {
            return false;
        }
        launchPadFile.renameTo(new File("state", ".launchPad"));
        newLaunchPadFileBackup.renameTo(new File("state", "launchPad"));
        return true;
    }

    public static String launch(String cmd) {
        LogInfo.track("Launching:" + cmd);
        String cp = System.getProperties().getProperty("java.class.path", null);
        String str = IO.call("java -cp " + cp + " " + cmd);
        LogInfo.logs(str);
        LogInfo.end_track();
        return str;
    }

    public static String launchGetExec(String currentLine) {
        String out = ExecuteLaunchPad.launch(currentLine);
        String result = "UNK";
        for (String line : out.split("\n")) {
            if (!execLine.matcher(line).matches()) continue;
            result = StringUtils.selectFirstRegex(execLine, line).replaceFirst(".*execs[/]", "");
            break;
        }
        return result;
    }
}

