/*
 * Decompiled with CFR 0.152.
 */
package nuts.tools;

import fig.basic.Option;
import java.io.File;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import nuts.io.IO;
import nuts.lang.StringUtils;
import nuts.util.CollUtils;

public class RecursiveModificationDate
implements Runnable {
    @Option
    public String ignoreFile = "";
    @Option(required=true)
    public String file;
    @Option
    public boolean humanReadable = false;
    public static Pattern fileExclusionPattern = Pattern.compile("^([A-Za-z]+)\\s+(.*)$");
    private long max = Long.MIN_VALUE;
    private FileExclusions exclusions;

    public static void main(String[] args) {
        IO.runLight(args, new RecursiveModificationDate());
    }

    private void recModDate(File file) {
        if (this.exclusions.exclude(file)) {
            return;
        }
        long cur = file.lastModified();
        if (cur > this.max) {
            this.max = cur;
        }
        if (file.isDirectory()) {
            for (File child : IO.ls(file)) {
                this.recModDate(child);
            }
        }
    }

    @Override
    public void run() {
        this.exclusions = new FileExclusions(this.ignoreFile);
        this.recModDate(new File(this.file));
        System.out.println(this.humanReadable ? new Date(this.max) : Long.valueOf(this.max));
        this.exclusions.printWarning();
    }

    public static class FileExclusions {
        public final Set<File> excludedAbsolutePaths = CollUtils.set();
        public final Set<String> excludedSuffixes = CollUtils.set();
        public final Set<String> excludedFileNames = CollUtils.set();
        private final Set<File> excludedAbsolutePathHits = CollUtils.set();
        private final Set<String> excludedSuffixesHits = CollUtils.set();
        private final Set<String> excludedFileNamesHist = CollUtils.set();

        public FileExclusions(String str) {
            if ("".equals(str)) {
                return;
            }
            for (String line : IO.i(str)) {
                if (line.matches("^\\s*$")) continue;
                if (fileExclusionPattern.matcher(line).matches()) {
                    List<String> parsedLine = StringUtils.multiSelectFirstRegex(fileExclusionPattern, line);
                    String cmd = parsedLine.get(0).toUpperCase();
                    String arg = parsedLine.get(1);
                    if (arg.contains("\"")) {
                        throw new RuntimeException("Should not contain quotations:" + arg);
                    }
                    if ("PATH".equals(cmd)) {
                        this.excludedAbsolutePaths.add(new File(arg));
                        continue;
                    }
                    if ("FILE".equals(cmd)) {
                        this.excludedFileNames.add(arg);
                        continue;
                    }
                    if ("EXT".equals(cmd)) {
                        if (arg.charAt(0) == '.') {
                            arg = arg.substring(1);
                        }
                        this.excludedSuffixes.add(arg);
                        continue;
                    }
                    throw new RuntimeException("Invalid cmd:" + cmd);
                }
                throw new RuntimeException("Bad exclusion line:" + line);
            }
        }

        public boolean exclude(File f) {
            String ext;
            String name = f.getName();
            if (this.excludedAbsolutePaths.contains(f)) {
                this.excludedAbsolutePathHits.add(f);
                return true;
            }
            if (this.excludedFileNames.contains(name)) {
                this.excludedFileNamesHist.add(name);
                return true;
            }
            if (name.contains(".") && this.excludedSuffixes.contains(ext = IO.extension(f))) {
                this.excludedSuffixesHits.add(ext);
                return true;
            }
            return false;
        }

        public void printWarning() {
            FileExclusions.printWarning("path(s)", this.excludedAbsolutePaths, this.excludedAbsolutePathHits);
            FileExclusions.printWarning("extension(s)", this.excludedSuffixes, this.excludedSuffixesHits);
            FileExclusions.printWarning("file(s)", this.excludedFileNames, this.excludedFileNamesHist);
        }

        private static void printWarning(String msg, Set all, Set hits) {
            if (all.size() == hits.size()) {
                return;
            }
            if (hits.size() > all.size()) {
                throw new RuntimeException();
            }
            HashSet copy = CollUtils.set(all);
            copy.removeAll(hits);
            System.err.println("\nWarning: these " + msg + " filter(s) were not used: " + copy);
        }
    }
}

