/*
 * Decompiled with CFR 0.152.
 */
package nuts.tools;

import fig.basic.IOUtils;
import fig.basic.Option;
import java.io.File;
import java.io.PrintWriter;
import java.util.regex.Pattern;
import nuts.io.IO;

public class SubstituteBib
implements Runnable {
    @Option(required=true)
    public String inputPath;
    @Option(required=true)
    public String outputPath;
    private static final Pattern p1 = Pattern.compile("\\s*\\\\bibliography[{]([^}]+)[}]\\s*");

    public static void main(String[] args) {
        IO.runLight(args, new SubstituteBib());
    }

    @Override
    public void run() {
        File inputFile = new File(this.inputPath);
        File bibFile = new File(inputFile.getParentFile(), IO.nameWithoutExtension(inputFile) + ".bbl");
        if (!bibFile.exists()) {
            throw new RuntimeException("Does not exists:" + bibFile.getAbsolutePath());
        }
        PrintWriter out = IOUtils.openOutHard(this.outputPath);
        for (String line : IO.i(inputFile)) {
            if (p1.matcher(line).matches()) {
                for (String bibLine : IO.i(bibFile)) {
                    out.println(bibLine);
                }
                continue;
            }
            out.println(line);
        }
        out.close();
    }
}

