/*
 * Decompiled with CFR 0.152.
 */
package nuts.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nuts.util.Counter;

public class CollUtils {
    public static int checkSizesMatch(int s, int s2) {
        if (s != s2) {
            throw new RuntimeException();
        }
        return s;
    }

    public static List<Set<Integer>> partition(int n, int k) {
        ArrayList<Set<Integer>> result = new ArrayList<Set<Integer>>();
        int div = n / k;
        int rem = n % k;
        int curIndex = 0;
        for (int curPartIndex = 0; curPartIndex < k; ++curPartIndex) {
            HashSet<Integer> curPart = new HashSet<Integer>();
            result.add(curPart);
            for (int i = 0; i < div + (curPartIndex < rem ? 1 : 0); ++i) {
                curPart.add(curIndex++);
            }
        }
        return result;
    }

    public static <T> T last(List<T> list) {
        if (list.size() == 0) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static <T> T first(List<T> list) {
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public static <T> T pick(Collection<T> coll) {
        return coll.size() == 0 ? null : (T)coll.iterator().next();
    }

    public static <K, V> Map<K, V> cnstMap(final Set<K> keys, final V value) {
        return new Map<K, V>(){

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsKey(Object arg0) {
                return keys.contains(arg0);
            }

            @Override
            public boolean containsValue(Object arg0) {
                if (value == null && arg0 == null) {
                    return true;
                }
                if (value == null || arg0 == null) {
                    return false;
                }
                return value.equals(arg0);
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                throw new UnsupportedOperationException();
            }

            @Override
            public V get(Object arg0) {
                if (keys.contains(arg0)) {
                    return value;
                }
                return null;
            }

            @Override
            public boolean isEmpty() {
                return keys.isEmpty();
            }

            @Override
            public Set<K> keySet() {
                return keys;
            }

            @Override
            public V put(K arg0, V arg1) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void putAll(Map<? extends K, ? extends V> arg0) {
                throw new UnsupportedOperationException();
            }

            @Override
            public V remove(Object arg0) {
                keys.remove(arg0);
                return value;
            }

            @Override
            public int size() {
                return keys.size();
            }

            @Override
            public Collection<V> values() {
                return Collections.singleton(value);
            }
        };
    }

    public static void main(String[] args) {
        System.out.println(CollUtils.partition(11, 3));
    }

    public static <T> boolean intersects(Set<T> s1, Set<T> s2) {
        return !Collections.disjoint(s1, s2);
    }

    public static <S> Set<S> symmetricDifference(Set<S> s1, Set<S> s2) {
        Set result = CollUtils.union(s1, s2);
        result.removeAll(CollUtils.inter(s1, s2));
        return result;
    }

    public static <T> Map<T, Integer> invert(List<T> list) {
        HashMap<T, Integer> result = new HashMap<T, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            result.put(list.get(i), i);
        }
        return result;
    }

    public static <K, V> Map<V, Set<K>> invert(Map<K, V> map) {
        HashMap result = new HashMap();
        for (K key : map.keySet()) {
            CollUtils.getNoNullSet(result, map.get(key)).add(key);
        }
        return result;
    }

    public static <T, S> Set<Set<S>> inducedPartition(Map<S, T> map) {
        Map<T, Set<S>> inverse = CollUtils.invert(map);
        return new HashSet<Set<S>>(inverse.values());
    }

    public static <K, V> V getNoNull(Map<K, V> map, K key, V defaultValue) {
        V result = map.get(key);
        if (result == null) {
            result = defaultValue;
            map.put(key, result);
        }
        return result;
    }

    public static <K, V> Set<V> getNoNullSet(Map<K, Set<V>> map, K key) {
        return CollUtils.getNoNull(map, key, new HashSet());
    }

    public static <K, V> List<V> getNoNullList(Map<K, List<V>> map, K key) {
        return CollUtils.getNoNull(map, key, new ArrayList());
    }

    public static <T> boolean isSet(Collection<T> c) {
        if (c.isEmpty()) {
            return true;
        }
        HashSet<T> set = CollUtils.set();
        set.addAll(c);
        return set.size() == c.size();
    }

    public static <T> Set<T> union(Set<T> ... sets) {
        HashSet<T> result = new HashSet<T>();
        for (Set<T> set : sets) {
            result.addAll(set);
        }
        return result;
    }

    public static <T> Set<T> unionOfCollection(Collection<Set<T>> sets) {
        HashSet<T> result = new HashSet<T>();
        for (Set<T> set : sets) {
            result.addAll(set);
        }
        return result;
    }

    public static <T> Set<T> inter(Set<T> ... sets) {
        HashSet<T> result = new HashSet<T>();
        if (sets.length == 0) {
            return result;
        }
        result.addAll(sets[0]);
        for (int i = 1; i < sets.length; ++i) {
            result.retainAll(sets[i]);
        }
        return result;
    }

    public static <T> boolean overlap(Set<T> set1, Set<T> set2) {
        return !Collections.disjoint(set1, set2);
    }

    public static <T> List<T> archive(List<? extends T> list) {
        ArrayList<T> copy = CollUtils.list();
        copy.addAll(list);
        return Collections.unmodifiableList(copy);
    }

    public static <S, T> Map<S, T> archive(Map<? extends S, ? extends T> map) {
        HashMap<? extends S, ? extends T> copy = new HashMap<S, T>();
        copy.putAll(map);
        return Collections.unmodifiableMap(map);
    }

    public static <T> Set<T> archive(Set<? extends T> list) {
        HashSet<T> copy = CollUtils.set();
        copy.addAll(list);
        return Collections.unmodifiableSet(copy);
    }

    public static <T> HashSet<T> set(Collection<? extends T> model) {
        return new HashSet<T>(model);
    }

    public static <T> ArrayList<T> list(Collection<? extends T> model) {
        return new ArrayList<T>(model);
    }

    public static <S, T> HashMap<S, T> map(Map<? extends S, ? extends T> model) {
        return new HashMap<S, T>(model);
    }

    public static <T> HashSet<T> set() {
        return new HashSet();
    }

    public static <T> ArrayList<T> list() {
        return new ArrayList();
    }

    public static <S, T> HashMap<S, T> map() {
        return new HashMap();
    }

    public static int[] toArray(List<Integer> list) {
        int[] result = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static List<Integer> ints(int n) {
        ArrayList<Integer> result = CollUtils.list();
        for (int i = 0; i < n; ++i) {
            result.add(i);
        }
        return result;
    }

    public static <K> List<K> orderWithToString(Collection<K> ks) {
        HashMap s2k = CollUtils.map();
        ArrayList<String> ss = CollUtils.list();
        for (K k : ks) {
            String s = k.toString();
            s2k.put(s, k);
            ss.add(s);
        }
        Collections.sort(ss);
        ArrayList result = CollUtils.list();
        for (String s : ss) {
            result.add(s2k.get(s));
        }
        if (result.size() != ks.size()) {
            throw new RuntimeException();
        }
        return result;
    }

    public static <K> String counter2StringWithSortedKeys(Counter<K> counter) {
        StringBuilder result = new StringBuilder();
        for (K key : CollUtils.orderWithToString(counter.keySet())) {
            result.append("" + key + "\t" + counter.getCount(key) + "\n");
        }
        return result.toString();
    }

    public static <S> void transfer(List<S> list1, int maxList1Length, List<S> list2) {
        if (list1.size() <= maxList1Length) {
            return;
        }
        list2.addAll(list1.subList(maxList1Length, list1.size()));
        for (int i = list1.size() - 1; i >= maxList1Length; --i) {
            list1.remove(i);
        }
    }
}

