/*
 * Decompiled with CFR 0.152.
 */
package nuts.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import nuts.util.MapFactory;
import nuts.util.PriorityQueue;

public class Counter<E>
implements Serializable,
Iterable<E> {
    private static final long serialVersionUID = 5724671156522771655L;
    public Map<E, Double> entries;
    int currentModCount = 0;
    int cacheModCount = -1;
    double cacheTotalCount = 0.0;

    public Set<E> keySet() {
        return this.entries.keySet();
    }

    public void clear() {
        this.currentModCount = 0;
        this.cacheModCount = -1;
        this.cacheTotalCount = 0.0;
        this.entries.clear();
    }

    public int size() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(E key) {
        return this.entries.containsKey(key);
    }

    public double removeKey(E key) {
        Double d = this.entries.remove(key);
        return d == null ? 0.0 : d;
    }

    public double getCount(E key) {
        Double value = this.entries.get(key);
        if (value == null) {
            return 0.0;
        }
        return value;
    }

    public void setCount(E key, double count) {
        ++this.currentModCount;
        this.entries.put(key, count);
    }

    public void incrementCount(E key, double increment) {
        this.setCount(key, this.getCount(key) + increment);
    }

    public void incrementAll(Collection<? extends E> collection, double count) {
        for (E key : collection) {
            this.incrementCount(key, count);
        }
    }

    public <T extends E> void incrementAll(Counter<T> counter) {
        for (T key : counter.keySet()) {
            double count = counter.getCount(key);
            this.incrementCount(key, count);
        }
    }

    public double totalCount() {
        if (this.currentModCount != this.cacheModCount) {
            double total = 0.0;
            for (Map.Entry<E, Double> entry : this.entries.entrySet()) {
                total += entry.getValue().doubleValue();
            }
            this.cacheTotalCount = total;
            this.cacheModCount = this.currentModCount;
        }
        return this.cacheTotalCount;
    }

    public void normalize() {
        double totalCount = this.totalCount();
        for (E key : this.keySet()) {
            this.setCount(key, this.getCount(key) / totalCount);
        }
    }

    public E argMax() {
        double maxCount = Double.NEGATIVE_INFINITY;
        E maxKey = null;
        for (Map.Entry<E, Double> entry : this.entries.entrySet()) {
            if (!(entry.getValue() > maxCount) && maxKey != null) continue;
            maxKey = entry.getKey();
            maxCount = entry.getValue();
        }
        return maxKey;
    }

    public double max() {
        double maxCount = Double.NEGATIVE_INFINITY;
        Object maxKey = null;
        for (Map.Entry<E, Double> entry : this.entries.entrySet()) {
            if (!(entry.getValue() > maxCount) && maxKey != null) continue;
            maxKey = entry.getKey();
            maxCount = entry.getValue();
        }
        return maxCount;
    }

    public String toString() {
        return this.toString(this.keySet().size());
    }

    public String toString(int maxKeysToPrint) {
        return this.asPriorityQueue().toString(maxKeysToPrint);
    }

    public PriorityQueue<E> asPriorityQueue() {
        PriorityQueue<E> pq = new PriorityQueue<E>(this.entries.size());
        for (Map.Entry<E, Double> entry : this.entries.entrySet()) {
            pq.add(entry.getKey(), entry.getValue());
        }
        return pq;
    }

    @Override
    public Iterator<E> iterator() {
        return this.asPriorityQueue();
    }

    public Counter() {
        this(new MapFactory.HashMapFactory());
    }

    public Counter(MapFactory<E, Double> mf) {
        this.entries = mf.buildMap();
    }

    public Counter(Counter<? extends E> counter) {
        this();
        this.incrementAll(counter);
    }

    public Counter(Collection<? extends E> collection) {
        this();
        this.incrementAll(collection, 1.0);
    }

    public static void main(String[] args) {
        Counter<String> counter = new Counter<String>();
        System.out.println(counter);
        counter.incrementCount("planets", 7.0);
        System.out.println(counter);
        counter.incrementCount("planets", 1.0);
        System.out.println(counter);
        counter.setCount("suns", 1.0);
        System.out.println(counter);
        counter.setCount("aliens", 0.0);
        System.out.println(counter);
        System.out.println(counter.toString(2));
        System.out.println("Total: " + counter.totalCount());
    }
}

