/*
 * Decompiled with CFR 0.152.
 */
package pedi.main;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.NumUtils;
import fig.basic.Option;
import fig.exec.Execution;
import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import nuts.io.IO;
import nuts.lang.ArrayUtils;
import pedi.PedigreeUtils;
import pedi.baseline.Merlin;
import pedi.main.PediMain;

public class RunMerlin
extends PediMain {
    @Option
    public String memlim = "1000000";

    public static void main(String[] args) {
        IO.run(args, new RunMerlin());
    }

    @Override
    public void run() {
        long start = System.nanoTime();
        File pedigreeAndAffectionsFile = new File(Execution.getFile("pedigreeAndAffectionsFile.ped"));
        PedigreeUtils.pedigree2File(pedigreeAndAffectionsFile, this.getPedigree(), this.getData(), this.getAffections(), this.getGenders());
        File merlinOutput = new File(Execution.getFile("merlin-output"));
        LogInfo.track("Running Merlin...");
        String merlinDetailedOut = Merlin.runParametricMerlin(this.getData().genomeSize(), pedigreeAndAffectionsFile, RunMerlin.convertRates(this.getRecombRatesFile()), merlinOutput, 0.5, this.penOptions.p0, this.penOptions.p1, this.penOptions.p2, this.memlim);
        IO.writeToDisk(new File(Execution.getFile("merlin-detailed-output")), merlinDetailedOut);
        double[] result = Merlin.parseDetailedParametricMerlinLODs(ArrayUtils.stringArray2List(merlinDetailedOut.split("\n")));
        NumUtils.expNormalize(result);
        LogInfo.end_track();
        double time = (double)(System.nanoTime() - start) / 1.0E10;
        this.evaluateDiseaseLocus(Arrays.asList("Method", "Iter", "ElapsedSeconds"), Arrays.asList("Merlin", "0", "" + time), result);
    }

    public static File convertRates(File recRatesFiles) {
        File converted = new File(Execution.getFile("rates-merlin"));
        PrintWriter out = IOUtils.openOutEasy(converted);
        for (String rate : IO.f2s(recRatesFiles).split("\\s+")) {
            out.println(rate);
        }
        out.close();
        return converted;
    }
}

