/*
 * Decompiled with CFR 0.152.
 */
package pty.smc;

import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Pair;
import java.util.List;
import java.util.Random;
import nuts.math.Sampling;
import pty.smc.LazyParticleFilter;
import pty.smc.PartialCoalescentState;

public class PriorPriorKernel
implements LazyParticleFilter.LazyParticleKernel<PartialCoalescentState> {
    @Option
    public static boolean printBranchLengthMagnitudes = false;
    private final PartialCoalescentState initial;

    public PriorPriorKernel(PartialCoalescentState initial) {
        this.initial = initial;
    }

    @Override
    public PartialCoalescentState getInitial() {
        return this.initial;
    }

    @Override
    public int nIterationsLeft(PartialCoalescentState partialState) {
        return partialState.nIterationsLeft();
    }

    public Object _next(Random rand, PartialCoalescentState current, boolean isPeek) {
        double delta = Sampling.sampleExponential(rand, (this.initial.isClock() ? 1.0 : 0.5) / PriorPriorKernel.nChoose2(current.nRoots()));
        List<Integer> sampledIndices = Sampling.sampleWithoutReplacement(rand, current.nRoots(), 2);
        int i0 = sampledIndices.get(0);
        int i1 = sampledIndices.get(1);
        double leftIncrement = 0.0;
        double rightIncrement = 0.0;
        if (!this.initial.isClock()) {
            double incr = Sampling.sampleExponential(rand, 1.0);
            if (rand.nextBoolean()) {
                leftIncrement += incr;
            } else {
                rightIncrement += incr;
            }
        }
        if (printBranchLengthMagnitudes) {
            LogInfo.logsForce("Merged things:" + current.clade(i0) + "," + current.clade(i1));
            for (int i = -20; i < 20; i += 2) {
                PartialCoalescentState result = current.coalesce(i0, i1, delta * Math.pow(2.0, i), leftIncrement, rightIncrement);
                LogInfo.logsForce("\t" + i + "\t" + delta * Math.pow(2.0, i) + "\t" + result.logLikelihoodRatio());
            }
        }
        PartialCoalescentState result = null;
        result = current.coalesce(i0, i1, delta, leftIncrement, rightIncrement);
        Double logw = null;
        if (isPeek) {
            logw = current.peekLogLikelihoodRatio(i0, i1, delta, leftIncrement, rightIncrement);
        } else {
            result = current.coalesce(i0, i1, delta, leftIncrement, rightIncrement);
        }
        if (isPeek) {
            return logw;
        }
        return Pair.makePair(result, result.logLikelihoodRatio());
    }

    public static double nChoose2(double n) {
        return n * (n - 1.0) / 2.0;
    }

    @Override
    public Pair<PartialCoalescentState, Double> next(Random rand, PartialCoalescentState current) {
        return (Pair)this._next(rand, current, false);
    }

    @Override
    public double peekNext(Random rand, PartialCoalescentState current) {
        return (Double)this._next(rand, current, true);
    }
}

