/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import fig.basic.IOUtils;
import fig.basic.NumUtils;
import fig.prob.SampleUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import nuts.io.IO;
import nuts.math.MeasureZeroException;
import nuts.math.Sampling;
import nuts.util.Counter;
import nuts.util.CounterMap;

public class CrazyGen {
    private final PhraseTable pt;
    private Random rand = new Random(1L);

    public CrazyGen(String phraseTableFile) throws IOException {
        this.pt = new PhraseTable();
        this.pt.read(phraseTableFile);
    }

    public List<Integer> sampleSegmentation(List<String> sentence) throws MeasureZeroException {
        return new SegmentationSampler(sentence).sample();
    }

    public static List<List<String>> convert(List<Integer> segments, List<String> sentence) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        if (segments.get(0) != 0) {
            ArrayList<Integer> segmentsCopy = new ArrayList<Integer>();
            segmentsCopy.add(0);
            segmentsCopy.addAll(segments);
            if (((Integer)segmentsCopy.get(segmentsCopy.size() - 1)).intValue() != sentence.size()) {
                segmentsCopy.add(sentence.size());
            }
            segments = segmentsCopy;
        }
        for (int i = 0; i < segments.size() - 1; ++i) {
            result.add(sentence.subList(segments.get(i), segments.get(i + 1)));
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.err.println("[gold phrasetable used to generate] [spanish text] [english output prefix]");
            return;
        }
        String phraseTable = args[0];
        String inputSpanishText = args[1];
        String outputEngligh = args[2];
        PrintWriter outputSpanishText = IOUtils.openOut(inputSpanishText + ".sentout");
        PrintWriter outputEnglishText = IOUtils.openOut(outputEngligh + ".sentout");
        PrintWriter outputSpSegments = IOUtils.openOut(inputSpanishText + ".segout");
        PrintWriter outputEnSegments = IOUtils.openOut(outputEngligh + ".segout");
        System.out.println("Loading phrase table");
        CrazyGen cg = new CrazyGen(phraseTable);
        for (String line : IO.i(inputSpanishText)) {
            List<String> words = Arrays.asList(line.split("\\s+"));
            try {
                List<Integer> indices = cg.sampleSegmentation(words);
                List<List<String>> phrases = CrazyGen.convert(indices, words);
                CrazyGen.sanityCheck(cg.pt.table, phrases);
                List<List<String>> translation = CrazyGen.sampleTranslation(phrases, cg.pt.table, cg.rand);
                outputSpanishText.append(CrazyGen.render(phrases, false) + "\n");
                outputSpSegments.append(CrazyGen.render(phrases, true) + "\n");
                outputEnglishText.append(CrazyGen.render(translation, false) + "\n");
                outputEnSegments.append(CrazyGen.render(translation, true) + "\n");
                System.out.print(".");
            }
            catch (MeasureZeroException mze) {
                System.err.println("No segmentation found for " + words);
            }
        }
        outputSpanishText.close();
        outputEnglishText.close();
        outputSpSegments.close();
        outputEnSegments.close();
    }

    public static List<List<String>> sampleTranslation(List<List<String>> phrases, CounterMap<List<String>, List<String>> phraseTable, Random rand) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (List<String> phrase : phrases) {
            Counter<List<String>> dist = phraseTable.getCounter(phrase);
            dist.normalize();
            result.add(CrazyGen.sample(dist, rand));
        }
        return result;
    }

    public static <T> T sample(Counter<T> counter, Random rand) {
        ArrayList<T> objects = new ArrayList<T>();
        ArrayList<Double> prs = new ArrayList<Double>();
        for (T obj : counter.keySet()) {
            objects.add(obj);
            prs.add(counter.getCount(obj));
        }
        return (T)objects.get(Sampling.sample(rand, prs));
    }

    public static String render(List<List<String>> phrases, boolean showSegments) {
        String result = showSegments ? "| " : "";
        for (List<String> phrase : phrases) {
            for (String word : phrase) {
                result = result + word + " ";
            }
            if (!showSegments) continue;
            result = result + "| ";
        }
        return result;
    }

    public static void sanityCheck(CounterMap<List<String>, List<String>> phraseTable, List<List<String>> segments) {
        for (List<String> segment : segments) {
            if (phraseTable.keySet().contains(segment)) continue;
            throw new RuntimeException();
        }
    }

    public static class PhraseTable {
        public final CounterMap<List<String>, List<String>> table = new CounterMap();
        private int maxFrenchPhraseLength = 0;

        public void read(String file) throws IOException {
            CounterMap<List<String>, List<String>> pt = this.table;
            double total = 0.0;
            double reject = 0.0;
            for (String line : IO.i(file)) {
                total += 1.0;
                try {
                    String[] fields = line.split("\\s*\\|\\|\\|\\s*");
                    List<String> f = PhraseTable.phrase(fields[0]);
                    List<String> e = PhraseTable.phrase(fields[1]);
                    if (f.size() > this.maxFrenchPhraseLength) {
                        this.maxFrenchPhraseLength = f.size();
                    }
                    String[] scoreFields = fields[4].split("\\s+");
                    double eGivenF = Double.parseDouble(scoreFields[3]);
                    pt.setCount(f, e, eGivenF);
                }
                catch (Exception e) {
                    System.err.println("Bad line: " + line);
                    reject += 1.0;
                }
            }
            System.out.println("" + reject + "/" + total + " phrase table lines rejected");
        }

        public static List<String> phrase(String field) {
            String[] words = field.split("\\s+");
            ArrayList<String> result = new ArrayList<String>(words.length);
            for (String word : words) {
                result.add(word.intern());
            }
            return result;
        }
    }

    private class SegmentationSampler {
        private final List<String> sentence;
        private final double[] costs;
        public final int UNDEF = -1;

        private SegmentationSampler(List<String> sent) {
            this.sentence = sent;
            this.costs = new double[sent.size() + 1];
            for (int i = 0; i < this.costs.length; ++i) {
                this.costs[i] = -1.0;
            }
        }

        public List<Integer> sample() throws MeasureZeroException {
            if (this.cost(this.sentence.size()) == 0.0) {
                throw new MeasureZeroException();
            }
            return this.sampleSegmentation(this.sentence.size());
        }

        private double cost(int exclLeftPos) {
            if (exclLeftPos == 0) {
                return 1.0;
            }
            if (this.costs[exclLeftPos] == -1.0) {
                double[] recursion = this.compute(exclLeftPos);
                int sum = 0;
                for (int i = 0; i < recursion.length; ++i) {
                    sum = (int)((double)sum + recursion[i]);
                }
                this.costs[exclLeftPos] = sum;
            }
            return this.costs[exclLeftPos];
        }

        private double[] compute(int exclLeftPos) {
            double[] result = new double[CrazyGen.this.pt.maxFrenchPhraseLength + 1];
            for (int phraseL = 1; phraseL <= CrazyGen.this.pt.maxFrenchPhraseLength && exclLeftPos - phraseL >= 0; ++phraseL) {
                List<String> phrase = this.sentence.subList(exclLeftPos - phraseL, exclLeftPos);
                if (!((CrazyGen)CrazyGen.this).pt.table.keySet().contains(phrase)) continue;
                result[phraseL] = this.cost(exclLeftPos - phraseL);
            }
            return result;
        }

        private List<Integer> sampleSegmentation(int exclLeftPos) {
            if (exclLeftPos == 0) {
                return new ArrayList<Integer>();
            }
            double[] prs = this.compute(exclLeftPos);
            NumUtils.normalize(prs);
            int selectedPhraseLength = SampleUtils.sampleMultinomial(CrazyGen.this.rand, prs);
            List<Integer> result = this.sampleSegmentation(exclLeftPos - selectedPhraseLength);
            result.add(exclLeftPos);
            return result;
        }
    }
}

