/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.tools;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import org.forester.archaeopteryx.MainFrameApplication;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.tools.RunnableProcess;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;
import org.forester.util.SequenceIdParser;
import org.forester.ws.seqdb.SequenceDatabaseEntry;
import org.forester.ws.seqdb.SequenceDbWsTools;

public final class SequenceDataRetriver
extends RunnableProcess {
    public static final int DEFAULT_LINES_TO_RETURN = 50;
    private final Phylogeny _phy;
    private final MainFrameApplication _mf;
    private final TreePanel _treepanel;
    private static final boolean DEBUG = false;

    public SequenceDataRetriver(MainFrameApplication mainFrameApplication, TreePanel treePanel, Phylogeny phylogeny) {
        this._phy = phylogeny;
        this._mf = mainFrameApplication;
        this._treepanel = treePanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        this.start(this._mf, "sequence data");
        SortedSet<String> sortedSet = null;
        try {
            sortedSet = SequenceDataRetriver.obtainSeqInformation(this._phy, false, true);
        }
        catch (UnknownHostException unknownHostException) {
            JOptionPane.showMessageDialog(this._mf, "Could not connect to \"_\"", "Network error during taxonomic information gathering", 0);
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(this._mf, iOException.toString(), "Failed to obtain taxonomic information", 0);
            return;
        }
        finally {
            this.end(this._mf);
        }
        this._treepanel.setTree(this._phy);
        this._mf.showWhole();
        this._treepanel.setEdited(true);
        if (sortedSet != null && sortedSet.size() > 0) {
            int n = sortedSet.size();
            boolean bl = false;
            if (n > 20) {
                bl = true;
                n = 20;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (sortedSet.size() == 1) {
                stringBuffer.append("Data for the following sequence identifier was not found:\n");
            } else {
                stringBuffer.append("Data for the following sequence identifiers was not found (total: " + sortedSet.size() + "):\n");
            }
            int n2 = 0;
            for (String string : sortedSet) {
                if (n2 > 19) break;
                stringBuffer.append(string);
                stringBuffer.append("\n");
                ++n2;
            }
            if (bl) {
                stringBuffer.append("...");
            }
            try {
                JOptionPane.showMessageDialog(this._mf, stringBuffer.toString(), "Sequence Tool Completed", 2);
            }
            catch (Exception exception) {}
        } else {
            try {
                JOptionPane.showMessageDialog(this._mf, "Sequence tool successfully completed", "Sequence Tool Completed", 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static SortedSet<String> obtainSeqInformation(Phylogeny phylogeny, boolean bl, boolean bl2) throws IOException {
        TreeSet<String> treeSet = new TreeSet<String>();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (bl && phylogenyNode.isInternal()) continue;
            Sequence sequence = phylogenyNode.getNodeData().isHasSequence() ? phylogenyNode.getNodeData().getSequence() : new Sequence();
            Taxonomy taxonomy = phylogenyNode.getNodeData().isHasTaxonomy() ? phylogenyNode.getNodeData().getTaxonomy() : new Taxonomy();
            String string = null;
            Identifier identifier = null;
            Db db = Db.NONE;
            if (phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getAccession() != null && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getAccession().getSource()) && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getAccession().getValue()) && phylogenyNode.getNodeData().getSequence().getAccession().getValue().toLowerCase().startsWith("uniprot")) {
                string = phylogenyNode.getNodeData().getSequence().getAccession().getValue();
                db = Db.UNIPROT;
            } else if (phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getAccession() != null && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getAccession().getSource()) && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getAccession().getValue()) && (phylogenyNode.getNodeData().getSequence().getAccession().getValue().toLowerCase().startsWith("embl") || phylogenyNode.getNodeData().getSequence().getAccession().getValue().toLowerCase().startsWith("ebi"))) {
                string = phylogenyNode.getNodeData().getSequence().getAccession().getValue();
                db = Db.EMBL;
            } else if (!ForesterUtil.isEmpty(phylogenyNode.getName())) {
                string = SequenceDbWsTools.parseUniProtAccessor(phylogenyNode.getName());
                if (string != null) {
                    db = Db.UNIPROT;
                } else {
                    identifier = SequenceIdParser.parse(phylogenyNode.getName());
                    if (identifier != null) {
                        if (identifier.getProvider().equalsIgnoreCase("ncbi")) {
                            db = Db.NCBI;
                        } else if (identifier.getProvider().equalsIgnoreCase("refseq")) {
                            db = Db.REFSEQ;
                        }
                    }
                }
            }
            if (db == Db.NONE) {
                treeSet.add(phylogenyNode.getName());
            }
            SequenceDatabaseEntry sequenceDatabaseEntry = null;
            if (!ForesterUtil.isEmpty(string)) {
                if (db == Db.UNIPROT) {
                    sequenceDatabaseEntry = SequenceDbWsTools.obtainUniProtEntry(string, 50);
                }
                if (db == Db.EMBL || db == Db.UNIPROT && sequenceDatabaseEntry == null) {
                    sequenceDatabaseEntry = SequenceDbWsTools.obtainEmblEntry(new Identifier(string), 50);
                    if (db == Db.UNIPROT && sequenceDatabaseEntry != null) {
                        db = Db.EMBL;
                    }
                }
            } else if (db == Db.REFSEQ && identifier != null) {
                sequenceDatabaseEntry = SequenceDbWsTools.obtainRefSeqEntryFromEmbl(identifier, 50);
            } else if (db == Db.NCBI && identifier != null) {
                sequenceDatabaseEntry = SequenceDbWsTools.obtainEmblEntry(identifier, 50);
            }
            if (sequenceDatabaseEntry != null && !sequenceDatabaseEntry.isEmpty()) {
                if (!ForesterUtil.isEmpty(sequenceDatabaseEntry.getAccession())) {
                    String string2 = null;
                    if (db == Db.EMBL) {
                        string2 = "embl";
                    } else if (db == Db.UNIPROT) {
                        string2 = "uniprot";
                    } else if (db == Db.NCBI) {
                        string2 = "ncbi";
                    } else if (db == Db.REFSEQ) {
                        string2 = "refseq";
                    }
                    sequence.setAccession(new Accession(sequenceDatabaseEntry.getAccession(), string2));
                }
                if (!ForesterUtil.isEmpty(sequenceDatabaseEntry.getSequenceName())) {
                    sequence.setName(sequenceDatabaseEntry.getSequenceName());
                }
                if (!ForesterUtil.isEmpty(sequenceDatabaseEntry.getSequenceSymbol())) {
                    sequence.setSymbol(sequenceDatabaseEntry.getSequenceSymbol());
                }
                if (!ForesterUtil.isEmpty(sequenceDatabaseEntry.getTaxonomyScientificName())) {
                    taxonomy.setScientificName(sequenceDatabaseEntry.getTaxonomyScientificName());
                }
                if (bl2 && !ForesterUtil.isEmpty(sequenceDatabaseEntry.getTaxonomyIdentifier())) {
                    taxonomy.setIdentifier(new Identifier(sequenceDatabaseEntry.getTaxonomyIdentifier(), "uniprot"));
                }
                phylogenyNode.getNodeData().setTaxonomy(taxonomy);
                phylogenyNode.getNodeData().setSequence(sequence);
            } else if (db != Db.NONE) {
                treeSet.add(phylogenyNode.getName());
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return treeSet;
    }

    @Override
    public void run() {
        this.execute();
    }

    private static enum Db {
        UNIPROT,
        EMBL,
        NCBI,
        NONE,
        REFSEQ;

    }
}

