/*
 * Decompiled with CFR 0.152.
 */
package conifer.largemove;

import conifer.largemove.LargeMoveUtils;
import conifer.largemove.MicroGibbsResult;
import conifer.multicategories.PhylogeneticFactorGraph;
import fenchel.factor.FactorUtils;
import fenchel.factor.UnaryFactor;
import fenchel.factor.multisitecat.MSCBinaryScaledFactor;
import fig.basic.Pair;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.Collections;
import nuts.util.Arbre;

public class LargeMoveOperator {
    public static MicroGibbsResult efficientMicroGibbs(PhylogeneticFactorGraph factorGraph, Pair<Arbre<Taxon>, Arbre<Taxon>> _edge, double[] branchLengths, boolean onlyBranches, boolean forceBreak) {
        if (forceBreak && onlyBranches) {
            throw new RuntimeException();
        }
        boolean isRoot = _edge.getFirst().isRoot();
        Taxon parent = isRoot ? null : _edge.getFirst().getParent().getContents();
        MicroGibbsResult result = new MicroGibbsResult(branchLengths, LargeMoveUtils.originalTaxonOrder(parent, factorGraph.getFactorGraph().getTopology(), _edge), _edge);
        Taxon[] edge = new Taxon[]{_edge.getFirst().getContents(), _edge.getSecond().getContents()};
        MSCBinaryScaledFactor[] binaryFactors = new MSCBinaryScaledFactor[branchLengths.length];
        for (int blIndex = 0; blIndex < branchLengths.length; ++blIndex) {
            MSCBinaryScaledFactor currentFactor;
            binaryFactors[blIndex] = currentFactor = factorGraph.getBinaryFactor(branchLengths[blIndex], false);
        }
        UnaryFactor[] modelFactors = new UnaryFactor[2];
        for (int clade = 0; clade < 2; ++clade) {
            modelFactors[clade] = factorGraph.getFactorGraph().getUnary(edge[clade]);
        }
        for (int config = 0; config < (onlyBranches ? 1 : 3); ++config) {
            if (forceBreak && config == 0) continue;
            UnaryFactor[] factors = new UnaryFactor[2];
            for (int clade = 0; clade < 2; ++clade) {
                ArrayList<UnaryFactor> toMultiply = new ArrayList<UnaryFactor>();
                for (int i = 0; i < 2; ++i) {
                    Taxon current = result.getTaxon(config, clade, i);
                    if (current == null) continue;
                    UnaryFactor currentFactor = factorGraph.getSumProductPosteriorCalculator().getMessage(current, edge[clade]);
                    if (currentFactor == null) {
                        currentFactor = factorGraph.getSumProductPosteriorCalculator().getMessage(current, edge[LargeMoveUtils.shuffle(clade, 0, 1)]);
                    }
                    if (currentFactor == null) {
                        throw new RuntimeException();
                    }
                    toMultiply.add(currentFactor);
                }
                toMultiply.add(modelFactors[clade]);
                factors[clade] = FactorUtils.multiply(toMultiply);
            }
            for (int blIndex = 0; blIndex < branchLengths.length; ++blIndex) {
                result.logProbabilities[result.prsIndex((int)config, (int)blIndex)] = binaryFactors[blIndex].marginalize(Collections.singletonList(factors[0])).multiply(Collections.singletonList(factors[1])).logNorm();
            }
        }
        return result;
    }
}

