/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.MathUtils;

public class Poisson {
    private static double oldm = -1.0;
    private static double sq;
    private static double alxm;
    private static double g;
    private static final double[] cof;

    private Poisson() {
    }

    public static int nextPoisson(double xm) {
        double em;
        if (xm < 12.0) {
            if (xm != oldm) {
                oldm = xm;
                g = Math.exp(-xm);
            }
            em = -1.0;
            double t = 1.0;
            do {
                em += 1.0;
            } while ((t *= MathUtils.nextDouble()) > g);
        } else {
            if (xm != oldm) {
                oldm = xm;
                sq = Math.sqrt(2.0 * xm);
                alxm = Math.log(xm);
                g = xm * alxm - Poisson.gammln(xm + 1.0);
            }
            while (true) {
                double y;
                if ((em = sq * (y = Math.tan(Math.PI * MathUtils.nextDouble())) + xm) < 0.0) {
                    continue;
                }
                em = Math.floor(em);
                double t = 0.9 * (1.0 + y * y) * Math.exp(em * alxm - Poisson.gammln(em + 1.0) - g);
                if (!(MathUtils.nextDouble() > t)) break;
            }
        }
        return (int)em;
    }

    public static double gammln(double xx) {
        double x;
        double y = x = xx;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        double ser = 1.000000000190015;
        for (int j = 0; j <= 5; ++j) {
            ser += cof[j] / (y += 1.0);
        }
        return -tmp + Math.log(2.5066282746310007 * ser / x);
    }

    static {
        cof = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
    }
}

