/*
 * Decompiled with CFR 0.152.
 */
package dr.math.matrixAlgebra;

import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.LUPDecomposition;
import dr.math.matrixAlgebra.SymmetricMatrix;
import dr.math.matrixAlgebra.Vector;

public class Matrix {
    protected double[][] components;
    protected LUPDecomposition lupDecomposition = null;

    public Matrix(double[][] a) {
        this.components = a;
    }

    public Matrix(double[] a, int n, int m) {
        if (n <= 0 || m <= 0) {
            throw new NegativeArraySizeException("Requested matrix size: " + n + " by " + m);
        }
        if (n * m != a.length) {
            throw new IllegalArgumentException("Requested matrix size: " + n + " by " + m + " doesn't match array size: " + a.length);
        }
        this.components = new double[n][m];
        int k = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                this.components[i][j] = a[k];
                ++k;
            }
        }
    }

    public Matrix(int n, int m) throws NegativeArraySizeException {
        if (n <= 0 || m <= 0) {
            throw new NegativeArraySizeException("Requested matrix size: " + n + " by " + m);
        }
        this.components = new double[n][m];
        this.clear();
    }

    public void accumulate(Matrix a) throws IllegalDimension {
        if (a.rows() != this.rows() || a.columns() != this.columns()) {
            throw new IllegalDimension("Operation error: cannot add a" + a.rows() + " by " + a.columns() + " matrix to a " + this.rows() + " by " + this.columns() + " matrix");
        }
        int m = this.components[0].length;
        for (int i = 0; i < this.components.length; ++i) {
            for (int j = 0; j < m; ++j) {
                double[] dArray = this.components[i];
                int n = j;
                dArray[n] = dArray[n] + a.component(i, j);
            }
        }
    }

    public Matrix add(Matrix a) throws IllegalDimension {
        if (a.rows() != this.rows() || a.columns() != this.columns()) {
            throw new IllegalDimension("Operation error: cannot add a" + a.rows() + " by " + a.columns() + " matrix to a " + this.rows() + " by " + this.columns() + " matrix");
        }
        return new Matrix(this.addComponents(a));
    }

    protected double[][] addComponents(Matrix a) {
        int n = this.rows();
        int m = this.columns();
        double[][] newComponents = new double[n][m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                newComponents[i][j] = this.components[i][j] + a.components[i][j];
            }
        }
        return newComponents;
    }

    public void clear() {
        int m = this.components[0].length;
        for (int i = 0; i < this.components.length; ++i) {
            for (int j = 0; j < m; ++j) {
                this.components[i][j] = 0.0;
            }
        }
    }

    public int columns() {
        return this.components[0].length;
    }

    public double component(int n, int m) {
        return this.components[n][m];
    }

    public double determinant() throws IllegalDimension {
        return this.lupDecomposition().determinant();
    }

    public boolean isPD() throws IllegalDimension {
        return this.lupDecomposition().isPD();
    }

    public boolean equals(Matrix a) {
        int n = this.rows();
        if (a.rows() != n) {
            return false;
        }
        int m = this.columns();
        if (a.columns() != m) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (a.components[i][j] == this.components[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public Matrix inverse() throws ArithmeticException {
        try {
            return new Matrix(this.lupDecomposition().inverseMatrixComponents());
        }
        catch (IllegalDimension e) {
            return new Matrix(this.transposedProduct().inverse().productWithTransposedComponents(this));
        }
    }

    public boolean isSquare() {
        return this.rows() == this.columns();
    }

    protected LUPDecomposition lupDecomposition() throws IllegalDimension {
        if (this.lupDecomposition == null) {
            this.lupDecomposition = new LUPDecomposition(this);
        }
        return this.lupDecomposition;
    }

    public Matrix product(double a) {
        return new Matrix(this.productComponents(a));
    }

    public Vector product(Vector v) throws IllegalDimension {
        int n = this.rows();
        int m = this.columns();
        if (v.dimension() != m) {
            throw new IllegalDimension("Product error: " + n + " by " + m + " matrix cannot by multiplied with vector of dimension " + v.dimension());
        }
        return this.secureProduct(v);
    }

    public Matrix product(Matrix a) throws IllegalDimension {
        if (a.rows() != this.columns()) {
            throw new IllegalDimension("Operation error: cannot multiply a" + this.rows() + " by " + this.columns() + " matrix with a " + a.rows() + " by " + a.columns() + " matrix");
        }
        return new Matrix(this.productComponents(a));
    }

    protected double[][] productComponents(double a) {
        int n = this.rows();
        int m = this.columns();
        double[][] newComponents = new double[n][m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                newComponents[i][j] = a * this.components[i][j];
            }
        }
        return newComponents;
    }

    protected double[][] productComponents(Matrix a) {
        int p = this.columns();
        int n = this.rows();
        int m = a.columns();
        double[][] newComponents = new double[n][m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                double sum = 0.0;
                for (int k = 0; k < p; ++k) {
                    sum += this.components[i][k] * a.components[k][j];
                }
                newComponents[i][j] = sum;
            }
        }
        return newComponents;
    }

    public Matrix productWithTransposed(Matrix a) throws IllegalDimension {
        if (a.columns() != this.columns()) {
            throw new IllegalDimension("Operation error: cannot multiply a " + this.rows() + " by " + this.columns() + " matrix with the transpose of a " + a.rows() + " by " + a.columns() + " matrix");
        }
        return new Matrix(this.productWithTransposedComponents(a));
    }

    protected double[][] productWithTransposedComponents(Matrix a) {
        int p = this.columns();
        int n = this.rows();
        int m = a.rows();
        double[][] newComponents = new double[n][m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                double sum = 0.0;
                for (int k = 0; k < p; ++k) {
                    sum += this.components[i][k] * a.components[j][k];
                }
                newComponents[i][j] = sum;
            }
        }
        return newComponents;
    }

    public int rows() {
        return this.components.length;
    }

    protected Vector secureProduct(Vector v) {
        int n = this.rows();
        int m = this.columns();
        double[] vectorComponents = new double[n];
        for (int i = 0; i < n; ++i) {
            vectorComponents[i] = 0.0;
            for (int j = 0; j < m; ++j) {
                int n2 = i;
                vectorComponents[n2] = vectorComponents[n2] + this.components[i][j] * v.components[j];
            }
        }
        return new Vector(vectorComponents);
    }

    protected Matrix secureProduct(Matrix a) {
        return new Matrix(this.productComponents(a));
    }

    protected Matrix secureSubtract(Matrix a) {
        return new Matrix(this.subtractComponents(a));
    }

    public Matrix subtract(Matrix a) throws IllegalDimension {
        if (a.rows() != this.rows() || a.columns() != this.columns()) {
            throw new IllegalDimension("Product error: cannot subtract a" + a.rows() + " by " + a.columns() + " matrix to a " + this.rows() + " by " + this.columns() + " matrix");
        }
        return new Matrix(this.subtractComponents(a));
    }

    protected double[][] subtractComponents(Matrix a) {
        int n = this.rows();
        int m = this.columns();
        double[][] newComponents = new double[n][m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                newComponents[i][j] = this.components[i][j] - a.components[i][j];
            }
        }
        return newComponents;
    }

    public double[][] toComponents() {
        int n = this.rows();
        int m = this.columns();
        double[][] answer = new double[n][m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                answer[i][j] = this.components[i][j];
            }
        }
        return answer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        char[] separator = new char[]{'[', ' '};
        int n = this.rows();
        int m = this.columns();
        for (int i = 0; i < n; ++i) {
            separator[0] = 123;
            for (int j = 0; j < m; ++j) {
                sb.append(separator);
                sb.append(this.components[i][j]);
                separator[0] = 32;
            }
            sb.append('}');
            sb.append('\n');
        }
        return sb.toString();
    }

    public String toStringOctave() {
        StringBuffer sb = new StringBuffer();
        int n = this.rows();
        int m = this.columns();
        sb.append("[ ");
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                sb.append(this.components[i][j]);
                if (j == m - 1) {
                    if (i == n - 1) {
                        sb.append(" ");
                        continue;
                    }
                    sb.append("; ");
                    continue;
                }
                sb.append(", ");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public Matrix transpose() {
        int n = this.rows();
        int m = this.columns();
        double[][] newComponents = new double[m][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                newComponents[j][i] = this.components[i][j];
            }
        }
        return new Matrix(newComponents);
    }

    public SymmetricMatrix transposedProduct() {
        return new SymmetricMatrix(this.transposedProductComponents(this));
    }

    public Matrix transposedProduct(Matrix a) throws IllegalDimension {
        if (a.rows() != this.rows()) {
            throw new IllegalDimension("Operation error: cannot multiply a tranposed " + this.rows() + " by " + this.columns() + " matrix with a " + a.rows() + " by " + a.columns() + " matrix");
        }
        return new Matrix(this.transposedProductComponents(a));
    }

    protected double[][] transposedProductComponents(Matrix a) {
        int p = this.rows();
        int n = this.columns();
        int m = a.columns();
        double[][] newComponents = new double[n][m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                double sum = 0.0;
                for (int k = 0; k < p; ++k) {
                    sum += this.components[k][i] * a.components[k][j];
                }
                newComponents[i][j] = sum;
            }
        }
        return newComponents;
    }
}

