/*
 * Decompiled with CFR 0.152.
 */
package emc;

import comm.EMCCommException;
import comm.Message;
import comm.ProxyNode;
import comm.ServerMessenger;
import conifer.exp.ExperimentsUtils;
import emc.EMCParticle;
import emc.Genealogy;
import emc.LocalGenealogy;
import emc.SimulateEMC;
import emc.StochasticMaps;
import emc.Timer;
import emc.VirtualGenealogy;
import fig.basic.LogInfo;
import gep.util.OutputManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import monaco.process.ProcessSchedule;
import monaco.process.ProcessScheduleContext;
import monaco.process.ResampleStatus;
import nuts.io.OutputProducer;
import nuts.math.Sampling;
import nuts.maxent.SloppyMath;
import nuts.util.CollUtils;
import nuts.util.Counter;
import nuts.util.MathUtils;
import pty.smc.ParticleFilter;
import pty.smc.ParticleKernel;

public class EMCNode<S>
implements OutputProducer {
    public static final int SERVER_NODE_ID = 0;
    public static final boolean DEBUG = false;
    public static boolean verbose = false;
    private int nodeId;
    private String bootstrapIp;
    private int bootstrapPort;
    private int K;
    private int M;
    private int R;
    private int max;
    private boolean transferExperiment = false;
    private Genealogy<S> genealogy;
    private List<EMCNode<S>> nodes;
    private Random resampler;
    private Timer timer;
    private OutputManager manager = new OutputManager();
    private ServerMessenger serverMessenger = null;
    private ProcessSchedule schedule;

    public EMCNode(int nodeId, String bootstrapIp, int bootstrapPort, int K, int M, int max, int seed1, int seed2, ParticleKernel<S> kernel, boolean transferExperiment, ParticleFilter.ParticleProcessor<S> processor, ProcessSchedule schedule) {
        this.nodeId = nodeId;
        this.bootstrapIp = bootstrapIp;
        this.bootstrapPort = bootstrapPort;
        this.K = K;
        this.M = M;
        this.max = max;
        this.R = kernel.nIterationsLeft(kernel.getInitial());
        this.transferExperiment = transferExperiment;
        this.schedule = schedule;
        this.timer = new Timer();
        this.resampler = new Random((int)((double)(seed1 * seed2) / 7.0));
        StochasticMaps maps = new StochasticMaps(kernel.nIterationsLeft(kernel.getInitial()), K, seed1, seed2);
        this.genealogy = new LocalGenealogy<S>(nodeId, K, max, kernel, maps, transferExperiment, processor);
        this.nodes = CollUtils.list();
        for (int m = 0; m < M; ++m) {
            EMCNode<S> node = m != nodeId ? new EMCNode<S>(m, K, M, max, seed1, seed2, kernel) : this;
            this.nodes.add(node);
        }
    }

    public EMCNode(int nodeId, int K, int M, int max, int seed1, int seed2, ParticleKernel<S> kernel) {
        this.nodeId = nodeId;
        this.K = K;
        this.M = M;
        this.R = kernel.nIterationsLeft(kernel.getInitial());
        this.timer = new Timer();
        StochasticMaps maps = new StochasticMaps(kernel.nIterationsLeft(kernel.getInitial()), K, seed1, seed2);
        this.genealogy = new VirtualGenealogy<S>(nodeId, K, max, kernel, maps);
    }

    public void launch() {
        try {
            if (this.nodeId == 0) {
                this.serverMessenger = new ServerMessenger(this.M, this.bootstrapPort);
                boolean success = this.serverMessenger.initConnections();
                if (!success) {
                    EMCNode.Loginfo("Connection initialization failed.");
                    System.exit(-1);
                }
                EMCNode.Loginfo("EMC is ready to begin");
                EMCNode.Loginfo("Broadcast ready message to all of the nodes");
                this.serverMessenger.broadcast(new Message(this.nodeId, 2));
            } else {
                ProxyNode serverNode = new ProxyNode(this.bootstrapIp, this.bootstrapPort);
                serverNode.sendMessageToServer(new Message(this.nodeId, 1));
                Message msg = serverNode.receiveMessageFromServer();
                if (msg.message != 2) {
                    EMCNode.Loginfo("EMC initialization failed.");
                    System.exit(-1);
                }
                EMCNode.Loginfo("EMC is ready to begin");
            }
            this.timer.begin();
            this.emc();
            EMCNode.Loginfo("Ending EMC... time elapsed:" + this.timer.elapsedTimeInMinutes() + " minutes.");
        }
        catch (IOException ie) {
            EMCNode.Loginfo(ie.getMessage());
        }
        catch (ClassNotFoundException ce) {
            EMCNode.Loginfo(ce.getMessage());
        }
        catch (EMCCommException ece) {
            EMCNode.Loginfo("EMCCommException: " + ece);
        }
        if (this.nodeId == 0) {
            this.serverMessenger.close();
        }
        double grandTotal = ((LocalGenealogy)this.genealogy).te.getGrandTotal();
        this.logParticleSize("Total particle size", grandTotal, this.R);
        this.manager.close();
    }

    public Message propagate() {
        long r = this.genealogy.getGenerations();
        List<Double> localWeights = null;
        for (EMCNode<S> node : this.nodes) {
            if (node.nodeId == this.nodeId) {
                localWeights = node.genealogy.generateSamples(r);
                continue;
            }
            node.genealogy.generateSamples(r);
        }
        Message msg = new Message(this.nodeId, 3, localWeights);
        return msg;
    }

    public void resampleAndAllocate(Message[] weightMsgs, double[] sums) {
        long r = this.genealogy.getGenerations();
        if (SimulateEMC.scheme == SimulateEMC.Allocation.Chaos) {
            this.resampleHelper(weightMsgs, sums, r);
        } else {
            Counter<Integer> counts = Sampling.efficientMultinomialSampling(this.resampler, sums, this.K);
            this.resampleHelper(counts, weightMsgs, sums, r);
        }
    }

    private void emc() {
        List<Double> localWeights = null;
        EMCNode.Loginfo("R:" + this.R);
        Timer tt = new Timer();
        for (int r = 0; r < this.R; ++r) {
            tt.begin();
            for (EMCNode<S> node : this.nodes) {
                if (node.nodeId == this.nodeId) {
                    localWeights = node.genealogy.generateSamples(r);
                    continue;
                }
                node.genealogy.generateSamples(r);
            }
            this.logTimes(tt, "Sample geneartion", r);
            this.logTimes(((LocalGenealogy)this.genealogy).reconstructionTimer, "Reconstruction", r);
            if (this.transferExperiment) {
                double particleSize = ((LocalGenealogy)this.genealogy).te.clearSubTotal();
                this.logParticleSize("Particle transfer", particleSize, r);
                EMCNode.Loginfo("Total size of particles to be transferred is " + particleSize + " bytes.");
            }
            if (this.schedule != null && this.schedule.shouldProcess(new ProcessScheduleContext(r, r == this.R - 1, ResampleStatus.NA))) {
                this.genealogy.processParticles();
            }
            tt.begin();
            Message[] weightMsgs = null;
            if (this.nodeId == 0) {
                try {
                    weightMsgs = this.serverMessenger.listenForWeights(localWeights);
                    this.serverMessenger.broadcast(new Message(0, 4, weightMsgs));
                }
                catch (IOException ie) {
                    EMCNode.Loginfo(ie.getMessage());
                }
                catch (ClassNotFoundException ce) {
                    EMCNode.Loginfo(ce.getMessage());
                }
                catch (EMCCommException ecce) {
                    EMCNode.Loginfo(ecce.getMessage());
                }
            } else {
                try {
                    ProxyNode serverNode = new ProxyNode(this.bootstrapIp, this.bootstrapPort);
                    serverNode.sendMessageToServer(new Message(this.nodeId, 3, localWeights));
                    Message msg = serverNode.receiveMessageFromServer();
                    if (msg.message != 4) {
                        EMCNode.Loginfo("Unexpected message received from the server. Terminate.");
                        System.exit(-1);
                    }
                    weightMsgs = msg.msgs;
                }
                catch (IOException ie) {
                    EMCNode.Loginfo(ie.getMessage());
                }
                catch (EMCCommException emce) {
                    EMCNode.Loginfo(emce.getMessage());
                }
                catch (ClassNotFoundException ce) {
                    EMCNode.Loginfo(ce.getMessage());
                }
            }
            this.logTimes(tt, "Weight communication", r);
            this.printWeights(weightMsgs);
            tt.begin();
            double[] sums = new double[this.M];
            EMCNode.normalizeWeights(weightMsgs, sums, this.K);
            this.logTimes(tt, "Normalization", r);
            tt.begin();
            Counter<Integer> counts = Sampling.efficientMultinomialSampling(this.resampler, sums, this.K);
            this.resampleHelper(counts, weightMsgs, sums, r);
            this.logTimes(tt, "Resample + allocation", r);
            this.printResampled(counts);
            if (this.schedule == null) continue;
            this.schedule.monitor(new ProcessScheduleContext(r, r == this.R - 1, ResampleStatus.NA));
        }
    }

    public static void normalizeWeights(Message[] weightMsgs, double[] sums, int K) {
        double[] ww = new double[K];
        int M = sums.length;
        int k = 0;
        for (int m = 0; m < M; ++m) {
            for (Double w : weightMsgs[m].weights) {
                ww[k++] = w;
            }
        }
        double norm = SloppyMath.logAdd(ww);
        double check = 0.0;
        double normW = 0.0;
        for (int m = 0; m < M; ++m) {
            List<Double> weights = weightMsgs[m].weights;
            for (int i = 0; i < weights.size(); ++i) {
                normW = Math.exp(weights.get(i) - norm);
                weights.set(i, new Double(normW));
                int n = m;
                sums[n] = sums[n] + normW;
            }
            EMCNode.Loginfo("nodeId=" + m + " sum=" + sums[m]);
            check += sums[m];
        }
        EMCNode.Loginfo("total sum=" + check);
        MathUtils.checkClose(check, 1.0);
    }

    public void resampleHelper(Message[] weightMsgs, double[] sums, long r) {
        Counter<Integer> counts = Sampling.efficientMultinomialSampling(this.resampler, sums, this.K);
        ArrayList<EMCParticle> parents = CollUtils.list();
        for (int m = 0; m < this.M; ++m) {
            parents.addAll(this.nodes.get((int)m).genealogy.resample(r, this.resampler, weightMsgs[m].weights, sums[m], (int)counts.getCount(m)));
        }
        if (parents.size() != this.K) {
            throw new RuntimeException();
        }
        int[] cap = new int[this.M];
        for (int m = 0; m < this.M; ++m) {
            cap[m] = this.nodes.get((int)m).genealogy.getCapacity();
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        for (EMCParticle parent : parents) {
            int m;
            sb.append(parent.getId() + " ");
            while (cap[m = this.resampler.nextInt(this.M)] <= 0) {
            }
            sb2.append(m + " ");
            this.nodes.get((int)m).genealogy.allocate(parent, r);
            int n = m;
            cap[n] = cap[n] - 1;
        }
    }

    private void resampleHelper(Counter<Integer> counts, Message[] weightMsgs, double[] sums, long r) {
        ArrayList<EMCParticle<S>> rejected = CollUtils.list();
        for (int m = 0; m < this.M; ++m) {
            EMCNode<S> node = this.nodes.get(m);
            EMCNode.Loginfo(this.nodeId + " resampling for nodeId=" + node.nodeId);
            rejected.addAll(node.genealogy.resample(r, this.resampler, weightMsgs[m].weights, sums[m], (int)counts.getCount(m)));
        }
        EMCNode.Loginfo("Resampling done... begin allocation...");
        if (SimulateEMC.scheme == SimulateEMC.Allocation.FirstOpen) {
            this.firstOpenAllocation(rejected, r);
        } else if (SimulateEMC.scheme == SimulateEMC.Allocation.MostAvailable) {
            this.mostAvailableAllocation(rejected, r);
        } else if (SimulateEMC.scheme == SimulateEMC.Allocation.Random) {
            this.randomAllocation(rejected, r);
        }
    }

    private void mostAvailableAllocation(List<EMCParticle<S>> rejected, long r) {
        int[] cap = new int[this.M];
        for (int m = 0; m < this.M; ++m) {
            cap[m] = this.nodes.get((int)m).genealogy.getCapacity();
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        int maxMachine = 0;
        int max = cap[maxMachine];
        int gap = 0;
        for (EMCParticle<S> rejectedParticle : rejected) {
            sb.append(rejectedParticle.getId() + " ");
            if (gap == 0) {
                maxMachine = 0;
                max = 0;
                for (int m = 0; m < this.M; ++m) {
                    if (cap[m] <= max) continue;
                    gap = cap[m] - max;
                    max = cap[m];
                    maxMachine = m;
                }
            }
            if (gap == 0) {
                throw new RuntimeException();
            }
            sb2.append(maxMachine + " ");
            this.nodes.get((int)maxMachine).genealogy.allocate(rejectedParticle, r);
            int n = maxMachine;
            cap[n] = cap[n] - 1;
            --gap;
        }
    }

    private void firstOpenAllocation(List<EMCParticle<S>> rejected, long r) {
        int[] cap = new int[this.M];
        for (int m = 0; m < this.M; ++m) {
            cap[m] = this.nodes.get((int)m).genealogy.getCapacity();
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        block1: for (EMCParticle<S> rejectedParticle : rejected) {
            sb.append(rejectedParticle.getId() + " ");
            for (int m = 0; m < this.M; ++m) {
                if (cap[m] <= 0) continue;
                sb2.append(m + " ");
                this.nodes.get((int)m).genealogy.allocate(rejectedParticle, r);
                int n = m;
                cap[n] = cap[n] - 1;
                continue block1;
            }
        }
    }

    private void randomAllocation(List<EMCParticle<S>> rejected, long r) {
        int[] cap = new int[this.M];
        for (int m = 0; m < this.M; ++m) {
            cap[m] = this.nodes.get((int)m).genealogy.getCapacity();
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        for (EMCParticle<S> rejectedParticle : rejected) {
            int m;
            sb.append(rejectedParticle.getId() + " ");
            while (cap[m = this.resampler.nextInt(this.M)] <= 0) {
            }
            sb2.append(m + " ");
            this.nodes.get((int)m).genealogy.allocate(rejectedParticle, r);
            int n = m;
            cap[n] = cap[n] - 1;
        }
    }

    private void logTimes(Timer tt, String msg, int r) {
        Object[] context = new Object[]{"generation", r, "msg", msg, "ticks", tt.elapsedTimeInMillis()};
        this.manager.write("timing", ExperimentsUtils.concat(context, new Object[0]));
    }

    private void logParticleSize(String msg, double size, int r) {
        Object[] context = new Object[]{"generation", r, "msg", msg, "ticks", size};
        this.manager.write("timing", ExperimentsUtils.concat(context, new Object[0]));
    }

    private void printResampled(Counter<Integer> counts) {
    }

    private void printWeights(Message[] weightMessages) {
    }

    private String converWeightsToString(List<Double> w) {
        return "";
    }

    public static void Loginfo(String msg) {
        if (verbose) {
            LogInfo.logs(msg);
        }
    }

    @Override
    public void setOutputFolder(File f) {
        this.manager.setOutputFolder(f);
    }
}

