/*
 * Decompiled with CFR 0.152.
 */
package ev.poi;

import ev.hmm.HetPairHMM;
import ev.par.ExponentialFamily;
import ev.par.FeatureExtractor;
import ev.poi.HomologySampler;
import ev.poi.MSAMarginalLikelihoodCalculator;
import fig.basic.Option;
import fig.basic.Pair;
import goblin.CognateId;
import goblin.Taxon;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import ma.BalibaseCorpus;
import ma.MSAPoset;
import ma.MultiAlignment;
import ma.RateMatrixLoader;
import nuts.io.IO;
import nuts.math.MtxUtils;
import nuts.maxent.MaxentClassifier;
import nuts.util.CollUtils;
import nuts.util.Indexer;
import pty.RootedTree;

public class HomologySamplerMain
implements Runnable {
    public static ExponentialFamily.ExponentialFamilyOptions expFamOptions = new ExponentialFamily.ExponentialFamilyOptions();
    public static FeatureExtractor.FeatureOptions featureOptions = new FeatureExtractor.FeatureOptions();
    public static MaxentClassifier.MaxentOptions<Object> learningOptions = new MaxentClassifier.MaxentOptions();
    public static BalibaseCorpus.BalibaseCorpusOptions baliopt = new BalibaseCorpus.BalibaseCorpusOptions();
    @Option
    public double insertRate = 1.0;
    @Option
    public double delRate = 1.0;

    public static void main(String[] args) {
        IO.run(args, new HomologySamplerMain(), "bali", baliopt, "efo", expFamOptions, "featop", featureOptions, "lo", learningOptions);
    }

    public static Map<Pair<Taxon, Taxon>, double[][]> createConditionals(ExponentialFamily expfam, Map<Taxon, String> seqs) {
        HashMap<Pair<Taxon, Taxon>, double[][]> result = CollUtils.map();
        for (Taxon lang1 : seqs.keySet()) {
            for (Taxon lang2 : seqs.keySet()) {
                if (lang1.equals(lang2)) continue;
                String str1 = seqs.get(lang1);
                String str2 = seqs.get(lang2);
                HetPairHMM hmm = expfam.getHMM(str1, str2, lang1, lang2);
                double[][] mtx = new double[str1.length()][str2.length()];
                for (int p1 = 0; p1 < str1.length(); ++p1) {
                    for (int p2 = 0; p2 < str2.length(); ++p2) {
                        mtx[p1][p2] = Math.exp(hmm.logPosteriorAlignment(p1, p2));
                    }
                }
                MtxUtils.normalizeWeightsByRow(mtx);
                result.put(Pair.makePair(lang1, lang2), mtx);
            }
        }
        return result;
    }

    @Override
    public void run() {
        Random rand = new Random(1L);
        BalibaseCorpus bc = new BalibaseCorpus(baliopt);
        CognateId id = CollUtils.pick(bc.intersectedIds());
        double[][] subRates = RateMatrixLoader.dayhoff();
        Indexer<Character> indexer = RateMatrixLoader.proteinIndexer();
        ExponentialFamily expFam = ExponentialFamily.createExpfam(learningOptions, expFamOptions, featureOptions, bc.getDistances());
        MultiAlignment _ma = bc.getMultiAlignment(id);
        MSAPoset msa = new MSAPoset(_ma.getSequences());
        RootedTree rt = RootedTree.Util.fromBalibase(bc, id);
        MSAMarginalLikelihoodCalculator calc = null;
        HomologySampler.InformedEdgeSelector selector = new HomologySampler.InformedEdgeSelector(HomologySamplerMain.createConditionals(expFam, msa.sequences()), msa.sequences());
        HomologySampler sampler = new HomologySampler();
        System.out.println("#iter\tscore\tLL\thasEdgeMean\tinvalidAddMean\tsplitRatioMean\tmergeRatioMean");
        for (int i = 0; i < 500000000; ++i) {
            sampler.homologySamplingStep(selector.next(rand), msa, calc, rand);
            if (i % 5000 != 0) continue;
            System.out.println(i + "\t" + _ma.sumOfPairsScore(msa.toMultiAlignmentObject()) + "\t" + sampler.relativeLogLikelihood + "\t" + sampler.hasEdgeStats.getMean() + "\t" + sampler.invalidAddStats.getMean() + "\t" + sampler.splitRatioStats.getMean() + "\t" + sampler.mergeRatioStats.getMean());
            System.out.println(msa + "\n");
        }
    }
}

