/*
 * Decompiled with CFR 0.152.
 */
package ma;

import java.io.File;
import java.io.IOException;
import ma.MultiAlignment;
import nuts.io.IO;

public class RunWei {
    public static void main(String[] args) throws Exception {
        RunWei.createWeighborTrees(args);
    }

    private static void createWeighborTrees(String[] args) throws IOException {
        if (args.length > 1) {
            System.err.println("1 opt arg: path to dart folder");
            return;
        }
        String dartPath = args.length == 1 ? args[0] : "/home/eecs/bouchard/goblin/others/dart/";
        for (String file : IO.ls(".", "msf")) {
            try {
                System.out.println("Processing " + file);
                MultiAlignment ma = MultiAlignment.parseMSFToMultiAlignment(file);
                String fasta = MultiAlignment.toFASTA(ma);
                File tempFile = new File("temp");
                tempFile.deleteOnExit();
                IO.writeToDisk(tempFile, fasta);
                int length = ma.getSequences().values().iterator().next().length();
                String weightMtx = IO.call(dartPath + "/bin/tkfdistance " + tempFile.getPath());
                System.out.println(weightMtx);
                String cmd = dartPath + "/bin/weighbor -v -L " + length;
                String result = IO.call(cmd, weightMtx);
                String outFile = file.replace("msf", "weitree");
                IO.writeToDisk(outFile, result);
            }
            catch (Exception e) {
                System.err.println("Problem with " + file + "..skipped");
            }
        }
    }
}

