/*
 * Decompiled with CFR 0.152.
 */
package nuts.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import nuts.io.IteratorWrapper;

public class BufferedReaderIterator
implements Iterator<String> {
    private BufferedReader reader = null;
    private String currentLine = null;
    boolean closed = false;

    public BufferedReaderIterator(BufferedReader r) {
        this.reader = r;
    }

    @Override
    public boolean hasNext() {
        if (this.currentLine != null) {
            return true;
        }
        if (this.closed) {
            return false;
        }
        try {
            this.currentLine = this.reader.readLine();
            if (this.currentLine == null) {
                this.reader.close();
                this.closed = true;
            }
            return this.currentLine != null;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException("Error while reading file.");
        }
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String result = this.currentLine;
        this.currentLine = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static Iterable<String> iterate(BufferedReader r) {
        return IteratorWrapper.IW(new BufferedReaderIterator(r));
    }
}

