/*
 * Decompiled with CFR 0.152.
 */
package nuts.math;

import fig.basic.UnorderedPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import nuts.math.Graph;
import nuts.math.HashGraph;
import nuts.math.SemiGraph;
import nuts.util.CollUtils;
import nuts.util.MathUtils;
import nuts.util.Tree;

public class Graphs {
    public static <V> V aVertex(Graph<V> g) {
        return g.vertexSet().iterator().next();
    }

    public static <V> boolean safeHasEdge(Graph<V> g, V n1, V n2) {
        Set<V> vertexSet = g.vertexSet();
        if (!vertexSet.contains(n1) || !vertexSet.contains(n2)) {
            return false;
        }
        return g.hasEdge(n1, n2);
    }

    public static <V> String toString(Graph<V> g) {
        StringBuilder result = new StringBuilder();
        result.append("Vertices: " + g.vertexSet() + "\n");
        result.append("Nbrs:\n");
        for (V v : g.vertexSet()) {
            result.append("\t" + v + ": " + g.nbrs(v) + "\n");
        }
        return result.toString();
    }

    public static <V> boolean equals(Graph<V> g1, Graph<V> g2) {
        if (g1 == g2) {
            return true;
        }
        if (!g1.vertexSet().equals(g2.vertexSet())) {
            return false;
        }
        return Graphs.edgeSet(g1).equals(Graphs.edgeSet(g2));
    }

    public static <V> Graph<V> union(Graph<V> ... graphs) {
        return new UnionGraph<V>(Arrays.asList(graphs));
    }

    public static <V> Graph<V> union2(Graph<V> ... graphs) {
        return new UnionGraph<V>(true, Arrays.asList(graphs));
    }

    public static <V> Set<V> connectedComponentsReps(Graph<V> g) {
        Set<Set<V>> ccs = Graphs.connectedComponents(g);
        HashSet<V> result = new HashSet<V>();
        for (Set<V> cc : ccs) {
            result.add(cc.iterator().next());
        }
        return result;
    }

    public static <V> Graph<V> removeSingletons(final Graph<V> g, UniqueNodesSupplier<V> supply) {
        Set<Set<V>> ccs = Graphs.connectedComponents(g);
        HashMap<V, V> singletonReps2Dummy = new HashMap<V, V>();
        final HashMap<V, V> dummy2SingletonReps = new HashMap<V, V>();
        for (Set<V> cc : ccs) {
            if (cc.size() != 1) continue;
            V dummy = supply.next();
            V rep = cc.iterator().next();
            singletonReps2Dummy.put(rep, dummy);
            dummy2SingletonReps.put(dummy, rep);
        }
        return new HashGraph(new SemiGraph<V>(){

            @Override
            public boolean hasSemiEdge(V one, V two) {
                if (dummy2SingletonReps.keySet().contains(one)) {
                    return dummy2SingletonReps.get(one).equals(two);
                }
                if (dummy2SingletonReps.keySet().contains(two)) {
                    return dummy2SingletonReps.get(two).equals(one);
                }
                return g.hasEdge(one, two);
            }

            @Override
            public Set<V> vertexSet() {
                HashSet result = new HashSet(g.vertexSet());
                result.addAll(dummy2SingletonReps.keySet());
                return result;
            }
        });
    }

    public static Graph<Integer> random(Random rand, int n, double p) {
        HashSet edges = new HashSet();
        for (int v = 0; v < n; ++v) {
            for (int w = v + 1; w < n; ++w) {
                if (!(rand.nextDouble() < p)) continue;
                edges.add(new UnorderedPair<Integer, Integer>(v, w));
            }
        }
        return new HashGraph<Integer>(new HashSet<Integer>(MathUtils.listOfNumbers(n)), edges);
    }

    public static <V> boolean treeHasUniqueNodes(Tree<V> tree) {
        HashSet<V> set = new HashSet<V>();
        for (Tree<V> subt : tree.getPostOrderTraversal()) {
            V cur = subt.getLabel();
            if (set.contains(cur)) {
                return false;
            }
            set.add(cur);
        }
        assert (set.size() == tree.getPostOrderTraversal().size());
        return true;
    }

    public static <V> void test(Graph<V> g) {
        HashSet<V> nodes = new HashSet<V>(g.vertexSet());
        for (Object node : nodes) {
            Set<V> nbhrs = g.nbrs(node);
            for (V n : nbhrs) {
                if (nodes.contains(n)) continue;
                throw new RuntimeException();
            }
            for (Object node2 : nodes) {
                if (nbhrs.contains(node2) == g.hasEdge(node, node2) && g.hasEdge(node2, node) == g.hasEdge(node, node2)) continue;
                System.out.println("nbrs():" + g.nbrs(node).contains(node2));
                System.out.println("hasEdge():" + g.hasEdge(node, node2));
                System.out.println("hasEdge2():" + g.hasEdge(node2, node));
                throw new RuntimeException();
            }
        }
    }

    public static <V> Set<UnorderedPair<V, V>> edgeSet(Graph<V> g) {
        HashSet<UnorderedPair<V, V>> result = new HashSet<UnorderedPair<V, V>>();
        for (V v1 : g.vertexSet()) {
            for (V v2 : g.nbrs(v1)) {
                result.add(new UnorderedPair<V, V>(v1, v2));
            }
        }
        return result;
    }

    public static Graph<Integer> snake(int L) {
        final Grid baseGrid = Graphs.boundedGrid(2, L);
        return new Graph<Integer>(){

            @Override
            public boolean hasEdge(Integer node1, Integer node2) {
                int[] coord1 = baseGrid.int2coord(node1);
                int[] coord2 = baseGrid.int2coord(node2);
                if (!baseGrid.hasEdge(node1, node2)) {
                    return false;
                }
                if (coord1[1] == coord2[1]) {
                    return true;
                }
                double minY = Math.min(coord1[1], coord2[1]);
                if (coord1[0] == 0 && minY % 2.0 == 1.0) {
                    return true;
                }
                return coord1[0] == baseGrid.L - 1 && minY % 2.0 == 0.0;
            }

            @Override
            public Set<Integer> nbrs(Integer node) {
                HashSet<Integer> result = new HashSet<Integer>();
                for (Integer n : baseGrid.nbrs(node)) {
                    if (!this.hasEdge(node, n)) continue;
                    result.add(n);
                }
                return result;
            }

            @Override
            public Set<Integer> vertexSet() {
                return baseGrid.vertexSet();
            }
        };
    }

    public static Graph<Integer> discon(final int n) {
        return new Graph<Integer>(){
            private final Set<Integer> vertices = this.cache();

            @Override
            public boolean hasEdge(Integer node1, Integer node2) {
                return false;
            }

            private Set<Integer> cache() {
                HashSet<Integer> result = new HashSet<Integer>();
                for (int i = 0; i < n; ++i) {
                    result.add(i);
                }
                return result;
            }

            @Override
            public Set<Integer> nbrs(Integer node) {
                return Collections.emptySet();
            }

            @Override
            public Set<Integer> vertexSet() {
                return Collections.unmodifiableSet(this.vertices);
            }
        };
    }

    public static Grid boundedGrid(int D2, int L) {
        return new Grid(D2, L, false);
    }

    public static Grid toroidalGrid(int D2, int L) {
        return new Grid(D2, L, true);
    }

    public static Graph<Integer> chainGraph(int size) {
        return Graphs.boundedGrid(1, size);
    }

    public static <V> boolean isTree(Graph<V> g) {
        if (!Graphs.isConnected(g)) {
            return false;
        }
        return Graphs._isTree(g, Graphs.aVertex(g));
    }

    public static <V> boolean isForest(Graph<V> g) {
        for (V ccRep : Graphs.connectedComponentsReps(g)) {
            if (Graphs._isTree(g, ccRep)) continue;
            return false;
        }
        return true;
    }

    public static <V> boolean _isTree(Graph<V> g, V root) {
        IsTreeProcessor gp = new IsTreeProcessor();
        gp.g = g;
        Graphs.dfs(g, root, gp);
        return gp.isTree;
    }

    public static <V> Tree<V> toTree(Graph<V> g) {
        return Graphs.toTree(g, null);
    }

    public static <V> Tree<V> efficientToTree(Graph<V> g, V root, V parent, Set<V> processed) {
        processed.add(root);
        ArrayList children = CollUtils.list();
        for (V nbh : g.nbrs(root)) {
            if (parent != null && nbh.equals(parent)) continue;
            if (processed.contains(nbh)) {
                throw new RuntimeException();
            }
            children.add(Graphs.efficientToTree(g, nbh, root, processed));
        }
        return new Tree<V>(root, children);
    }

    public static <V> Tree<V> toTree(Graph<V> g, V root) {
        if (root == null) {
            root = Graphs.aVertex(g);
        }
        HashSet set = CollUtils.set();
        return Graphs.efficientToTree(g, root, null, set);
    }

    public static <V> Tree<V> pathInTree(Graph<V> g, V root, V tail) {
        if (!Graphs.isTree(g)) {
            throw new RuntimeException();
        }
        return Graphs._pathInTree(root, null, g, tail);
    }

    public static <V> Map<V, V> parentPtrs(Tree<V> t) {
        HashMap result = new HashMap();
        Graphs._parentPtrs(t, result, null);
        return result;
    }

    public static <V> void _parentPtrs(Tree<V> t, Map<V, V> map, V parent) {
        if (parent != null) {
            map.put(t.getLabel(), parent);
        }
        for (Tree<V> st : t.getChildren()) {
            Graphs._parentPtrs(st, map, t.getLabel());
        }
    }

    private static <V> Tree<V> _pathInTree(V current, V parent, Graph<V> g, V tail) {
        if (current.equals(tail)) {
            return new Tree<V>(tail);
        }
        for (V nbhr : g.nbrs(current)) {
            Tree<V> rec;
            if (nbhr.equals(parent) || (rec = Graphs._pathInTree(nbhr, current, g, tail)) == null) continue;
            Tree<V> result = new Tree<V>(current);
            result.getChildren().add(rec);
            return result;
        }
        return null;
    }

    public static <V> void dfs(Graph<V> g, V root, GraphProcessor<V> p) {
        Graphs.traverse(g, root, p, true);
    }

    public static <V> void bfs(Graph<V> g, V root, GraphProcessor<V> p) {
        Graphs.traverse(g, root, p, false);
    }

    public static <V> boolean isConnected(Graph<V> g) {
        return Graphs.connectedComponents(g).size() == 1;
    }

    public static <V> Set<Set<V>> connectedComponents(Graph<V> g) {
        HashSet<V> allVertices = new HashSet<V>(g.vertexSet());
        HashSet<Set<V>> result = new HashSet<Set<V>>();
        while (!allVertices.isEmpty()) {
            Set<V> currentCC = Graphs.connectedComponent(g, allVertices.iterator().next());
            result.add(currentCC);
            for (V elt : currentCC) {
                allVertices.remove(elt);
            }
        }
        return result;
    }

    public static <V> Set<V> connectedComponent(Graph<V> g, V root) {
        final HashSet cp = new HashSet();
        GraphProcessor ccgp = new GraphProcessor<V>(){

            @Override
            public void process(V vertex, V parent, Set<V> visited) {
                cp.add(vertex);
            }
        };
        Graphs.dfs(g, root, ccgp);
        return cp;
    }

    public static <V> boolean isVeryAcyclic(Graph<V> g, Graph<V> f) {
        if (!g.vertexSet().equals(f.vertexSet())) {
            throw new RuntimeException();
        }
        for (V i : g.vertexSet()) {
            for (V j : g.nbrs(i)) {
                if (Graphs.isForest(new UnionGraph<V>(f, new SingleEdgeGraph<V>(i, j)))) continue;
                return false;
            }
        }
        return true;
    }

    public static String print2DGrid(Graph<Integer> g, int D2, int L) {
        return Graphs.print2DGrid(g, D2, L, null);
    }

    public static String print2DGrid(Graph<Integer> g, int D2, int L, int[] state) {
        if (D2 != 2) {
            throw new RuntimeException();
        }
        StringBuilder result = new StringBuilder();
        for (int y = 0; y < L; ++y) {
            int[] coord;
            int x;
            for (x = 0; x < L; ++x) {
                coord = new int[]{x, y};
                int node = Grid.coord2int(coord, D2, L);
                if (state == null) {
                    result.append("o ");
                } else if (state[node] == 0) {
                    result.append("o ");
                } else if (state[node] == 1) {
                    result.append("x ");
                } else {
                    result.append("? ");
                }
                if (x >= L - 1) continue;
                int[] rc = new int[]{x + 1, y};
                if (g.hasEdge(node, Grid.coord2int(rc, D2, L))) {
                    result.append("- ");
                    continue;
                }
                result.append("  ");
            }
            result.append("\n");
            if (y >= L - 1) continue;
            for (x = 0; x < L; ++x) {
                coord = new int[]{x, y};
                int[] coord2 = new int[]{x, y + 1};
                if (g.hasEdge(Grid.coord2int(coord, D2, L), Grid.coord2int(coord2, D2, L))) {
                    result.append("|   ");
                    continue;
                }
                result.append("    ");
            }
            result.append("\n");
        }
        return result.toString();
    }

    private static <V> void traverse(Graph<V> g, V root, GraphProcessor<V> p, boolean dfs) {
        HashMap parentPts = new HashMap();
        LinkedList<V> list = new LinkedList<V>();
        HashSet visited = new HashSet();
        HashSet<V> fringe = new HashSet<V>();
        list.add(root);
        fringe.add(root);
        while (!list.isEmpty()) {
            Object current = dfs ? list.removeLast() : list.removeFirst();
            fringe.remove(current);
            visited.add(current);
            p.process(current, parentPts.get(current), visited);
            for (V nhbr : g.nbrs(current)) {
                if (visited.contains(nhbr) || fringe.contains(nhbr)) continue;
                list.add(nhbr);
                fringe.add(nhbr);
                parentPts.put(nhbr, current);
            }
        }
    }

    public static Graph<Integer> combDecomposition(int L, int D2) {
        if (D2 > 2 && L % 2 != 0) {
            throw new RuntimeException();
        }
        Grid baseGraph = Graphs.boundedGrid(D2, L);
        Set<Integer> first = Graphs._recCombDecomposition(L, D2);
        HashSet<Integer> second = new HashSet<Integer>();
        Iterator iterator = baseGraph.vertexSet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (first.contains(i)) continue;
            second.add(i);
        }
        return new UnionGraph<Integer>(new SubGraph<Integer>(baseGraph, first), new SubGraph<Integer>(baseGraph, second));
    }

    private static Set<Integer> _recCombDecomposition(int L, int D2) {
        if (L < 3) {
            throw new RuntimeException();
        }
        HashSet<Integer> result = new HashSet<Integer>();
        if (D2 == 1) {
            result.add(0);
            for (int i = 0; i < L - 1; ++i) {
                result.add(i);
            }
            return result;
        }
        Set<Integer> rec = Graphs._recCombDecomposition(L, D2 - 1);
        for (int z = 0; z < L; ++z) {
            for (int c : rec) {
                result.add(Graphs.growCoord(c, D2, L, z));
            }
            if (z % 2 != 0) continue;
            int corner1 = Graphs.corner(L, D2, z, true);
            int corner2 = Graphs.corner(L, D2, z, false);
            int c = 0;
            while ((double)c < Math.pow(L, D2 - 1)) {
                int emb = Graphs.growCoord(c, D2, L, z);
                if (emb != corner1 && emb != corner2) {
                    Graphs.flip(result, emb);
                }
                ++c;
            }
        }
        return result;
    }

    public static <T> void flip(Set<T> set, T elt) {
        if (set.contains(elt)) {
            set.remove(elt);
        } else {
            set.add(elt);
        }
    }

    private static int corner(int L, int D2, int z, boolean isMin) {
        int[] coord = new int[D2];
        for (int i = 0; i < D2 - 1; ++i) {
            coord[i] = isMin ? 0 : L - 1;
        }
        coord[D2 - 1] = z;
        return Grid.coord2int(coord, D2, L);
    }

    private static int growCoord(int c, int D2, int L, int z) {
        int[] coord = Grid.int2coord(c, D2 - 1, L);
        int[] coord2 = new int[coord.length + 1];
        for (int i = 0; i < coord.length; ++i) {
            coord2[i] = coord[i];
        }
        coord2[coord.length] = z;
        return Grid.coord2int(coord2, D2, L);
    }

    public static class Grid
    implements Graph<Integer> {
        public final int D;
        public final int size;
        public final int L;
        private final boolean isToroid;
        private final Set<Integer> vertices = new HashSet<Integer>();

        private Grid(int D2, int L, boolean isToroid) {
            this.D = D2;
            this.L = L;
            this.isToroid = isToroid;
            this.size = (int)Math.pow(L, D2);
            for (int i = 0; i < this.size; ++i) {
                this.vertices.add(i);
            }
        }

        public Graph<Integer> combDecomposition() {
            return Graphs.combDecomposition(this.L, this.D);
        }

        public int corner(boolean isMin) {
            if (this.isToroid) {
                throw new RuntimeException();
            }
            int[] coord = new int[this.D];
            for (int d = 0; d < this.D; ++d) {
                coord[d] = isMin ? 0 : this.L - 1;
            }
            return this.coord2int(coord);
        }

        public int nVars() {
            return this.size;
        }

        public int[] int2coord(int node) {
            return Grid.int2coord(node, this.D, this.L);
        }

        public static int[] int2coord(int node, int D2, int L) {
            int[] result = new int[D2];
            for (int d = 0; d < D2; ++d) {
                result[d] = node % L;
                node /= L;
            }
            return result;
        }

        public int coord2int(int[] coord) {
            return Grid.coord2int(coord, this.D, this.L);
        }

        public static int coord2int(int[] coord, int D2, int L) {
            int result = 0;
            int cPow = 1;
            for (int d = 0; d < D2; ++d) {
                result += cPow * coord[d];
                cPow *= L;
            }
            return result;
        }

        @Override
        public boolean hasEdge(Integer node1, Integer node2) {
            int[] coord1 = this.int2coord(node1);
            int[] coord2 = this.int2coord(node2);
            int nDiff = 0;
            for (int d = 0; d < this.D; ++d) {
                int c1 = Math.min(coord1[d], coord2[d]);
                int c2 = Math.max(coord1[d], coord2[d]);
                if (c2 - c1 == 1) {
                    ++nDiff;
                    continue;
                }
                if (this.isToroid && c1 == 0 && c2 == this.L - 1) {
                    ++nDiff;
                    continue;
                }
                if (c2 - c1 <= 1) continue;
                return false;
            }
            return nDiff == 1;
        }

        @Override
        public Set<Integer> nbrs(Integer node) {
            int[] coord = this.int2coord(node);
            HashSet<Integer> result = new HashSet<Integer>();
            for (int d = 0; d < this.D; ++d) {
                if (this.isToroid || coord[d] < this.L - 1) {
                    this.incrementAxis(coord, d, 1);
                    result.add(this.coord2int(coord));
                    this.incrementAxis(coord, d, -1);
                }
                if (!this.isToroid && coord[d] <= 0) continue;
                this.incrementAxis(coord, d, -1);
                result.add(this.coord2int(coord));
                this.incrementAxis(coord, d, 1);
            }
            return result;
        }

        public void incrementAxis(int[] coord, int d, int increment) {
            while (increment < 0) {
                increment += this.L;
            }
            coord[d] = (coord[d] + (increment %= this.L)) % this.L;
        }

        @Override
        public Set<Integer> vertexSet() {
            return Collections.unmodifiableSet(this.vertices);
        }

        public static void main(String[] args) {
            Random rand = new Random();
            System.out.println("Grid:");
            System.out.println(Graphs.print2DGrid(Graphs.boundedGrid(2, 5), 2, 5));
            Graphs.test(Graphs.snake(5));
            Graphs.test(Graphs.boundedGrid(3, 3));
            Graphs.test(Graphs.chainGraph(10));
            Graphs.test(Graphs.combDecomposition(4, 3));
            Graphs.test(Graphs.discon(10));
            Graphs.test(Graphs.toroidalGrid(2, 3));
            System.out.println("Graphs OK");
            int D2 = 3;
            int L = 4;
            Graph<Integer> decomp2 = Graphs.combDecomposition(4, 3);
            System.out.println("CCs:" + Graphs.connectedComponents(decomp2));
            System.out.println("Snake:");
            System.out.println(Graphs.print2DGrid(Graphs.snake(5), 2, 5));
            System.out.println(Graphs.print2DGrid(Graphs.chainGraph(5), 2, 5));
            for (int i = 0; i < 3; ++i) {
                System.out.println(Graphs.print2DGrid(new SlicedGrid(decomp2, 3, 4, 2, i), 2, 4));
            }
        }

        private static Set<Integer> _slice(Grid g, int d, int z) {
            HashSet<Integer> result = new HashSet<Integer>();
            for (int c = 0; c < g.vertexSet().size(); ++c) {
                int[] coord = g.int2coord(c);
                if (coord[d] != z) continue;
                int[] sliced = new int[g.D - 1];
                int i = 0;
                for (int d2 = 0; d2 < g.D; ++d2) {
                    if (d2 == d) continue;
                    sliced[i] = coord[d2];
                    ++i;
                }
                result.add(Grid.coord2int(sliced, g.D - 1, g.L));
            }
            return result;
        }

        public static class SlicedGrid
        implements Graph<Integer> {
            private final Graph<Integer> g;
            private final int D;
            private final int L;
            private final int d;
            private final int z;

            public SlicedGrid(Graph<Integer> g, int D2, int L, int d, int z) {
                this.g = g;
                this.D = D2;
                this.L = L;
                this.d = d;
                this.z = z;
            }

            @Override
            public boolean hasEdge(Integer node1, Integer node2) {
                return this.g.hasEdge(this.embed(node1), this.embed(node2));
            }

            public int embed(int inSubspace) {
                int[] ori = Grid.int2coord(inSubspace, this.D, this.L);
                int[] result = new int[this.D + 1];
                int i = 0;
                for (int d2 = 0; d2 < this.D + 1; ++d2) {
                    if (d2 != this.d) {
                        result[d2] = ori[i];
                        ++i;
                        continue;
                    }
                    result[d2] = this.z;
                }
                return Grid.coord2int(result, this.D + 1, this.L);
            }

            public Integer project(int inBigSpace) {
                int[] ori = Grid.int2coord(inBigSpace, this.D + 1, this.L);
                if (ori[this.d] != this.z) {
                    return null;
                }
                int[] result = new int[this.D];
                int i = 0;
                for (int d2 = 0; d2 < this.D; ++d2) {
                    if (d2 == this.d) continue;
                    result[i] = ori[d2];
                    ++i;
                }
                return Grid.coord2int(result, this.D, this.L);
            }

            @Override
            public Set<Integer> nbrs(Integer node) {
                HashSet<Integer> result = new HashSet<Integer>();
                for (int inBigSpace : this.g.nbrs(node)) {
                    Integer cur = this.project(inBigSpace);
                    if (cur == null) continue;
                    result.add(cur);
                }
                return result;
            }

            public int size() {
                return (int)Math.pow(this.L, this.D);
            }

            @Override
            public Set<Integer> vertexSet() {
                throw new RuntimeException();
            }
        }
    }

    public static final class ChainDecomp
    implements Graph<Integer> {
        private final Grid baseGrid;

        public ChainDecomp(Grid grid) {
            this.baseGrid = grid;
        }

        @Override
        public boolean hasEdge(Integer node1, Integer node2) {
            if (!this.baseGrid.hasEdge(node1, node2)) {
                return false;
            }
            int[] coord1 = this.baseGrid.int2coord(node1);
            int[] coord2 = this.baseGrid.int2coord(node2);
            for (int d = 1; d < this.baseGrid.D; ++d) {
                if (coord1[d] == coord2[d]) continue;
                return false;
            }
            return true;
        }

        @Override
        public Set<Integer> nbrs(Integer node) {
            HashSet<Integer> result = new HashSet<Integer>();
            for (int cur : this.baseGrid.nbrs(node)) {
                if (!this.hasEdge(node, cur)) continue;
                result.add(cur);
            }
            return result;
        }

        @Override
        public Set<Integer> vertexSet() {
            return this.baseGrid.vertexSet();
        }

        public List<Integer> ccRoots() {
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (Integer cur : this.vertexSet()) {
                if (this.baseGrid.int2coord(cur)[0] != 0) continue;
                result.add(cur);
            }
            return result;
        }
    }

    public static interface GraphProcessor<V> {
        public void process(V var1, V var2, Set<V> var3);
    }

    public static class SubGraph<V>
    implements Graph<V> {
        private final Graph<V> graph;
        private final Set<V> vertices;

        public SubGraph(Graph<V> base, Set<V> vertices) {
            this.graph = base;
            this.vertices = vertices;
            for (V v : vertices) {
                if (base.vertexSet().contains(v)) continue;
                throw new RuntimeException();
            }
        }

        @Override
        public boolean hasEdge(V node1, V node2) {
            if (!this.graph.hasEdge(node1, node2)) {
                return false;
            }
            return this.vertices.contains(node1) && this.vertices.contains(node2);
        }

        @Override
        public Set<V> nbrs(V node) {
            HashSet<V> result = new HashSet<V>();
            if (this.vertices.contains(node)) {
                for (V c : this.graph.nbrs(node)) {
                    if (!this.vertices.contains(c)) continue;
                    result.add(c);
                }
            }
            return result;
        }

        @Override
        public Set<V> vertexSet() {
            return Collections.unmodifiableSet(this.vertices);
        }
    }

    public static class SingleEdgeGraph<V>
    implements Graph<V> {
        private final V v1;
        private final V v2;

        public SingleEdgeGraph(V v1, V v2) {
            this.v1 = v1;
            this.v2 = v2;
        }

        @Override
        public boolean hasEdge(V node1, V node2) {
            if (node1 == this.v1 && node2 == this.v2) {
                return true;
            }
            return node1 == this.v2 && node2 == this.v1;
        }

        @Override
        public Set<V> nbrs(V node) {
            if (node == this.v1) {
                return Collections.singleton(this.v2);
            }
            if (node == this.v2) {
                return Collections.singleton(this.v1);
            }
            return Collections.emptySet();
        }

        @Override
        public Set<V> vertexSet() {
            HashSet<V> result = new HashSet<V>();
            result.add(this.v1);
            result.add(this.v2);
            return result;
        }
    }

    public static class UnionGraph<V>
    implements Graph<V> {
        private final List<Graph<V>> graphs = new ArrayList<Graph<V>>();
        private final boolean unionOfVerticesAsWell;

        public UnionGraph(Graph<V> g1, Graph<V> g2) {
            this(false, g1, g2);
        }

        public UnionGraph(Collection<? extends Graph<V>> graphs) {
            this(false, graphs);
        }

        public UnionGraph(boolean unionOfVerticesAsWell, Graph<V> g1, Graph<V> g2) {
            this.graphs.add(g1);
            this.graphs.add(g2);
            this.unionOfVerticesAsWell = unionOfVerticesAsWell;
        }

        public UnionGraph(boolean unionOfVerticesAsWell, Collection<? extends Graph<V>> graphs) {
            this.unionOfVerticesAsWell = unionOfVerticesAsWell;
            this.graphs.addAll(graphs);
        }

        @Override
        public boolean hasEdge(V node1, V node2) {
            for (Graph<V> g : this.graphs) {
                if (!(this.unionOfVerticesAsWell ? Graphs.safeHasEdge(g, node1, node2) : g.hasEdge(node1, node2))) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set<V> nbrs(V node) {
            HashSet<V> nbrs = new HashSet<V>();
            for (Graph<V> g : this.graphs) {
                if (this.unionOfVerticesAsWell && !g.vertexSet().contains(node)) continue;
                nbrs.addAll(g.nbrs(node));
            }
            return nbrs;
        }

        @Override
        public Set<V> vertexSet() {
            HashSet<V> result = new HashSet<V>();
            for (Graph<V> g : this.graphs) {
                result.addAll(g.vertexSet());
            }
            return result;
        }
    }

    public static class IsTreeProcessor<V>
    implements GraphProcessor<V> {
        public boolean isTree = true;
        public Graph<V> g;

        @Override
        public void process(V vertex, V parent, Set<V> visited) {
            int nVisited = 0;
            for (V n : this.g.nbrs(vertex)) {
                if (!visited.contains(n)) continue;
                ++nVisited;
            }
            if (nVisited > 1) {
                this.isTree = false;
            }
        }
    }

    public static interface UniqueNodesSupplier<V> {
        public V next();
    }
}

