/*
 * Decompiled with CFR 0.152.
 */
package nuts.maxent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SparseVector {
    public int[] indices;
    public double[] values;

    public SparseVector(int dim) {
        this.indices = new int[0];
        this.values = new double[0];
    }

    @Deprecated
    public SparseVector(List<Integer> inIndices, List<Double> inValues, int dim) {
        this(inIndices, inValues);
    }

    public SparseVector(List<Integer> inIndices, List<Double> inValues) {
        assert (inIndices.size() == inValues.size());
        int size = inIndices.size();
        this.indices = new int[size];
        this.values = new double[size];
        for (int i = 0; i < size; ++i) {
            this.indices[i] = inIndices.get(i);
            this.values[i] = inValues.get(i);
        }
    }

    public SparseVector(int[] indices, double[] values) {
        if (indices.length != values.length) {
            throw new RuntimeException();
        }
        this.indices = indices;
        this.values = values;
    }

    public SparseVector(double[] vector) {
        ArrayList<Integer> indicesList = new ArrayList<Integer>();
        ArrayList<Double> valuesList = new ArrayList<Double>();
        for (int i = 0; i < vector.length; ++i) {
            if (vector[i] == 0.0) continue;
            indicesList.add(i);
            valuesList.add(vector[i]);
        }
        this.indices = new int[valuesList.size()];
        this.values = new double[valuesList.size()];
        for (int j = 0; j < valuesList.size(); ++j) {
            this.indices[j] = (Integer)indicesList.get(j);
            this.values[j] = (Double)valuesList.get(j);
        }
    }

    public SparseVector(HashMap<Integer, Double> map, int dim) {
        ArrayList<Integer> indicesList = new ArrayList<Integer>();
        ArrayList<Double> valuesList = new ArrayList<Double>();
        for (Integer key : map.keySet()) {
            Double value = map.get(key);
            indicesList.add(key);
            valuesList.add(value);
        }
        this.indices = new int[valuesList.size()];
        this.values = new double[valuesList.size()];
        for (int j = 0; j < valuesList.size(); ++j) {
            this.indices[j] = (Integer)indicesList.get(j);
            this.values[j] = (Double)valuesList.get(j);
        }
    }

    public void linearIncrement(double coef, double[] vector) {
        for (int i = 0; i < this.nEntries(); ++i) {
            int index = this.indices[i];
            double value = this.values[i];
            vector[index] = vector[index] + coef * value;
        }
    }

    public double dotProduct(double[] vector) {
        double result = 0.0;
        for (int i = 0; i < this.nEntries(); ++i) {
            int index = this.indices[i];
            double value = this.values[i];
            result += value * vector[index];
        }
        return result;
    }

    public double[] scale(double factor) {
        double[] result = new double[this.nEntries()];
        for (int i = 0; i < this.nEntries(); ++i) {
            double value = this.values[i];
            result[i] = value * factor;
        }
        return result;
    }

    private int nEntries() {
        return this.indices.length;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int i = 0; i < this.nEntries(); ++i) {
            builder.append(this.indices[i] + ":" + this.values[i]);
            if (i == this.nEntries() - 1) continue;
            builder.append(" ");
        }
        builder.append("]");
        return builder.toString();
    }
}

