/*
 * Decompiled with CFR 0.152.
 */
package sage;

import fig.basic.Pair;
import goblin.CognateId;
import goblin.CognateSet;
import goblin.DataPrepUtils;
import goblin.HLFeatureExtractor;
import goblin.Taxon;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import nuts.io.Extensions;
import nuts.io.IO;
import nuts.lang.StringUtils;
import nuts.math.Graphs;
import nuts.util.Counter;
import nuts.util.Indexer;
import nuts.util.Tree;
import pepper.Encodings;

public class FLoad {
    private static Counter<Double> histogramSum = new Counter();
    private static Counter<Double> histogramN = new Counter();
    private static Indexer<Character> indexer;

    private static void flushAndPrintStats() {
        for (Double key : histogramN) {
            System.out.println(key + "\t" + histogramSum.getCount(key) / histogramN.getCount(key));
        }
        histogramN = new Counter();
        histogramSum = new Counter();
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        Taxon topL;
        Encodings.ipaConsonantsFile = "/Users/bouchard/Documents/workspace/pepper/encodings/converted-cons.ipa";
        Encodings.consonantIndices = new ArrayList<Integer>(Arrays.asList(1, 2, 3, 4, 5, 6));
        Encodings.ipaVowelsFile = "/Users/bouchard/Documents/workspace/pepper/encodings/converted-vow.ipa";
        Encodings.vowelsIndices = new ArrayList<Integer>(Arrays.asList(1, 2, 3, 4));
        Encodings enc = Encodings.realEncoding();
        if (args.length != 3) {
            System.err.println("Fload <topo> <iter> <nFeaturesDelta>");
            return;
        }
        int nFeaturesDelta = Integer.parseInt(args[2]);
        String topoPath = args[0];
        String iter = Extensions.extension2String(Integer.parseInt(args[1]));
        File contextEditsFile = new File("./iteration" + iter + ".contextEdits");
        File cognateSetFile = new File("./snapshot" + iter + ".CognateSet");
        List<String> contextEdits = IO.f2l(contextEditsFile);
        CognateSet cs = CognateSet.restoreCognateSet(cognateSetFile);
        Tree<String> topo = DataPrepUtils.lisp2tree(IO.f2s(topoPath));
        Set<Character> allPhonemes = FLoad.allPhonemes(cs);
        FLoad.index(allPhonemes);
        System.out.println("Frequency vs. change pr:");
        for (Tree<String> subt : topo.getPreOrderTraversal()) {
            for (Character topP : allPhonemes) {
                topL = new Taxon(subt.getLabel());
                double topPFreqRatio = FLoad.freq(topP.charValue(), cs, topL);
                for (Tree<String> child : subt.getChildren()) {
                    Taxon botL = new Taxon(child.getLabel());
                    double count = FLoad.count(topP.charValue(), cs, topL, botL);
                    if (count == 0.0) continue;
                    double changePr = FLoad.expectedChangeCount(contextEdits, botL, topP) / count;
                    FLoad.addPoint(topPFreqRatio, changePr);
                }
            }
        }
        System.out.println("Histogram:");
        FLoad.flushAndPrintStats();
        System.out.println("----");
        for (Tree<String> subt : topo.getPreOrderTraversal()) {
            for (char topP : allPhonemes) {
                topL = new Taxon(subt.getLabel());
                double[][] ctxtMtx = FLoad.ctxtMtx(cs, topL);
                double nPTokens = FLoad.nPhoneToken(cs, topL);
                for (char botP : allPhonemes) {
                    List<String> diffFeatures;
                    if (botP == topP || (diffFeatures = HLFeatureExtractor.modifiedFeatures(enc.char2PhoneId(topP), enc.char2PhoneId(botP), enc)) == null || diffFeatures.size() > nFeaturesDelta) continue;
                    double fload = FLoad.fload(ctxtMtx, nPTokens, topP, botP);
                    for (Tree<String> child : subt.getChildren()) {
                        Taxon botL = new Taxon(child.getLabel());
                        double count = FLoad.count(topP, cs, topL, botL);
                        if (count == 0.0) continue;
                        double changePr = FLoad.expectedChangeCount(contextEdits, botL, Character.valueOf(topP), Character.valueOf(botP)) / count;
                        FLoad.addPoint(fload, changePr);
                    }
                }
            }
        }
    }

    public static void index(Set<Character> allPhonemes) {
        Indexer<Character> result = new Indexer<Character>();
        result.addAllToIndex(allPhonemes);
        result.addToIndex(Character.valueOf('#'));
        indexer = result;
    }

    public static int nCtxts() {
        return indexer.size() * indexer.size();
    }

    private static double nPhoneToken(CognateSet cs, Taxon topL) {
        int result = 0;
        for (String w : cs.allWords(topL)) {
            result += w.length();
        }
        return result;
    }

    private static double[][] ctxtMtx(CognateSet cs, Taxon topL) {
        return FLoad.ctxtMtx(cs.allWords(topL));
    }

    private static double[][] ctxtMtx(List<String> allWord) {
        double[][] result = new double[indexer.size() * indexer.size()][indexer.size()];
        for (String word : allWord) {
            for (int pos = 0; pos < word.length(); ++pos) {
                double[] dArray = result[FLoad.wordPos2ctxt(word, pos)];
                int n = indexer.o2i(Character.valueOf(word.charAt(pos)));
                dArray[n] = dArray[n] + 1.0;
            }
        }
        return result;
    }

    private static int wordPos2ctxt(String word, int pos) {
        return FLoad.phones2ctxt(StringUtils.charAt(word, pos - 1), StringUtils.charAt(word, pos + 1));
    }

    public static int phones2ctxt(char _left, char _right) {
        int leftIndex = indexer.o2i(Character.valueOf(_left));
        int rightIndex = indexer.o2i(Character.valueOf(_right));
        int[] coord = new int[]{leftIndex, rightIndex};
        return Graphs.Grid.coord2int(coord, 2, indexer.size());
    }

    public static Pair<Character, Character> ctxt2Phones(int ctxt) {
        int[] coord = Graphs.Grid.int2coord(ctxt, 2, indexer.size());
        char leftChar = indexer.i2o(coord[0]).charValue();
        char rightChar = indexer.i2o(coord[1]).charValue();
        return Pair.makePair(Character.valueOf(leftChar), Character.valueOf(rightChar));
    }

    private static double fload(double[][] ctxtsCounts, double nPhoneTokens, char _p1, char _p2) {
        double sum = 0.0;
        int phone1Index = indexer.o2i(Character.valueOf(_p1));
        int phone2Index = indexer.o2i(Character.valueOf(_p2));
        for (int k = 0; k < ctxtsCounts.length; ++k) {
            sum += ctxtsCounts[k][phone1Index] * ctxtsCounts[k][phone2Index];
        }
        return sum / nPhoneTokens / nPhoneTokens;
    }

    private static double expectedChangeCount(List<String> contextEdits, Taxon botL, Character topP, Character botM) {
        return FLoad.expectedChangeCount(contextEdits, Pattern.compile("" + topP + " -> " + botM + " /.*@" + botL.toString() + "\\t(.*$)"));
    }

    private static double expectedChangeCount(List<String> contextEdits, Taxon botL, Character topP) {
        return FLoad.expectedChangeCount(contextEdits, Pattern.compile("" + topP + " -> .*@" + botL.toString() + "\\t(.*)$"));
    }

    private static double expectedChangeCount(List<String> contextEdits, Pattern p) {
        String prStr = null;
        double expectedCount = 0.0;
        for (String edit : contextEdits) {
            prStr = StringUtils.selectFirstRegex(p, edit);
            if (prStr == null) continue;
            expectedCount += Double.parseDouble(prStr);
        }
        return expectedCount;
    }

    private static double count(char topP, CognateSet cs, Taxon topL, Taxon botL) {
        double num = 0.0;
        for (CognateId id : cs.getCognateIds()) {
            if (!cs.hasWord(id, topL) || !cs.hasWord(id, botL)) continue;
            String cWord = cs.getWord(id, topL);
            for (char cPhone : cWord.toCharArray()) {
                if (topP != cPhone) continue;
                num += 1.0;
            }
        }
        return num;
    }

    private static double freq(char topP, CognateSet cs, Taxon topL) {
        double num = 0.0;
        double denom = 0.0;
        for (String cWord : cs.allWords(topL)) {
            denom += (double)cWord.length();
            for (char cPhone : cWord.toCharArray()) {
                if (topP != cPhone) continue;
                num += 1.0;
            }
        }
        return num / denom;
    }

    private static void addPoint(double x, double y) {
        System.out.println(x + "\t" + y);
        double key = (double)((int)(x * 100.0)) / 100.0;
        histogramN.incrementCount(key, 1.0);
        histogramSum.incrementCount(key, y);
    }

    private static Set<Character> allPhonemes(CognateSet cs) {
        HashSet<Character> result = new HashSet<Character>();
        for (String word : cs.allWords()) {
            for (char c : word.toCharArray()) {
                result.add(Character.valueOf(c));
            }
        }
        return result;
    }
}

