/*
 * Decompiled with CFR 0.152.
 */
package slice.ndp;

import fig.basic.NumUtils;
import fig.prob.SampleUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import slice.ndp.DistributionToken;
import slice.ndp.NDPLocation;
import slice.stickrep.Location;
import slice.stickrep.LocationDistribution;
import slice.util.TruncUtils;

public class NDPLocationDistribution<L extends Location<D>, D>
implements LocationDistribution<NDPLocation<L, D>, DistributionToken<D>> {
    private final int truncation;
    private final LocationDistribution<L, D> subLocationDistribution;
    private final double subAlpha0;

    public NDPLocationDistribution(int truncation, LocationDistribution<L, D> subLocationDistribution, double subAlpha0) {
        this.truncation = truncation;
        this.subLocationDistribution = subLocationDistribution;
        this.subAlpha0 = subAlpha0;
    }

    @Override
    public LocationDistribution<NDPLocation<L, D>, DistributionToken<D>> posterior(List<DistributionToken<D>> data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NDPLocation<L, D> sample(Random rand) {
        return this.samplePosterior(rand, (List)new ArrayList());
    }

    @Override
    public NDPLocation<L, D> samplePosterior(Random rand, List<DistributionToken<D>> data) {
        int[] n = new int[this.truncation];
        ArrayList<L> subloc = new ArrayList<L>();
        for (int l = 0; l < this.truncation; ++l) {
            ArrayList<D> correspSubData = new ArrayList<D>();
            for (DistributionToken<D> datum : data) {
                Collection<D> membersOfCurrentCluster = datum.membersOfCluster(l);
                correspSubData.addAll(membersOfCurrentCluster);
                n[l] = n[l] + membersOfCurrentCluster.size();
            }
            subloc.add(this.subLocationDistribution.samplePosterior(rand, correspSubData));
        }
        List<Double> subV = TruncUtils.sampleTruncatedWeights(rand, this.subAlpha0, n);
        NDPLocation result = NDPLocation.createNDPLocationFromVs(subloc, subV);
        for (DistributionToken<D> datum : data) {
            for (int i = 0; i < datum.size(); ++i) {
                D point = datum.getPoint(i);
                double[] prs = new double[this.truncation];
                for (int l = 0; l < this.truncation; ++l) {
                    double currentLikelihood = Math.exp(((Location)result.getSubLocations().get(l)).unnormLoglikelihood(point));
                    prs[l] = result.getW().retreiveW(l) * currentLikelihood;
                }
                NumUtils.normalize(prs);
                datum.setIndicators(i, SampleUtils.sampleMultinomial(rand, prs));
            }
        }
        return result;
    }
}

