/*
 * Decompiled with CFR 0.152.
 */
package smc;

import fig.basic.LogInfo;
import fig.basic.Pair;
import graphics.Visualizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import nuts.maxent.SloppyMath;
import nuts.util.CollUtils;
import pty.smc.ParticleFilter;
import pty.smc.ParticleKernel;
import smc.RandomGenerator;
import smc.SMC;

public class DistributedSMC<S> {
    private ParticleOptimizationStyle optimizationStyle;
    private int T;
    private int N = 0;
    private List<Machine> machines;
    private RandomGenerator random;
    private DistributedParticleKernel<S> kernel;
    private ParticleFilter.ParticleProcessor<S> processor;
    private ReconstructionStatistics reconstructionStat = new ReconstructionStatistics();
    public static int TIME = 0;

    public DistributedSMC(int T, int N2, ParticleKernel<S> kernel, int[][] machineConfig, ParticleFilter.ParticleProcessor<S> processor, ParticleOptimizationStyle optStyle) {
        this.T = T;
        this.N = N2;
        this.kernel = new DistributedParticleKernel<S>(kernel);
        this.optimizationStyle = optStyle;
        this.random = new RandomGenerator(T);
        this.machines = new ArrayList<Machine>();
        for (int k = 0; k < machineConfig.length; ++k) {
            Machine m = new Machine(k, N2, machineConfig, this.random);
            this.machines.add(m);
        }
        this.processor = processor;
    }

    public static <S> DistributedSMC<S> runDistributedSMC(int T, int N2, ParticleKernel<S> kernel, int[][] machineConfig, ParticleFilter.ParticleProcessor<S> processor, ParticleOptimizationStyle optimizationStyle) {
        DistributedSMC<S> dSMC = new DistributedSMC<S>(T, N2, kernel, machineConfig, processor, optimizationStyle);
        super.run();
        return dSMC;
    }

    private void run() {
        int k;
        for (k = 0; k < this.machines.size(); ++k) {
            this.machines.get(k).initializeMachine();
        }
        for (int t = 1; t < this.T; ++t) {
            int k2;
            TIME = t;
            for (k2 = 0; k2 < this.machines.size(); ++k2) {
                this.machines.get(k2).resampleAndOptimize(t);
            }
            for (k2 = 0; k2 < this.machines.size(); ++k2) {
                this.machines.get(k2).generateSamples(t);
            }
        }
        for (k = 0; k < this.machines.size(); ++k) {
            this.machines.get(k).process(this.processor);
        }
    }

    public int getNumMachines() {
        return this.machines.size();
    }

    public void printInvertedTreeForMachine(int machineId) {
        ArrayList invertedTree = this.machines.get(machineId).invertTree();
        Visualizer.createImage(this.N, this.T, invertedTree);
    }

    public void printStats() {
        LogInfo.logs("Max=" + this.reconstructionStat.getMax() + " at t=" + this.reconstructionStat.getMaxT());
        LogInfo.logs("Mean=" + this.reconstructionStat.getMean());
        LogInfo.logs("Next=" + this.kernel.getNextCount());
    }

    public int getNexts() {
        return this.kernel.getNextCount();
    }

    public Pair<Double, Double> getStats() {
        return new Pair<Double, Double>(this.reconstructionStat.getMax(), this.reconstructionStat.getMean());
    }

    public class DistributedParticleKernel<S>
    implements ParticleKernel<S> {
        private ParticleKernel<S> kernel;
        private int nextCount;

        public DistributedParticleKernel(ParticleKernel<S> kernel) {
            this.kernel = kernel;
            this.nextCount = 0;
        }

        @Override
        public Pair<S, Double> next(Random rand, S current) {
            ++this.nextCount;
            return this.kernel.next(rand, current);
        }

        @Override
        public int nIterationsLeft(S partialState) {
            return this.kernel.nIterationsLeft(partialState);
        }

        @Override
        public S getInitial() {
            return this.kernel.getInitial();
        }

        public int getNextCount() {
            return this.nextCount;
        }
    }

    public class ReconstructionStatistics {
        List<Integer> generationCounts = CollUtils.list();
        int max = 0;
        int maxT = 0;
        int totalSum = 0;

        public void addStat(int t, int numGenerationsTraced) {
            this.generationCounts.add(numGenerationsTraced);
            this.totalSum += numGenerationsTraced;
            if (numGenerationsTraced > this.max) {
                this.max = numGenerationsTraced;
                this.maxT = t;
            }
        }

        public double getMean() {
            double result = (double)this.totalSum / (double)this.generationCounts.size();
            return result;
        }

        public double getMax() {
            return this.max;
        }

        public int getMaxT() {
            return this.maxT;
        }
    }

    public class Machine {
        int machineId;
        int maxCapacity;
        int[][] machineConfig;
        double[] probs;
        ArrayList<SMC.Particle<S>> leaves;
        RandomGenerator rg;

        public Machine(int id, int N2, int[][] machineConfig, RandomGenerator rg) {
            this.machineId = id;
            this.maxCapacity = machineConfig[id][1];
            this.machineConfig = machineConfig;
            this.rg = rg;
            this.leaves = new ArrayList();
        }

        public ArrayList<SMC.Particle<S>> invertTree() {
            ArrayList particles = (ArrayList)this.leaves.clone();
            for (int t = DistributedSMC.this.T - 1; t >= 1; --t) {
                HashMap mapOfParticles = new HashMap();
                ArrayList tempParticleStorage = new ArrayList();
                for (SMC.Particle particle : particles) {
                    SMC.Particle parent = particle.parent;
                    SMC.Particle newParticle = null;
                    if (mapOfParticles.containsKey(parent.id)) {
                        newParticle = (SMC.Particle)mapOfParticles.get(parent.id);
                    } else {
                        newParticle = new SMC.Particle(parent.id, parent.time, parent.weight, parent.sample, parent.parent);
                        mapOfParticles.put(newParticle.id, newParticle);
                        tempParticleStorage.add(newParticle);
                    }
                    newParticle.addChild(particle);
                }
                particles = tempParticleStorage;
                if (tempParticleStorage.size() == 1) break;
            }
            return particles;
        }

        public void process(ParticleFilter.ParticleProcessor<S> processor) {
            for (SMC.Particle p : this.leaves) {
                if (p.sample == null) continue;
                processor.process(p.sample, p.weight);
            }
        }

        public void resampleAndOptimize(int t) {
            int[] sampled = this.resample(t);
            this.optimize(t, sampled);
        }

        private void generateSampleAndAddLeaves(int t, int mult, SMC.Particle<S> parent, S currentSample, List<SMC.Particle<S>> list) {
            for (int i = 0; i < mult; ++i) {
                long seed = this.rg.getSeed(t, list.size());
                Pair pair = DistributedSMC.this.kernel.next(new Random(seed), currentSample);
                double w = pair.getSecond();
                SMC.Particle p = new SMC.Particle(list.size(), t, this.machineId, w, pair.getFirst(), parent);
                list.add(p);
            }
        }

        public void initializeMachine() {
            for (int k = 0; k < this.machineConfig.length; ++k) {
                for (int j = 0; j < this.machineConfig[k][0]; ++j) {
                    SMC.Particle p = null;
                    long seed = DistributedSMC.this.random.getSeed(0, this.leaves.size());
                    if (k != this.machineId) {
                        p = new SMC.Particle(this.leaves.size(), 0, k, null, seed);
                    } else {
                        Object initialSample = DistributedSMC.this.kernel.getInitial();
                        Pair pair = DistributedSMC.this.kernel.next(new Random(seed), initialSample);
                        double w = pair.getSecond();
                        p = new SMC.Particle(this.leaves.size(), 0, this.machineId, w, pair.getFirst(), null);
                    }
                    this.leaves.add(p);
                }
            }
        }

        public void generateSamples(int t) {
            ArrayList tempList = new ArrayList();
            for (SMC.Particle particle : this.leaves) {
                if (particle.isDead()) {
                    // empty if block
                }
                for (Map.Entry<Integer, Integer> entry : particle.getMachineMap().entrySet()) {
                    int particleDestinationId = entry.getKey();
                    int mult = entry.getValue();
                    if (particleDestinationId == this.machineId) {
                        if (particle.machineId == this.machineId) {
                            if (particle.sample == null) {
                                throw new RuntimeException("Sample is null");
                            }
                            this.generateSampleAndAddLeaves(t, mult, particle, particle.sample, tempList);
                            continue;
                        }
                        Object currentSample = null;
                        Stack seeds = new Stack();
                        SMC.Particle curr = particle;
                        int traceBack = 0;
                        while (curr != null) {
                            if (curr != null && curr.sample != null) {
                                currentSample = curr.sample;
                                break;
                            }
                            seeds.push(curr);
                            curr = curr.parent;
                            ++traceBack;
                        }
                        DistributedSMC.this.reconstructionStat.addStat(t, traceBack);
                        if (currentSample == null) {
                            currentSample = DistributedSMC.this.kernel.getInitial();
                        }
                        while (!seeds.empty()) {
                            SMC.Particle p = (SMC.Particle)seeds.pop();
                            Pair<Object, Double> pair = DistributedSMC.this.kernel.next(new Random(p.seed), currentSample);
                            if (p.sample != null) {
                                throw new RuntimeException("Error in re-constructing samples");
                            }
                            p.sample = pair.getFirst();
                            double w = pair.getSecond();
                            p.setRawWeight(w);
                            currentSample = p.sample;
                        }
                        this.generateSampleAndAddLeaves(t, mult, particle, currentSample, tempList);
                        continue;
                    }
                    if (particleDestinationId == this.machineId) continue;
                    for (int i = 0; i < mult; ++i) {
                        SMC.Particle p = new SMC.Particle(tempList.size(), t, particleDestinationId, particle, this.rg.getSeed(t, tempList.size()));
                        tempList.add(p);
                    }
                    if (particle.machineId == this.machineId) continue;
                }
            }
            this.leaves = tempList;
        }

        public int[] resample(int t) {
            StringBuffer sb = new StringBuffer();
            double[] weights = new double[DistributedSMC.this.N];
            double norm = 0.0;
            int numWeightsReceived = 0;
            for (int k = 0; k < DistributedSMC.this.machines.size(); ++k) {
                Machine m = (Machine)DistributedSMC.this.machines.get(k);
                for (SMC.Particle p : m.leaves) {
                    if (p.sample == null) continue;
                    weights[p.id] = p.getRawWeight();
                    sb.append(weights[p.id] + " ");
                    ++numWeightsReceived;
                }
            }
            norm = SloppyMath.logAdd(weights);
            sb = new StringBuffer();
            for (int n = 0; n < DistributedSMC.this.N; ++n) {
                weights[n] = weights[n] - norm;
                weights[n] = Math.exp(weights[n]);
                sb.append(weights[n] + " ");
            }
            if (numWeightsReceived != DistributedSMC.this.N) {
                throw new RuntimeException("Error in resampling");
            }
            int[] samples = new int[DistributedSMC.this.N];
            Random rand = DistributedSMC.this.random.getReSamplingSeed(t);
            for (int n = 0; n < DistributedSMC.this.N; ++n) {
                int sampled;
                long resampleSeed = rand.nextLong();
                int n2 = sampled = RandomGenerator.discreteMultinomial(resampleSeed, weights, 1.0);
                samples[n2] = samples[n2] + 1;
            }
            if (this.machineId == 0) {
                sb = new StringBuffer();
                for (int i = 0; i < DistributedSMC.this.N; ++i) {
                    sb.append(samples[i] + " ");
                }
                LogInfo.logs(sb.toString());
            }
            return samples;
        }

        public void optimize(int t, int[] sampled) {
            block17: {
                Hashtable<Integer, Integer> rejects;
                int[] spaces;
                block20: {
                    block19: {
                        block18: {
                            spaces = new int[this.machineConfig.length];
                            rejects = new Hashtable<Integer, Integer>();
                            for (int n = 0; n < sampled.length; ++n) {
                                if (sampled[n] == 0) continue;
                                SMC.Particle p = this.leaves.get(n);
                                for (int i = 0; i < sampled[n]; ++i) {
                                    if (spaces[p.machineId] < this.machineConfig[p.machineId][1]) {
                                        p.addMachine(p.machineId);
                                        int n2 = p.machineId;
                                        spaces[n2] = spaces[n2] + 1;
                                        continue;
                                    }
                                    int value = 0;
                                    if (rejects.containsKey(n)) {
                                        value = (Integer)rejects.get(n);
                                    }
                                    rejects.put(n, ++value);
                                }
                            }
                            if (rejects.isEmpty()) break block17;
                            if (DistributedSMC.this.optimizationStyle != ParticleOptimizationStyle.FIRST_OPEN) break block18;
                            for (Map.Entry entry : rejects.entrySet()) {
                                SMC.Particle p = this.leaves.get((Integer)entry.getKey());
                                block3: for (int j = 0; j < (Integer)entry.getValue(); ++j) {
                                    for (int k = 0; k < this.machineConfig.length; ++k) {
                                        if (k == p.machineId || spaces[k] >= this.machineConfig[k][1]) continue;
                                        p.addMachine(k);
                                        int n = k;
                                        spaces[n] = spaces[n] + 1;
                                        continue block3;
                                    }
                                }
                            }
                            break block17;
                        }
                        if (DistributedSMC.this.optimizationStyle != ParticleOptimizationStyle.MOST_AVAILABLE) break block19;
                        double[] candidateMachines = new double[this.machineConfig.length];
                        int totalAvailable = 0;
                        for (int k = 0; k < this.machineConfig.length; ++k) {
                            double spaceAvailable;
                            if (spaces[k] >= this.machineConfig[k][1]) continue;
                            candidateMachines[k] = spaceAvailable = (double)(this.machineConfig[k][1] - spaces[k]);
                            totalAvailable = (int)((double)totalAvailable + spaceAvailable);
                        }
                        Random r = DistributedSMC.this.random.getMachineSamplingSeed(t);
                        for (Map.Entry entry : rejects.entrySet()) {
                            SMC.Particle p = this.leaves.get((Integer)entry.getKey());
                            for (int j = 0; j < (Integer)entry.getValue(); ++j) {
                                int selectedMachine = RandomGenerator.discreteMultinomial(r.nextLong(), candidateMachines, (double)totalAvailable);
                                p.addMachine(selectedMachine);
                                int n = selectedMachine;
                                spaces[n] = spaces[n] + 1;
                                --totalAvailable;
                                candidateMachines[selectedMachine] = candidateMachines[selectedMachine] - 1.0;
                            }
                        }
                        break block17;
                    }
                    if (DistributedSMC.this.optimizationStyle != ParticleOptimizationStyle.POWER_OF_TWO) break block20;
                    Random r = DistributedSMC.this.random.getMachineSamplingSeed(t);
                    for (Map.Entry entry : rejects.entrySet()) {
                        SMC.Particle p = this.leaves.get((Integer)entry.getKey());
                        for (int j = 0; j < (Integer)entry.getValue(); ++j) {
                            int m1 = r.nextInt(this.machineConfig.length);
                            int m2 = r.nextInt(this.machineConfig.length);
                            int selectedMachine = m1;
                            while (spaces[m1] >= this.machineConfig[m1][1] && spaces[m2] >= this.machineConfig[m2][1]) {
                                m1 = r.nextInt(this.machineConfig.length);
                                m2 = r.nextInt(this.machineConfig.length);
                            }
                            if (this.machineConfig[m2][1] - spaces[m2] > this.machineConfig[m1][1] - spaces[m1]) {
                                selectedMachine = m2;
                            }
                            p.addMachine(selectedMachine);
                            int n = selectedMachine;
                            spaces[n] = spaces[n] + 1;
                        }
                    }
                    break block17;
                }
                if (DistributedSMC.this.optimizationStyle != ParticleOptimizationStyle.RANDOM) break block17;
                Random r = DistributedSMC.this.random.getMachineSamplingSeed(t);
                for (Map.Entry entry : rejects.entrySet()) {
                    SMC.Particle p = this.leaves.get((Integer)entry.getKey());
                    for (int j = 0; j < (Integer)entry.getValue(); ++j) {
                        int selectedMachine = r.nextInt(this.machineConfig.length);
                        while (spaces[selectedMachine] >= this.machineConfig[selectedMachine][1]) {
                            selectedMachine = r.nextInt(this.machineConfig.length);
                        }
                        p.addMachine(selectedMachine);
                        int n = selectedMachine;
                        spaces[n] = spaces[n] + 1;
                    }
                }
            }
        }

        public List<SMC.Particle<S>> getLeaves() {
            return this.leaves;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Machine=" + this.machineId + "\n");
            Iterator iterator = this.leaves.iterator();
            while (iterator.hasNext()) {
                SMC.Particle p;
                SMC.Particle parent = p = iterator.next();
                while (parent != null) {
                    sb.append("(" + parent.id + ", ");
                    if (parent.sample != null) {
                        sb.append(parent.sample.toString() + ")");
                    } else {
                        sb.append(")");
                    }
                    if ((parent = parent.parent) == null) continue;
                    sb.append("->");
                }
                sb.append("\n");
            }
            return sb.toString();
        }
    }

    public static enum ParticleOptimizationStyle {
        FIRST_OPEN,
        RANDOM,
        POWER_OF_TWO,
        MOST_AVAILABLE;

    }
}

