/*
 * Decompiled with CFR 0.152.
 */
package smc;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import nuts.math.Sampling;

public class RandomGenerator {
    private ArrayList<Long> seeds;
    private Random masterRandom = new Random();
    private ArrayList<Long> resampleSeeds;
    private ArrayList<Long> machineSeeds;

    public RandomGenerator(int T) {
        this.seeds = new ArrayList();
        this.resampleSeeds = new ArrayList();
        this.machineSeeds = new ArrayList();
        for (int t = 0; t < T; ++t) {
            this.seeds.add(this.masterRandom.nextLong());
            this.resampleSeeds.add(this.masterRandom.nextLong());
            this.machineSeeds.add(this.masterRandom.nextLong());
        }
    }

    public long getSeed(int t, int n) {
        Random rand = new Random(this.seeds.get(t));
        for (int i = 0; i < n; ++i) {
            rand.nextLong();
        }
        return rand.nextLong();
    }

    public Random getReSamplingSeed(int t) {
        Random rand = new Random(this.resampleSeeds.get(t));
        return rand;
    }

    public Random getMachineSamplingSeed(int t) {
        Random rand = new Random(this.machineSeeds.get(t));
        return rand;
    }

    public static double generateNormal(long seed, double mean, double sigmaSquared) {
        Random rand = new Random(seed);
        double normal = rand.nextGaussian();
        double sigma = Math.sqrt(sigmaSquared);
        normal = normal * sigma + mean;
        return normal;
    }

    public static int discreteMultinomial(long seed, double[] weights, double norm) {
        Random rand = new Random(seed);
        double dart = rand.nextDouble() * norm;
        double total = 0.0;
        for (int i = 0; i < weights.length; ++i) {
            if (!(dart < (total += weights[i]))) continue;
            return i;
        }
        throw new RuntimeException("something went wrong in RandomGenerator");
    }

    public static int discreteMultinomial(Random rand, double[] weights, double norm) {
        double dart = rand.nextDouble() * norm;
        double total = 0.0;
        for (int i = 0; i < weights.length; ++i) {
            if (!(dart < (total += weights[i]))) continue;
            return i;
        }
        throw new RuntimeException("something went wrong in RandomGenerator");
    }

    public static int discreteMultinomial(long seed, List<Double> weights) {
        Random rand = new Random(seed);
        int sampled = Sampling.sample(rand, weights);
        return sampled;
    }
}

