/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.AbstractMath;
import JSci.maths.Complex;
import JSci.maths.NumericalConstants;

public final class FourierMath
extends AbstractMath
implements NumericalConstants {
    private FourierMath() {
    }

    public static Complex[] transform(Complex[] complexArray) {
        int n;
        int n2 = complexArray.length;
        if (!FourierMath.isPowerOf2(n2)) {
            throw new IllegalArgumentException("The number of samples must be a power of 2.");
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        int n3 = FourierMath.numberOfBitsNeeded(n2);
        for (int i = 0; i < n2; ++i) {
            n = FourierMath.reverseBits(i, n3);
            dArray[n] = complexArray[i].real();
            dArray2[n] = complexArray[i].imag();
        }
        FourierMath.fft(dArray, dArray2, Math.PI * 2);
        Complex[] complexArray2 = new Complex[n2];
        for (n = 0; n < n2; ++n) {
            complexArray2[n] = new Complex(dArray[n], dArray2[n]);
        }
        return complexArray2;
    }

    public static Complex[] transform(double[] dArray, double[] dArray2) {
        int n;
        int n2 = dArray.length;
        if (!FourierMath.isPowerOf2(n2)) {
            throw new IllegalArgumentException("The number of samples must be a power of 2.");
        }
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        int n3 = FourierMath.numberOfBitsNeeded(n2);
        for (int i = 0; i < n2; ++i) {
            n = FourierMath.reverseBits(i, n3);
            dArray3[n] = dArray[i];
            dArray4[n] = dArray2[i];
        }
        FourierMath.fft(dArray3, dArray4, Math.PI * 2);
        Complex[] complexArray = new Complex[n2];
        for (n = 0; n < n2; ++n) {
            complexArray[n] = new Complex(dArray3[n], dArray4[n]);
        }
        return complexArray;
    }

    public static Complex[] transform(double[] dArray) {
        int n;
        int n2 = dArray.length;
        if (!FourierMath.isPowerOf2(n2)) {
            throw new IllegalArgumentException("The number of samples must be a power of 2.");
        }
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        int n3 = FourierMath.numberOfBitsNeeded(n2);
        for (int i = 0; i < n2; ++i) {
            n = FourierMath.reverseBits(i, n3);
            dArray2[n] = dArray[i];
        }
        FourierMath.fft(dArray2, dArray3, Math.PI * 2);
        Complex[] complexArray = new Complex[n2];
        for (n = 0; n < n2; ++n) {
            complexArray[n] = new Complex(dArray2[n], dArray3[n]);
        }
        return complexArray;
    }

    public static Complex[] inverseTransform(Complex[] complexArray) {
        int n = complexArray.length;
        if (!FourierMath.isPowerOf2(n)) {
            throw new IllegalArgumentException("Data length must be a power of 2.");
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n2 = FourierMath.numberOfBitsNeeded(n);
        for (int i = 0; i < n; ++i) {
            int n3 = FourierMath.reverseBits(i, n2);
            dArray[n3] = complexArray[i].real();
            dArray2[n3] = complexArray[i].imag();
        }
        FourierMath.fft(dArray, dArray2, Math.PI * -2);
        Complex[] complexArray2 = new Complex[n];
        double d = n;
        for (int i = 0; i < n; ++i) {
            complexArray2[i] = new Complex(dArray[i] / d, dArray2[i] / d);
        }
        return complexArray2;
    }

    public static Complex[] inverseTransform(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        if (!FourierMath.isPowerOf2(n)) {
            throw new IllegalArgumentException("Data length must be a power of 2.");
        }
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        int n2 = FourierMath.numberOfBitsNeeded(n);
        for (int i = 0; i < n; ++i) {
            int n3 = FourierMath.reverseBits(i, n2);
            dArray3[n3] = dArray[i];
            dArray4[n3] = dArray2[i];
        }
        FourierMath.fft(dArray3, dArray4, Math.PI * -2);
        Complex[] complexArray = new Complex[n];
        double d = n;
        for (int i = 0; i < n; ++i) {
            complexArray[i] = new Complex(dArray3[i] / d, dArray4[i] / d);
        }
        return complexArray;
    }

    public static Complex[] inverseTransform(double[] dArray) {
        int n = dArray.length;
        if (!FourierMath.isPowerOf2(n)) {
            throw new IllegalArgumentException("Data length must be a power of 2.");
        }
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        int n2 = FourierMath.numberOfBitsNeeded(n);
        for (int i = 0; i < n; ++i) {
            int n3 = FourierMath.reverseBits(i, n2);
            dArray2[n3] = dArray[i];
        }
        FourierMath.fft(dArray2, dArray3, Math.PI * -2);
        Complex[] complexArray = new Complex[n];
        double d = n;
        for (int i = 0; i < n; ++i) {
            complexArray[i] = new Complex(dArray2[i] / d, dArray3[i] / d);
        }
        return complexArray;
    }

    private static void fft(double[] dArray, double[] dArray2, double d) {
        int n = dArray.length;
        int n2 = 1;
        for (int i = 2; i <= n; i <<= 1) {
            double d2 = d / (double)i;
            double d3 = Math.sin(0.5 * d2);
            d3 = 2.0 * d3 * d3;
            double d4 = Math.sin(d2);
            for (int j = 0; j < n; j += i) {
                double d5 = 1.0;
                double d6 = 0.0;
                int n3 = j;
                for (int k = 0; k < n2; ++k) {
                    int n4 = n3 + n2;
                    double d7 = d5 * dArray[n4] - d6 * dArray2[n4];
                    double d8 = d5 * dArray2[n4] + d6 * dArray[n4];
                    dArray[n4] = dArray[n3] - d7;
                    dArray2[n4] = dArray2[n3] - d8;
                    int n5 = n3;
                    dArray[n5] = dArray[n5] + d7;
                    int n6 = n3++;
                    dArray2[n6] = dArray2[n6] + d8;
                    d7 = d3 * d5 + d4 * d6;
                    d8 = d3 * d6 - d4 * d5;
                    d5 -= d7;
                    d6 -= d8;
                }
            }
            n2 = i;
        }
    }

    private static boolean isPowerOf2(int n) {
        int n2 = 1;
        int n3 = 2;
        while (n2 < 32) {
            if (n == n3) {
                return true;
            }
            ++n2;
            n3 <<= 1;
        }
        return false;
    }

    private static int numberOfBitsNeeded(int n) {
        if (n < 2) {
            throw new IllegalArgumentException();
        }
        int n2 = 0;
        while ((n & 1 << n2) <= 0) {
            ++n2;
        }
        return n2;
    }

    private static int reverseBits(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = n3 << 1 | n & 1;
            n >>= 1;
        }
        return n3;
    }

    public static Complex[] sort(Complex[] complexArray) {
        Complex[] complexArray2 = new Complex[complexArray.length];
        int n = complexArray.length / 2;
        for (int i = 0; i < n; ++i) {
            complexArray2[n + i] = complexArray[i];
            complexArray2[i] = complexArray[n + i];
        }
        return complexArray2;
    }

    public static double[] sort(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        int n = dArray.length / 2;
        for (int i = 0; i < n; ++i) {
            dArray2[n + i] = dArray[i];
            dArray2[i] = dArray[n + i];
        }
        return dArray2;
    }
}

