/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.symbolic;

import JSci.maths.groups.AbelianGroup;
import JSci.maths.symbolic.Constant;
import JSci.maths.symbolic.Expression;
import JSci.maths.symbolic.Variable;

class Negative
extends Expression {
    private final Expression arg;

    public Negative(Expression expression) {
        this.arg = expression;
    }

    public String toString() {
        String string = "-";
        string = this.arg.getPriority() < this.getPriority() ? string + "(" + this.arg + ")" : string + "" + this.arg;
        return string;
    }

    public Expression differentiate(Variable variable) {
        return new Negative(this.arg.differentiate(variable));
    }

    public Expression evaluate() {
        Expression expression = this.arg.evaluate();
        if (expression instanceof Constant) {
            AbelianGroup.Member member = (AbelianGroup.Member)((Constant)expression).getValue();
            return new Constant(member.negate());
        }
        return new Negative(expression);
    }

    protected int getPriority() {
        return -1;
    }

    public Object getSet() {
        return this.arg.getSet();
    }
}

