/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import spoon.Launcher;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.declaration.CtAnnotatedElementType;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.eval.PartialEvaluator;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.code.CtExpressionImpl;

public class CtAnnotationImpl<A extends Annotation>
extends CtExpressionImpl<A>
implements CtAnnotation<A> {
    private static final long serialVersionUID = 1L;
    CtTypeReference<A> annotationType;
    Map<String, Object> elementValues = new TreeMap<String, Object>(){
        private static final long serialVersionUID = 3501647177461995350L;

        @Override
        public Object put(String key, Object value) {
            if (value instanceof Class[]) {
                Class[] valsNew = (Class[])value;
                ArrayList ret = new ArrayList(valsNew.length);
                for (int i = 0; i < valsNew.length; ++i) {
                    Class class1 = valsNew[i];
                    ret.add(i, CtAnnotationImpl.this.getFactory().Type().createReference(class1));
                }
                return super.put(key, ret);
            }
            if (value instanceof Class) {
                return super.put(key, CtAnnotationImpl.this.getFactory().Type().createReference((Class)value));
            }
            return super.put(key, value);
        }
    };

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtAnnotation(this);
    }

    protected void appendValues(String elementName, Object ... values) {
        if (!this.elementValues.containsKey(elementName)) {
            this.elementValues.put(elementName, values);
        } else {
            Object o = this.elementValues.get(elementName);
            if (o.getClass().isArray()) {
                Object[] old;
                ArrayList<Object> tmp = new ArrayList<Object>();
                for (Object a : old = (Object[])o) {
                    tmp.add(a);
                }
                for (Object a : values) {
                    tmp.add(a);
                }
                this.elementValues.put(elementName, tmp.toArray());
            } else {
                if (values.length > 1) {
                    throw new RuntimeException("Cannot add array to a non-array value");
                }
                this.elementValues.put(elementName, values[0]);
            }
        }
    }

    @Override
    public A getActualAnnotation() {
        return (A)((Annotation)Proxy.newProxyInstance(this.annotationType.getActualClass().getClassLoader(), new Class[]{this.annotationType.getActualClass()}, (InvocationHandler)new AnnotationInvocationHandler(this)));
    }

    private Object convertValue(Object value) {
        if (value instanceof CtFieldReference) {
            Class<?> c = null;
            try {
                c = ((CtFieldReference)value).getDeclaringType().getActualClass();
            }
            catch (Exception e) {
                return ((CtLiteral)((CtFieldReference)value).getDeclaration().getDefaultExpression().partiallyEvaluate()).getValue();
            }
            if (((CtFieldReference)value).getSimpleName().equals("class")) {
                return c;
            }
            CtField field = ((CtFieldReference)value).getDeclaration();
            if (Enum.class.isAssignableFrom(c)) {
                return Enum.valueOf(c, ((CtFieldReference)value).getSimpleName());
            }
            if (field != null) {
                return this.convertValue(field.getDefaultExpression());
            }
            try {
                return ((Field)((CtFieldReference)value).getActualField()).get(null);
            }
            catch (Exception e) {
                Launcher.logger.error(e.getMessage(), e);
                return null;
            }
        }
        if (value instanceof CtFieldAccess) {
            return this.convertValue(((CtFieldAccess)value).getVariable());
        }
        if (value instanceof CtNewArray) {
            CtNewArray arrayExpression = (CtNewArray)value;
            Class<?> componentType = arrayExpression.getType().getActualClass().getComponentType();
            List<CtExpression<?>> elements = arrayExpression.getElements();
            Object array = Array.newInstance(componentType, elements.size());
            for (int i = 0; i < elements.size(); ++i) {
                Array.set(array, i, this.convertValue(elements.get(i)));
            }
            return array;
        }
        if (value instanceof CtAnnotation) {
            return ((CtAnnotation)value).getActualAnnotation();
        }
        if (value instanceof CtLiteral) {
            return ((CtLiteral)value).getValue();
        }
        if (value instanceof CtCodeElement) {
            PartialEvaluator eval = this.getFactory().Eval().createPartialEvaluator();
            CtCodeElement ret = eval.evaluate(null, (CtCodeElement)value);
            return this.convertValue(ret);
        }
        if (value instanceof CtTypeReference) {
            return ((CtTypeReference)value).getActualClass();
        }
        return value;
    }

    private Class<?> getElementType(String name) {
        CtType t = (CtType)this.getAnnotationType().getDeclaration();
        if (t != null) {
            CtField<?> f = t.getField(name);
            return f.getType().getActualClass();
        }
        Class<A> c = this.getAnnotationType().getActualClass();
        for (Method m : c.getMethods()) {
            if (!m.getName().equals(name)) continue;
            return m.getReturnType();
        }
        return null;
    }

    @Override
    public CtTypeReference<A> getAnnotationType() {
        return this.annotationType;
    }

    private Object getDefaultValue(String fieldName) {
        CtExpression ret = null;
        CtAnnotationType at = (CtAnnotationType)this.getAnnotationType().getDeclaration();
        if (at != null) {
            CtField<?> f = at.getField(fieldName);
            ret = f.getDefaultExpression();
        }
        return ret;
    }

    @Override
    public <T> T getElementValue(String key) {
        Object ret = this.elementValues.get(key);
        if (ret == null) {
            ret = this.getDefaultValue(key);
        }
        if (ret == null) {
            ret = this.getReflectValue(key);
        }
        Class<?> type = this.getElementType(key);
        ret = this.convertValue(ret);
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE && ret.getClass() != Boolean.TYPE) {
                ret = Boolean.parseBoolean(ret.toString());
            } else if (type == Byte.TYPE && ret.getClass() != Byte.TYPE) {
                ret = Byte.parseByte(ret.toString());
            } else if (type == Character.TYPE && ret.getClass() != Character.TYPE) {
                ret = Character.valueOf(ret.toString().charAt(0));
            } else if (type == Double.TYPE && ret.getClass() != Double.TYPE) {
                ret = Double.parseDouble(ret.toString());
            } else if (type == Float.TYPE && ret.getClass() != Float.TYPE) {
                ret = Float.valueOf(Float.parseFloat(ret.toString()));
            } else if (type == Integer.TYPE && ret.getClass() != Integer.TYPE) {
                ret = Integer.parseInt(ret.toString());
            } else if (type == Long.TYPE && ret.getClass() != Long.TYPE) {
                ret = Long.parseLong(ret.toString());
            } else if (type == Short.TYPE && ret.getClass() != Short.TYPE) {
                ret = Short.parseShort(ret.toString());
            }
        }
        if (type.isArray() && ret.getClass() != type) {
            Object array = Array.newInstance(ret.getClass(), 1);
            ((Object[])array)[0] = ret;
            ret = array;
        }
        return (T)ret;
    }

    @Override
    public Map<String, Object> getElementValues() {
        return this.elementValues;
    }

    private Object getReflectValue(String fieldname) {
        try {
            Class<A> c = this.getAnnotationType().getActualClass();
            Method m = c.getMethod(fieldname, new Class[0]);
            return m.getDefaultValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setAnnotationType(CtTypeReference<? extends Annotation> annotationType) {
        this.annotationType = annotationType;
    }

    @Override
    public void setElementValues(Map<String, Object> values) {
        for (Map.Entry<String, Object> e : values.entrySet()) {
            this.elementValues.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public CtElement getAnnotatedElement() {
        return this.getParent();
    }

    @Override
    public CtAnnotatedElementType getAnnotatedElementType() {
        CtElement annotatedElement = this.getAnnotatedElement();
        if (annotatedElement == null) {
            return null;
        }
        if (annotatedElement instanceof CtMethod) {
            return CtAnnotatedElementType.METHOD;
        }
        if (annotatedElement instanceof CtAnnotation || annotatedElement instanceof CtAnnotationType) {
            return CtAnnotatedElementType.ANNOTATION_TYPE;
        }
        if (annotatedElement instanceof CtType) {
            return CtAnnotatedElementType.TYPE;
        }
        if (annotatedElement instanceof CtField) {
            return CtAnnotatedElementType.FIELD;
        }
        if (annotatedElement instanceof CtConstructor) {
            return CtAnnotatedElementType.CONSTRUCTOR;
        }
        if (annotatedElement instanceof CtParameter) {
            return CtAnnotatedElementType.PARAMETER;
        }
        if (annotatedElement instanceof CtLocalVariable) {
            return CtAnnotatedElementType.LOCAL_VARIABLE;
        }
        if (annotatedElement instanceof CtPackage) {
            return CtAnnotatedElementType.PACKAGE;
        }
        return null;
    }

    class AnnotationInvocationHandler
    implements InvocationHandler {
        CtAnnotation<? extends Annotation> annotation;

        public AnnotationInvocationHandler(CtAnnotation<? extends Annotation> annotation) {
            this.annotation = annotation;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String fieldname = method.getName();
            if (fieldname.equals("toString")) {
                return CtAnnotationImpl.this.toString();
            }
            if (fieldname.equals("annotationType")) {
                return this.annotation.getAnnotationType().getActualClass();
            }
            Object ret = CtAnnotationImpl.this.getElementValue(fieldname);
            if (ret instanceof CtLiteral) {
                CtLiteral l = (CtLiteral)ret;
                return l.getValue();
            }
            return ret;
        }
    }
}

