/*
 * Decompiled with CFR 0.152.
 */
package biparse;

import biparse.Utils;
import java.io.IOException;
import nuts.util.Tree;
import nuts.util.Trees;

public class GrammarReductor {
    public static void main(String[] args) throws IOException {
        for (Tree<String> tree : Trees.readTrees(args[0])) {
            System.out.println(Trees.PennTreeRenderer.render(GrammarReductor.simplifyNodes(Utils.removeUnaryChains(tree))));
        }
    }

    public static Tree<String> simplifyNodes(Tree<String> tree) {
        String[] tokens = tree.getLabel().split("[-_>]");
        String label = tokens.length > 0 ? GrammarReductor.collapseOddSymbols(tokens[0].replaceAll("[@]", "")) : "XXX";
        Tree<String> result = new Tree<String>(tree.isLeaf() ? tree.getLabel() : label);
        for (Tree<String> child : tree.getChildren()) {
            result.getChildren().add(GrammarReductor.simplifyNodes(child));
        }
        return result;
    }

    private static String collapseOddSymbols(String symb) {
        if (symb.matches("[A-Z]+")) {
            return symb;
        }
        return "XXX";
    }
}

