/*
 * Decompiled with CFR 0.152.
 */
package conifer.evol;

import Jama.Matrix;
import conifer.Phylogeny;
import conifer.data.AlignedData;
import conifer.data.PhylogeneticData;
import conifer.data.TaxonDatum;
import conifer.evol.CalculatorOptions;
import conifer.evol.EvolutionaryFactoryContext;
import conifer.evol.EvolutionaryOptions;
import conifer.evol.EvolutionaryParameters;
import ev.ex.DataGenerator;
import java.util.Random;
import ma.MSAPoset;
import ma.RateMatrixLoader;
import ma.SequenceType;
import nuts.math.RateMtxUtils;
import nuts.util.Indexer;
import pepper.Encodings;
import pty.RootedTree;
import pty.smc.models.CTMC;
import pty.smc.models.CachedEigenDecomp;
import pty.smc.models.FastDiscreteModelCalculator;
import pty.smc.models.LikelihoodModelCalculator;

public class SimpleSubstitutionLikelihoodModel
implements EvolutionaryParameters,
CTMC {
    private final int seqLen;
    public double[][] rateMatrix;
    private double[] statDist;
    final Indexer<Character> indexer;
    private final Random dataGenerationRandom;
    public final SequenceType sequenceType;
    private final int nChars;
    CachedEigenDecomp Q;
    private static final long serialVersionUID = 1L;

    @Override
    public PhylogeneticData generate(Phylogeny p) {
        RootedTree tree = p.getRooted();
        if (tree == null) {
            tree = RootedTree.Util.centroidRooting(p.getUnrooted());
        }
        DataGenerator generator = new DataGenerator(tree, this.rateMatrix, this.indexer, this.statDist);
        MSAPoset msa = generator.generate(this.dataGenerationRandom, this.seqLen);
        AlignedData observedData = new AlignedData(msa, this.sequenceType);
        return new PhylogeneticData(p, observedData, msa, this);
    }

    @Override
    public LikelihoodModelCalculator createModelCalculator(CalculatorOptions calcOptions, TaxonDatum leafDatum) {
        AlignedData.AlignedDatum alignedDatum = (AlignedData.AlignedDatum)leafDatum;
        return FastDiscreteModelCalculator.observation(this, alignedDatum.cacheInit, false);
    }

    public SimpleSubstitutionLikelihoodModel(EvolutionaryOptions options) {
        this(options, null);
    }

    public SimpleSubstitutionLikelihoodModel(EvolutionaryOptions options, EvolutionaryFactoryContext context) {
        int nSites = options.nSites;
        if (context != null && context.actualNumberOfSites != null) {
            nSites = context.actualNumberOfSites;
        }
        this.seqLen = nSites;
        this.sequenceType = options.sequenceType;
        if (options.sequenceType == SequenceType.RNA) {
            this.indexer = Encodings.rnaEncodings().nonGapCharactersIndexer();
            this.rateMatrix = RateMatrixLoader.k2p(options.transitionToTransversionRatio);
        } else if (options.sequenceType == SequenceType.PROTEIN) {
            this.indexer = Encodings.proteinEncodings().nonGapCharactersIndexer();
            this.rateMatrix = RateMatrixLoader.dayhoff();
        } else {
            throw new RuntimeException();
        }
        this.statDist = RateMtxUtils.getStationaryDistribution(this.rateMatrix);
        this.dataGenerationRandom = options.rand;
        Matrix originalQ = new Matrix(this.rateMatrix);
        this.Q = new CachedEigenDecomp(originalQ.eig());
        this.nChars = this.statDist.length;
    }

    public SimpleSubstitutionLikelihoodModel(SimpleSubstitutionLikelihoodModel model) {
        this.sequenceType = model.sequenceType;
        this.seqLen = model.seqLen;
        this.rateMatrix = model.rateMatrix;
        this.statDist = model.statDist;
        this.indexer = model.indexer;
        this.dataGenerationRandom = model.dataGenerationRandom;
        this.Q = model.Q;
        this.nChars = model.nChars;
    }

    public SimpleSubstitutionLikelihoodModel copyWithNewRateMtx(double[][] newRateMtx) {
        SimpleSubstitutionLikelihoodModel result = new SimpleSubstitutionLikelihoodModel(this);
        result.rateMatrix = newRateMtx;
        result.Q = new CachedEigenDecomp(new Matrix(newRateMtx).eig());
        result.statDist = RateMtxUtils.getStationaryDistribution(newRateMtx);
        return result;
    }

    @Override
    public int nSites() {
        return this.seqLen;
    }

    @Override
    public final int nCharacter(int site) {
        return this.nChars;
    }

    @Override
    public double[][] getTransitionPr(int site, double t) {
        return RateMtxUtils.marginalTransitionMtx(this.Q.getV(), this.Q.getVinv(), this.Q.getD(), t);
    }

    @Override
    public double[] getInitialDistribution(int site) {
        return this.statDist;
    }

    @Override
    public CachedEigenDecomp getRateMtx(int site) {
        return this.Q;
    }

    @Override
    public boolean isSiteTied() {
        return true;
    }
}

