/*
 * Decompiled with CFR 0.152.
 */
package conifer.largemove;

import conifer.Phylogeny;
import conifer.data.DataModel;
import conifer.data.DataOptions;
import conifer.data.PhylogeneticData;
import fig.basic.Pair;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import nuts.util.Arbre;

public class LargeMoveOperatorSelection {
    public static double[] branchLengthPerturbations(int nBLExpansions, double modifier, double originalBL) {
        int size = 1 + nBLExpansions * 2;
        double[] result = new double[size];
        for (int i = 0; i < size; ++i) {
            result[i] = originalBL * Math.pow(modifier, i - nBLExpansions);
        }
        return result;
    }

    public static List<Pair<Arbre<Taxon>, Arbre<Taxon>>> allEdges(Arbre<Taxon> topology) {
        ArrayList<Pair<Arbre<Taxon>, Arbre<Taxon>>> result = new ArrayList<Pair<Arbre<Taxon>, Arbre<Taxon>>>();
        LargeMoveOperatorSelection.allEdges(topology, result);
        return result;
    }

    private static void allEdges(Arbre<Taxon> node, List<Pair<Arbre<Taxon>, Arbre<Taxon>>> result) {
        ArrayList<Arbre<Taxon>> allChildren = new ArrayList<Arbre<Taxon>>(node.getChildren());
        LargeMoveOperatorSelection.sort(allChildren);
        for (Arbre arbre : allChildren) {
            result.add(Pair.makePair(node, arbre));
            LargeMoveOperatorSelection.allEdges(arbre, result);
        }
    }

    public static void main(String[] args) {
        Random rand = new Random(1L);
        DataOptions to = new DataOptions();
        to.generatingTreeOptions.nTaxa = 20;
        PhylogeneticData data2 = DataModel.GENERATED.loadDataset(to);
        Phylogeny p = data2.getPhylogeny();
        System.out.println(p);
        System.out.println(LargeMoveOperatorSelection.randomNonTerminalEdgesInPreorder(rand, p.getRooted().topology()));
    }

    public static List<Pair<Arbre<Taxon>, Arbre<Taxon>>> randomNonTerminalEdgesInPreorder(Random rand, Arbre<Taxon> topology) {
        ArrayList<Pair<Arbre<Taxon>, Arbre<Taxon>>> result = new ArrayList<Pair<Arbre<Taxon>, Arbre<Taxon>>>();
        LargeMoveOperatorSelection.randomNonTerminalEdges(rand, topology, 0, result);
        return result;
    }

    private static void sort(List<Arbre<Taxon>> allChildren) {
        Collections.sort(allChildren, new Comparator<Arbre<Taxon>>(){

            @Override
            public int compare(Arbre<Taxon> o1, Arbre<Taxon> o2) {
                return o1.getContents().compareTo(o2.getContents());
            }
        });
    }

    private static void randomNonTerminalEdges(Random rand, Arbre<Taxon> topology, int blocks, List<Pair<Arbre<Taxon>, Arbre<Taxon>>> result) {
        if (blocks != 0 && blocks != 1 && blocks != 2) {
            throw new RuntimeException();
        }
        ArrayList<Arbre<Taxon>> allChildren = new ArrayList<Arbre<Taxon>>(topology.getChildren());
        LargeMoveOperatorSelection.sort(allChildren);
        int pickedChildIndex = -1;
        if (blocks == 0) {
            ArrayList<Integer> candidates = new ArrayList<Integer>();
            for (int i = 0; i < allChildren.size(); ++i) {
                Arbre child = (Arbre)allChildren.get(i);
                if (child.getChildren().isEmpty()) continue;
                candidates.add(i);
            }
            if (!candidates.isEmpty()) {
                int indexIndex = rand.nextInt(candidates.size());
                pickedChildIndex = (Integer)candidates.get(indexIndex);
                result.add(Pair.makePair(topology, allChildren.get(pickedChildIndex)));
            }
        }
        for (int i = 0; i < allChildren.size(); ++i) {
            int cBlocks = -1;
            cBlocks = pickedChildIndex == i ? 2 : (blocks == 0 ? 1 : blocks - 1);
            LargeMoveOperatorSelection.randomNonTerminalEdges(rand, (Arbre)allChildren.get(i), cBlocks, result);
        }
    }

    public static Pair<Arbre<Taxon>, Arbre<Taxon>> randomNonTerminalEdge(Random rand, Arbre<Taxon> topology) {
        ArrayList<Arbre<Taxon>> validSubtrees = new ArrayList<Arbre<Taxon>>();
        for (Arbre<Taxon> subtree : topology.nodes()) {
            if (subtree.isRoot() || subtree.getChildren().isEmpty()) continue;
            validSubtrees.add(subtree);
        }
        LargeMoveOperatorSelection.sort(validSubtrees);
        int index = rand.nextInt(validSubtrees.size());
        Arbre picked = (Arbre)validSubtrees.get(index);
        return Pair.makePair(picked.getParent(), picked);
    }
}

