/*
 * Decompiled with CFR 0.152.
 */
package conifer.ml.data;

import fig.basic.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import nuts.util.CollUtils;
import nuts.util.Counter;
import nuts.util.CounterMap;
import nuts.util.Indexer;
import pty.learn.CTMCExpectations;

public class EndPointDataset<S> {
    public final Counter<S> initialCounts = new Counter();
    public final Map<Double, CounterMap<S, S>> endPoints = new HashMap<Double, CounterMap<S, S>>();

    public Set<Double> branchLengths() {
        return this.endPoints.keySet();
    }

    public CounterMap<S, S> endPointCounts(double branchLength) {
        return this.endPoints.get(branchLength);
    }

    public CounterMap<S, S> getEndPointCounter(double length) {
        return CollUtils.getNoNull(this.endPoints, length, new CounterMap());
    }

    public List<Pair<Integer, Double>> addGeneratedData(double branchLength, double[][] rateMatrix, Random rand, Indexer<S> indexer) {
        List<Pair<Integer, Double>> fullPath = CTMCExpectations.simulate(branchLength, rand, rateMatrix);
        S initValue = indexer.i2o(fullPath.get(0).getFirst());
        this.initialCounts.incrementCount(initValue, 1.0);
        S endValue = indexer.i2o(fullPath.get(fullPath.size() - 1).getFirst());
        this.getEndPointCounter(branchLength).incrementCount(initValue, endValue, 1.0);
        return fullPath;
    }
}

