/*
 * Decompiled with CFR 0.152.
 */
package conifer.ml.main;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import conifer.ml.CTMCExpFam;
import conifer.ml.ExpectedStatistics;
import conifer.ml.OptimizationOptions;
import conifer.ml.main.CTMCExpFamLoader;
import conifer.ml.main.Utils;
import fig.basic.Option;
import fig.basic.OptionSet;
import fig.basic.StrUtils;
import fig.exec.Execution;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import nuts.io.IO;
import nuts.util.Counter;

public class MMain
implements Runnable {
    @OptionSet(name="model")
    public CTMCExpFamLoader modelLoader = new CTMCExpFamLoader();
    @OptionSet(name="optimization")
    public OptimizationOptions optimizationOptions = new OptimizationOptions();
    @Option(required=true)
    public ArrayList<String> EStepFiles = new ArrayList();
    @Option(gloss="File with initial parameter (randomly generated from a normal if the value of argument is left empty)")
    public String initialParameters = "";
    @Option(gloss="If left empty, creates output in a new subdirectory of ./state/execs")
    public String outputDirectory = "";
    @Option(gloss="File to output learned weights (leave empty to skip this output")
    public String learnedWeightsOutputFile = "learned-weights.json";
    @Option(gloss="File to output learned rate matrix (leave empty to skip this output")
    public String learnedRateMatrixOutputFile = "learned-rate-matrix.json";
    @Option(gloss="File to output learned stationary distribution (leave empty to skip this output")
    public String learnedStationaryDistOutputFile = "learned-stat-dist.json";
    @Option
    public Random randomSeedInitialParameters = new Random(1L);
    @Option
    public double varianceInitialParameters = 1.0;
    @Option
    public boolean checkAllFeaturesValid = true;

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        ArrayList messages = Lists.newArrayList();
        File outputDir = new File(this.outputDirectory == null || this.outputDirectory.equals("") ? Execution.virtualExecDir : this.outputDirectory);
        CTMCExpFam<String> model = this.modelLoader.load();
        ExpectedStatistics<String> expectedStatistics = new ExpectedStatistics<String>(model);
        for (String EStepFile : this.EStepFiles) {
            List<Utils.RateMatrixStatistic> statisticsFromJSON = Utils.statisticsFromJSON(new File(EStepFile));
            messages.addAll(Utils.validateStatistics(statisticsFromJSON, model.stateIndexer));
            Utils.addToExpectedStatistics(expectedStatistics, statisticsFromJSON);
        }
        double[] warmStart = null;
        if (StrUtils.isEmpty(this.initialParameters)) {
            double sqrt = Math.sqrt(this.varianceInitialParameters);
            warmStart = new double[model.nFeatures()];
            if (this.varianceInitialParameters > 0.0) {
                void var8_11;
                boolean bl = false;
                while (var8_11 < warmStart.length) {
                    warmStart[var8_11] = this.randomSeedInitialParameters.nextGaussian() * sqrt;
                    ++var8_11;
                }
            }
        } else {
            Counter<Object> initialParamCounter = Utils.counterFromJSON(new File(this.initialParameters));
            if (this.checkAllFeaturesValid) {
                for (Object e : initialParamCounter.keySet()) {
                    if (model.featuresIndexer.objects().contains(e)) continue;
                    messages.add("Unknown feature in initialParameter: " + e + " (can disable this check with 'checkAllFeaturesValid' set to false)");
                }
            }
            warmStart = model.convertFeatureCounter(initialParamCounter);
        }
        if (messages.size() > 0) {
            throw new RuntimeException("Errors prevented running E step");
        }
        CTMCExpFam.LearnedReversibleModel fitReversibleModel = model.fitReversibleModel(this.optimizationOptions, expectedStatistics, warmStart);
        if (!StrUtils.isEmpty(this.learnedWeightsOutputFile)) {
            Counter<String> learnedWeights = fitReversibleModel.getWeights();
            Utils.counterToJSON(learnedWeights, new File(outputDir, this.learnedWeightsOutputFile));
        }
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
        if (!StrUtils.isEmpty(this.learnedRateMatrixOutputFile)) {
            IO.writeToDisk(new File(outputDir, this.learnedRateMatrixOutputFile), gson.toJson((Object)fitReversibleModel.getRateMatrix()));
        }
        if (!StrUtils.isEmpty(this.learnedStationaryDistOutputFile)) {
            IO.writeToDisk(new File(outputDir, this.learnedStationaryDistOutputFile), gson.toJson((Object)fitReversibleModel.pi));
        }
    }

    public static void main(String[] args) {
        IO.run(args, new MMain());
    }
}

