/*
 * Decompiled with CFR 0.152.
 */
package conifer.ml.main;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import conifer.ml.ExpectedStatistics;
import conifer.ml.extractors.BivariateFeatureExtractor;
import conifer.ml.extractors.UnivariateFeatureExtractor;
import fig.basic.UnorderedPair;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nuts.io.IO;
import nuts.math.Graph;
import nuts.math.HashGraph;
import nuts.util.Counter;
import nuts.util.Indexer;

public class Utils {
    public static UnivariateFeatureExtractor<String> univariateFeatureExtractor(List<StateFeatureAssociation> features) {
        final Map featureMap = Utils.getFeatureMap(features, true);
        return new UnivariateFeatureExtractor<String>(){

            @Override
            public void extract(Counter counts, String state) {
                Set features = (Set)featureMap.get(state);
                if (features != null) {
                    counts.incrementAll(features, 1.0);
                }
            }

            public String toString() {
                return "UnivariateFeatureExtractor";
            }
        };
    }

    public static BivariateFeatureExtractor<String> bivariateFeatureExtractor(List<StateFeatureAssociation> features) {
        final Map featureMap = Utils.getFeatureMap(features, false);
        return new BivariateFeatureExtractor<String>(){

            @Override
            public void extract(Counter counts, String state1, String state2) {
                UnorderedPair<String, String> key = new UnorderedPair<String, String>(state1, state2);
                Set features = (Set)featureMap.get(key);
                if (features != null) {
                    counts.incrementAll(features, 1.0);
                }
            }

            public String toString() {
                return "BivariateFeatureExtractor";
            }
        };
    }

    private static Map getFeatureMap(List<StateFeatureAssociation> features, boolean univariate) {
        HashMap<Object, HashSet<String>> map = new HashMap<Object, HashSet<String>>();
        int nVars = univariate ? 1 : 2;
        for (StateFeatureAssociation f : features) {
            if (f.states.size() != nVars) continue;
            Object key = univariate ? f.states.get(0) : new UnorderedPair<String, String>(f.states.get(0), f.states.get(1));
            HashSet<String> values = new HashSet<String>(f.features);
            if (map.containsKey(key) && !values.equals(map.get(key))) {
                throw new RuntimeException("Probably a bivariate features that is not symmetric in its two arguments: " + key);
            }
            map.put(key, values);
        }
        return map;
    }

    public static void addToExpectedStatistics(ExpectedStatistics<String> expStat, List<RateMatrixStatistic> statList) {
        for (RateMatrixStatistic stat : statList) {
            if (stat.type == RateMatrixStatisticType.HOLD) {
                expStat.addHoldingTime(stat.states.get(0), stat.value);
                continue;
            }
            if (stat.type == RateMatrixStatisticType.INIT) {
                expStat.addInitialValue(stat.states.get(0), stat.value);
                continue;
            }
            if (stat.type == RateMatrixStatisticType.TRANS) {
                expStat.addTransition(stat.states.get(0), stat.states.get(1), stat.value);
                continue;
            }
            throw new RuntimeException();
        }
    }

    public static List<StateFeatureAssociation> featuresFromJSON(File file) {
        Type listType = new TypeToken<ArrayList<StateFeatureAssociation>>(){}.getType();
        return (List)new Gson().fromJson(IO.f2s(file), listType);
    }

    public static List<String> validateFeatures(List<StateFeatureAssociation> feature, Indexer<String> indexer) {
        ArrayList msgs = Lists.newArrayList();
        for (StateFeatureAssociation f : feature) {
            if (f.features == null) {
                msgs.add("Missing 'features' field in: " + f);
            }
            if (f.states == null) {
                msgs.add("Missing 'states' fields in: " + f);
                continue;
            }
            for (String state : f.states) {
                if (indexer.containsObject(state)) continue;
                msgs.add("State was not declared in the state file: " + state);
            }
            if (f.states.size() == 1 || f.states.size() == 2) continue;
            msgs.add("Features should be defined on single state or pairs of states, so this list should have length one or two: " + f.states);
        }
        return msgs;
    }

    public static List<RateMatrixStatistic> statisticsFromJSON(File file) {
        Type listType = new TypeToken<ArrayList<RateMatrixStatistic>>(){}.getType();
        return (List)new Gson().fromJson(IO.f2s(file), listType);
    }

    public static Graph<String> graph(List<List<String>> edges, Set<String> vertices) {
        HashSet convertedEdges = Sets.newHashSet();
        for (List<String> edge : edges) {
            if (edge.size() != 2) {
                throw new RuntimeException("Edges should have two end points: " + edge);
            }
            convertedEdges.add(new UnorderedPair<String, String>(edge.get(0), edge.get(1)));
        }
        return new HashGraph<String>(vertices, convertedEdges);
    }

    public static List<String> statesFromJSON(File file) {
        Type listType = new TypeToken<ArrayList<String>>(){}.getType();
        return (List)new Gson().fromJson(IO.f2s(file), listType);
    }

    public static List<List<String>> edgesFromJSON(File file) {
        Type listType = new TypeToken<ArrayList<List<String>>>(){}.getType();
        return (List)new Gson().fromJson(IO.f2s(file), listType);
    }

    public static List<CounterEntry> counterEntriesFromJSON(File file) {
        Type listType = new TypeToken<ArrayList<CounterEntry>>(){}.getType();
        return (List)new Gson().fromJson(IO.f2s(file), listType);
    }

    public static Counter<String> counterFromJSON(File file) {
        List<CounterEntry> entries = Utils.counterEntriesFromJSON(file);
        Counter<String> result = new Counter<String>();
        for (CounterEntry entry : entries) {
            if (entry.key == null) {
                throw new RuntimeException("Malformed counter entry (missing key): " + entry);
            }
            if (result.containsKey(entry.key)) {
                throw new RuntimeException("Duplicated counter entry: " + entry.key);
            }
            result.setCount(entry.key, entry.value);
        }
        return result;
    }

    public static void counterToJSON(Counter c, File f) {
        ArrayList entries = Lists.newArrayList();
        for (Object key : c.keySet()) {
            entries.add(new CounterEntry(key.toString(), c.getCount(key)));
        }
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
        String jsonOutput = gson.toJson((Object)entries);
        IO.writeToDisk(f, jsonOutput);
    }

    public static void main(String[] args) {
        System.out.println(Utils.statisticsFromJSON(new File("/Users/bouchard/Downloads/Estepfiles(1).json")));
        System.out.println(Utils.featuresFromJSON(new File("/Users/bouchard/temp/temp.json")));
        System.out.println(Utils.statisticsFromJSON(new File("/Users/bouchard/temp/temp-stat.json")));
        System.out.println(Utils.edgesFromJSON(new File("/Users/bouchard/Documents/experiments/tests/hky85-model/support.json")));
    }

    public static List<String> validateEdges(List<List<String>> edges, Indexer<String> indexer) {
        ArrayList result = Lists.newArrayList();
        for (List<String> edge : edges) {
            if (edge.size() != 2) {
                result.add("Each edge in the support file should have exactly two end-points: " + edge);
            }
            for (String s : edge) {
                if (indexer.containsObject(s)) continue;
                result.add("State was not declared in the state file: " + s);
            }
        }
        return result;
    }

    public static List<String> validateStatistics(List<RateMatrixStatistic> statisticsFromJSON, Indexer<String> stateIndexer) {
        ArrayList result = Lists.newArrayList();
        for (RateMatrixStatistic stat : statisticsFromJSON) {
            if (stat.states == null || stat.type == null) {
                result.add("Missing 'states' or 'type' is not one of 'INIT', 'HOLD' or 'TRANS': " + stat.states);
            }
            if (stat.value < 0.0) {
                result.add("Value of statistics should be non-negative: " + stat);
            }
            if ((stat.type == RateMatrixStatisticType.HOLD || stat.type == RateMatrixStatisticType.INIT) && stat.states.size() != 1) {
                result.add("Hold time/init statistics should be defined on exactly one state: " + stat);
            }
            if (stat.type != RateMatrixStatisticType.TRANS || stat.states.size() == 2) continue;
            result.add("Transition statistics should be defined on exactly two states: " + stat);
        }
        return result;
    }

    public static class BivariateFeature {
        public String state;
        public String otherState;
        public List<String> features;
    }

    public static class RateMatrixStatistic {
        public RateMatrixStatisticType type;
        public List<String> states;
        public double value;

        public String toString() {
            return "RateMatrixStatistic [type=" + (Object)((Object)this.type) + ", states=" + this.states + ", value=" + this.value + "]";
        }
    }

    public static enum RateMatrixStatisticType {
        HOLD,
        INIT,
        TRANS;

    }

    public static class CounterEntry {
        public String key = null;
        public double value;

        public CounterEntry(String string, double count) {
            this.key = string;
            this.value = count;
        }

        public String toString() {
            return "CounterEntry [key=" + this.key + ", value=" + this.value + "]";
        }
    }

    public static class StateFeatureAssociation {
        public List<String> states;
        public List<String> features;

        public String toString() {
            return "UnivariateFeature [states=" + this.states + ", features=" + this.features + "]";
        }
    }
}

