/*
 * Decompiled with CFR 0.152.
 */
package conifer.msa;

import conifer.pip.PIPLikelihoodTests;
import fig.basic.Pair;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import ma.MSAPoset;
import ma.RateMatrixLoader;
import nuts.math.TopoSort;
import nuts.util.Counter;
import nuts.util.Indexer;
import org.junit.Assert;
import org.junit.Test;
import pty.RandomRootedTrees;

public class LinearizationProposal {
    private static boolean testing = false;

    public static <S> Pair<List<S>, Double> sample_logPrLinearization(TopoSort.PartialOrder<S> po, Random rand) {
        return (Pair)LinearizationProposal._sample_computeLogPr_randomLinearization(po, null, rand);
    }

    public static <S> double logPrLinearization(TopoSort.PartialOrder<S> po, List<S> inputList) {
        return (Double)LinearizationProposal._sample_computeLogPr_randomLinearization(po, inputList, null);
    }

    private static <S> Object _sample_computeLogPr_randomLinearization(TopoSort.PartialOrder<S> po, List<S> inputList, Random rand) {
        boolean isSampling;
        RandomAccessBlockingPriorities<S> priorities = new RandomAccessBlockingPriorities<S>();
        boolean bl = isSampling = rand != null;
        if (isSampling && inputList != null) {
            throw new RuntimeException();
        }
        ArrayList result = testing || isSampling ? new ArrayList() : null;
        double logPr = 0.0;
        for (S node : po.nodes()) {
            priorities.setPriority(node, po.prev(node).size());
        }
        int inputListIndex = 0;
        while (priorities.nZeroBlocks() > 0) {
            logPr -= Math.log(priorities.nZeroBlocks());
            int index = -1;
            index = isSampling ? rand.nextInt(priorities.nZeroBlocks()) : priorities.zeroBlockElements().indexOf(inputList.get(inputListIndex++));
            Object item = priorities.popZeroBlockElement(index);
            for (S next : po.next(item)) {
                priorities.decreasePriority(next);
            }
            if (result == null) continue;
            result.add(item);
        }
        if (!priorities.isEmpty()) {
            throw new RuntimeException();
        }
        return result == null ? Double.valueOf(logPr) : Pair.makePair(result, logPr);
    }

    @Test
    public void test_sample_computeLogPr_randomLinearization() {
        Random rand = new Random(1L);
        for (int i = 0; i < 10; ++i) {
            List<Taxon> taxaNames = RandomRootedTrees.generateLeafNames(10);
            Indexer<Character> indexer = RateMatrixLoader.rnaIndexer();
            MSAPoset randomMSA = PIPLikelihoodTests.randomMSA(taxaNames, indexer, rand, 5, 10);
            System.out.println(randomMSA);
            TopoSort.PartialOrder<MSAPoset.Column> poset = randomMSA.getPoset();
            Pair<List<MSAPoset.Column>, Double> o = LinearizationProposal.sample_logPrLinearization(poset, rand);
            System.out.println(o.getFirst());
            System.out.println(o.getSecond());
            testing = true;
            Pair o2 = (Pair)LinearizationProposal._sample_computeLogPr_randomLinearization(poset, o.getFirst(), null);
            Assert.assertEquals(o.getFirst(), o2.getFirst());
            Assert.assertEquals((Object)o.getSecond(), o2.getSecond());
            System.out.println(LinearizationProposal.sample_logPrLinearization(poset, rand).getSecond());
            System.out.println();
        }
    }

    public static class RandomAccessBlockingPriorities<S> {
        private List<S> zeroBlockElements = new ArrayList<S>();
        private Counter<S> nBlocksCounter = new Counter();

        public void setPriority(S item, double nBlocks) {
            if (this.nBlocksCounter.containsKey(item)) {
                throw new RuntimeException();
            }
            this.nBlocksCounter.setCount(item, nBlocks);
            if (nBlocks == 0.0) {
                this.zeroBlockElements.add(item);
            }
        }

        public boolean isEmpty() {
            return this.nBlocksCounter.keySet().isEmpty();
        }

        public void decreasePriority(S item) {
            double newPriority = this.nBlocksCounter.getCount(item) - 1.0;
            if (newPriority < 0.0) {
                throw new RuntimeException();
            }
            this.nBlocksCounter.setCount(item, newPriority);
            if (newPriority == 0.0) {
                this.zeroBlockElements.add(item);
            }
        }

        public int nZeroBlocks() {
            return this.zeroBlockElements.size();
        }

        public List<S> zeroBlockElements() {
            return this.zeroBlockElements;
        }

        public S popZeroBlockElement(int index) {
            S item = this.zeroBlockElements.get(index);
            this.nBlocksCounter.removeKey(item);
            int lastIndex = this.nZeroBlocks() - 1;
            if (index != lastIndex) {
                Collections.swap(this.zeroBlockElements, lastIndex, index);
            }
            this.zeroBlockElements.remove(lastIndex);
            return item;
        }
    }
}

