/*
 * Decompiled with CFR 0.152.
 */
package ev.ex;

import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Pair;
import fig.exec.Execution;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import nuts.io.IO;
import nuts.math.Plot2D;
import nuts.math.StatisticsMap;
import nuts.util.CollUtils;

public class InspectInferenceResults
implements Runnable {
    @Option
    public ArrayList<String> execs = new ArrayList<String>(Arrays.asList("745.exec"));
    @Option
    public ArrayList<Integer> treeSizes = new ArrayList<Integer>(Arrays.asList(10));
    @Option
    public String scpStr = "r22.millennium.berkeley.edu:~/evolvere/e/";

    public static void main(String[] args) {
        IO.run(args, new InspectInferenceResults());
    }

    @Override
    public void run() {
        File destDir = new File(Execution.getFile("downloadedData"));
        destDir.mkdir();
        if (this.execs.size() != this.treeSizes.size()) {
            throw new RuntimeException();
        }
        for (int i = 0; i < this.execs.size(); ++i) {
            String curExec = this.execs.get(i);
            int treeSize = this.treeSizes.get(i);
            File destFile = new File(destDir, curExec + ".results.csv");
            IO.call("scp " + this.scpStr + curExec + "/results/results.csv " + destFile.getAbsolutePath());
            this.plotCurrentTreeSize(destFile, treeSize);
        }
    }

    private void plotCurrentTreeSize(File csvFile, int treeSize) {
        LogInfo.track((Object)("treeSize=" + treeSize), true);
        for (String targetMetric : Arrays.asList("RobinsonFouldsMetric", "PartitionMetric", "KuhnerFelsenstein")) {
            LogInfo.track((Object)("metric=" + targetMetric), true);
            HashSet allIterScales = CollUtils.set();
            HashSet<String> allMethods = CollUtils.set();
            StatisticsMap<Pair<Object, Double>> sm = new StatisticsMap<Pair<Object, Double>>();
            int i = 0;
            for (List<String> line : IO.iCSV(csvFile)) {
                if (i++ <= 0) continue;
                String method = line.get(0);
                double iterScale = Double.parseDouble(line.get(1));
                String curMetric = line.get(3);
                if (!curMetric.equals(targetMetric)) continue;
                allMethods.add(method);
                allIterScales.add(iterScale);
                double value = Double.parseDouble(line.get(4));
                Pair<Object, Double> key = Pair.makePair(method, iterScale);
                sm.addValue(key, value);
            }
            LogInfo.logs(sm);
            ArrayList sortedIterScales = CollUtils.list(allIterScales);
            Collections.sort(sortedIterScales);
            Plot2D plot = new Plot2D();
            for (String key : allMethods) {
                ArrayList<Pair<Double, Double>> series = CollUtils.list();
                Iterator iterator = sortedIterScales.iterator();
                while (iterator.hasNext()) {
                    double iterScale = (Double)iterator.next();
                    double mean = sm.getSummaryStat(Pair.makePair(key, iterScale)).getMean();
                    series.add(Pair.makePair(iterScale, mean));
                }
                plot.addSeries(series, key);
            }
            File output = new File(Execution.getFile("size" + treeSize + "-" + targetMetric + ".pdf"));
            plot.savePlot(output);
            LogInfo.end_track();
        }
        LogInfo.end_track();
    }
}

