/*
 * Decompiled with CFR 0.152.
 */
package ev.poi;

import ev.poi.IntegratedLengthMarginalComputations;
import ev.poi.PoissonParameters;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.exec.Execution;
import fig.prob.SampleUtils;
import goblin.Taxon;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import ma.AffineGapAlignmentSampler;
import ma.MSAPoset;
import ma.MultiAlignment;
import nuts.io.IO;
import nuts.math.RateMtxUtils;
import nuts.math.StatisticsMap;
import nuts.util.Arbre;
import nuts.util.CollUtils;
import nuts.util.Counter;
import nuts.util.Tree;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import pepper.Encodings;
import pty.RandomUnrootedTrees;
import pty.RootedTree;

public class PoissonModelSimulator {
    private final PoissonParameters params;
    private final Random rand;

    public static void main(String[] args) {
        IO.run(args, new PoissonModelSimulatorMain());
    }

    public PoissonModelSimulator(PoissonParameters params, Random rand) {
        this.params = params;
        this.rand = rand;
    }

    public static MSAPoset toMSA(List<Map<Taxon, Character>> columns, RootedTree tree) {
        Map<Taxon, String> sequences = PoissonModelSimulator.sequences(columns, tree);
        MSAPoset result = new MSAPoset(sequences);
        Counter<Taxon> indices = new Counter<Taxon>();
        for (Map<Taxon, Character> column : columns) {
            HashMap<Taxon, Integer> points = CollUtils.map();
            for (Taxon t : column.keySet()) {
                points.put(t, (int)indices.getCount(t));
                indices.incrementCount(t, 1.0);
            }
            if (result.tryAdding(points)) continue;
            throw new RuntimeException();
        }
        return result;
    }

    public static Map<Taxon, String> sequences(List<Map<Taxon, Character>> columns, RootedTree tree) {
        HashMap result = CollUtils.map();
        for (Arbre<Taxon> arbre : tree.topology().nodes()) {
            if (!arbre.isLeaf()) continue;
            result.put(arbre.getContents(), new StringBuilder());
        }
        for (Map map : columns) {
            for (Taxon t : map.keySet()) {
                ((StringBuilder)result.get(t)).append(map.get(t));
            }
        }
        HashMap<Taxon, String> converted = CollUtils.map();
        for (Taxon t : result.keySet()) {
            converted.put(t, ((StringBuilder)result.get(t)).toString());
        }
        return converted;
    }

    public List<Map<Taxon, Character>> simulateColumns(RootedTree tree) {
        ArrayList<Map<Taxon, Character>> result = CollUtils.list();
        for (Arbre<Taxon> subt : tree.topology().nodes()) {
            if (subt.isRoot()) continue;
            List<Map<Taxon, Character>> current = this.simulateColumnsForEdge(subt.getContents(), tree);
            result.addAll(current);
        }
        int nPreviousInsertedNothing = 0;
        int threshold = 5;
        boolean done = false;
        RootedTree currentTree = tree;
        for (int i = 0; i < 1000; ++i) {
            Taxon tax = currentTree.topology().getContents();
            currentTree = PoissonModelSimulator.addStem(currentTree, new Taxon("stem-" + i), 100.0);
            List<Map<Taxon, Character>> current = this.simulateColumnsForEdge(tax, currentTree);
            result.addAll(current);
            if (current.isEmpty()) {
                if (++nPreviousInsertedNothing < threshold) continue;
                done = true;
                break;
            }
            nPreviousInsertedNothing = 0;
        }
        if (!done) {
            throw new RuntimeException();
        }
        Collections.shuffle(result, this.rand);
        return result;
    }

    public static RootedTree addStem(RootedTree rt, Taxon newRoot, double len) {
        Arbre<Taxon> newTopo = rt.topology().copy();
        newTopo = Arbre.arbreWithChildren(newRoot, newTopo);
        HashMap<Taxon, Double> newBls = CollUtils.map(rt.branchLengths());
        newBls.put(rt.topology().getContents(), len);
        return new RootedTree.Util.RootedTreeImpl(newTopo, newBls);
    }

    private List<Map<Taxon, Character>> simulateColumnsForEdge(Taxon taxonAtBottomOfEdge, RootedTree tree) {
        ArrayList<Map<Taxon, Character>> result = CollUtils.list();
        double branchLen = tree.branchLengths().get(taxonAtBottomOfEdge);
        double poissonRate = branchLen * this.params.insertRate;
        int nInserts = (int)SampleUtils.samplePoisson(this.rand, poissonRate);
        for (int i = 0; i < nInserts; ++i) {
            Map<Taxon, Character> current = this.simulateColumnForEdge(taxonAtBottomOfEdge, tree);
            if (current.size() <= 0) continue;
            result.add(current);
        }
        return result;
    }

    private Map<Taxon, Character> simulateColumnForEdge(Taxon taxonAtBottomOfEdge, RootedTree tree) {
        HashMap<Taxon, Character> result = CollUtils.map();
        double branchLen = tree.branchLengths().get(taxonAtBottomOfEdge);
        double deathPr = IntegratedLengthMarginalComputations.integratedDeathProbability(branchLen, this.params.Q, this.params.quasiStatProbs);
        if (this.rand.nextDouble() < deathPr) {
            return result;
        }
        this.simulateColumnForEdge(Arbre.findFirstNodeWithContents(tree.topology(), taxonAtBottomOfEdge), result, SampleUtils.sampleMultinomial(this.rand, this.params.quasiStatProbs), tree);
        return result;
    }

    private void simulateColumnForEdge(Arbre<Taxon> subtree, Map<Taxon, Character> result, int currentCharIndex, RootedTree tree) {
        if (subtree.isLeaf()) {
            if (currentCharIndex != this.params.gapIndex) {
                result.put(subtree.getContents(), this.params.indexer.i2o(currentCharIndex));
            }
        } else {
            for (Arbre<Taxon> child : subtree.getChildren()) {
                double[][] transMtx = RateMtxUtils.marginalTransitionMtx(this.params.Q, tree.branchLengths().get(child.getContents()));
                int next = SampleUtils.sampleMultinomial(this.rand, transMtx[currentCharIndex]);
                this.simulateColumnForEdge(child, result, next, tree);
            }
        }
    }

    public static class PoissonModelSimulatorMain
    implements Runnable {
        @Option
        public int nTaxa = 7;
        @Option
        public double expectedLength = 100.0;
        @Option
        public double changeIntensity = 1.0;
        @Option
        public int nReplica = 10;
        @Option
        public double treeRate = 2.0;
        @Option
        public Random rand = new Random(1L);
        @Option
        public boolean useTKF = false;
        public StatisticsMap<String> statistics = new StatisticsMap();
        public DescriptiveStatistics idStats = new DescriptiveStatistics();

        @Override
        public void run() {
            this.generate(new File(Execution.getFile("output")));
        }

        public void generate(File output) {
            this.statistics = new StatisticsMap();
            this.idStats = new DescriptiveStatistics();
            double insertRate = PoissonParameters.getInsertionRate(this.expectedLength, this.changeIntensity);
            double deleteRate = PoissonParameters.getDeleteRate(this.expectedLength, this.changeIntensity);
            PoissonParameters pp = PoissonParameters.rnaParams(insertRate, deleteRate);
            PoissonModelSimulator sim = new PoissonModelSimulator(pp, this.rand);
            output.mkdir();
            for (int i = 0; i < this.nReplica; ++i) {
                String currentName = "sim-" + i;
                LogInfo.track((Object)("Creating replicon " + i + "/" + this.nReplica), true);
                RootedTree tree = RootedTree.Util.centroidRooting(RandomUnrootedTrees.sampleExponentialBranchesUniformTopology(this.rand, this.nTaxa, this.treeRate));
                LogInfo.track((Object)"Tree:", true);
                LogInfo.logs(tree);
                LogInfo.end_track();
                IO.writeToDisk(new File(output, currentName + ".newick"), RootedTree.Util.toNewick(tree));
                MSAPoset msa = null;
                if (this.useTKF) {
                    double mu = 0.002 * this.changeIntensity;
                    double lam = 0.098 * this.changeIntensity;
                    AffineGapAlignmentSampler.TKFParams params = new AffineGapAlignmentSampler.TKFParams(mu, lam, pp.subRateMtx, Encodings.rnaEncodings());
                    Tree<String> convertedTree = Arbre.arbre2Tree(Arbre.arbreToArbreOfStrings(tree.topology()));
                    AffineGapAlignmentSampler.TKFGenerator tkfGenerator = new AffineGapAlignmentSampler.TKFGenerator(params, this.rand, convertedTree, tree.branchLengths());
                    msa = MSAPoset.fromMultiAlignmentObject(MultiAlignment.inducedMultiAlignment(tkfGenerator.generate((int)this.expectedLength)));
                } else {
                    List<Map<Taxon, Character>> columns = sim.simulateColumns(tree);
                    msa = PoissonModelSimulator.toMSA(columns, tree);
                }
                LogInfo.track((Object)"MSA:", true);
                LogInfo.logs(msa);
                LogInfo.end_track();
                double meanLen = msa.getMeanSequenceLength();
                this.statistics.addValue("SequencesMeanLen", meanLen);
                double identity = msa.getIdentityStatistic();
                this.statistics.addValue("MSAIdentity", identity);
                this.idStats.addValue(identity);
                double alignedStat = msa.getAlignedStatistics();
                this.statistics.addValue("MSAAligned", alignedStat);
                File current = new File(output, currentName + ".msf");
                msa.toMultiAlignmentObject().saveToMSF(current);
                LogInfo.track((Object)"Statistics:", true);
                LogInfo.logs("SequencesMeanLen\t" + meanLen);
                LogInfo.logs("MSAAligned\t" + alignedStat);
                LogInfo.logs("MSAIdentity\t" + identity);
                LogInfo.end_track();
                LogInfo.end_track();
            }
            LogInfo.track((Object)"GlobalStatistics:", true);
            LogInfo.logs(this.statistics);
            LogInfo.end_track();
            LogInfo.track((Object)"Identity percentiles:", true);
            Iterator<Integer> iterator = Arrays.asList(5, 25, 50, 75, 95).iterator();
            while (iterator.hasNext()) {
                double percentile = iterator.next().intValue();
                LogInfo.logs("" + percentile + "\t" + this.idStats.getPercentile(percentile));
            }
            LogInfo.end_track();
        }
    }
}

