/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.remote;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RMIClassLoaderSpi;

public class CustomClassLoader
extends RMIClassLoaderSpi {
    private static String externalCodeBase;
    private static ClassLoader dynamicClassLoader;

    @Override
    public String getClassAnnotation(Class<?> cl) {
        return RMIClassLoader.getDefaultProviderInstance().getClassAnnotation(cl);
    }

    @Override
    public ClassLoader getClassLoader(String codebase) throws MalformedURLException {
        return CustomClassLoader.makeClassLoader(codebase);
    }

    private static ClassLoader makeClassLoader(String codebase) throws MalformedURLException {
        codebase = CustomClassLoader.addExternalCodebase(codebase);
        String[] urls = codebase.split(" ");
        URL[] objs = new URL[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            objs[i] = new URL(urls[i]);
        }
        return new URLClassLoader(objs);
    }

    private static String addExternalCodebase(String codebase) {
        if (codebase == null) {
            codebase = "";
        }
        if (!codebase.equals("")) {
            codebase = codebase + " ";
        }
        codebase = codebase + externalCodeBase;
        return codebase;
    }

    @Override
    public Class<?> loadClass(String codebase, String name, ClassLoader defaultLoader) throws MalformedURLException, ClassNotFoundException {
        codebase = CustomClassLoader.addExternalCodebase(codebase);
        return RMIClassLoader.getDefaultProviderInstance().loadClass(codebase, name, defaultLoader);
    }

    @Override
    public Class<?> loadProxyClass(String codebase, String[] interfaces, ClassLoader defaultLoader) throws MalformedURLException, ClassNotFoundException {
        codebase = CustomClassLoader.addExternalCodebase(codebase);
        return RMIClassLoader.getDefaultProviderInstance().loadProxyClass(codebase, interfaces, defaultLoader);
    }

    public static void setExternalCodeBase(String externalCodeBase) {
        CustomClassLoader.externalCodeBase = externalCodeBase;
        try {
            dynamicClassLoader = CustomClassLoader.makeClassLoader(externalCodeBase);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

