/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.exec.servlet.Exceptions;
import fig.exec.servlet.Field;
import fig.exec.servlet.FieldListMap;
import fig.exec.servlet.FileSource;
import fig.exec.servlet.MyException;
import fig.exec.servlet.OperationRP;
import fig.exec.servlet.Permissions;
import fig.exec.servlet.ResponseElement;
import fig.exec.servlet.ResponseObject;
import fig.exec.servlet.ResponseParams;
import fig.exec.servlet.SaveMetadataRP;
import fig.exec.servlet.Trail;
import fig.exec.servlet.UpdateQueue;
import fig.exec.servlet.UpdateSpec;
import fig.exec.servlet.Value;
import fig.exec.servlet.View;
import fig.html.HtmlCell;
import fig.html.HtmlDiv;
import fig.html.HtmlRow;
import fig.html.HtmlTable;
import java.io.File;

public abstract class Item {
    protected static final Value badValue = new Value("null");
    protected Trail trail;
    protected FileSource source;
    protected boolean hasSent;

    public String getType() {
        return this.getClass().getName();
    }

    public Trail getTrail() {
        return this.trail;
    }

    public File getGroundedPath() {
        return this.source.getPath();
    }

    public void saveMetadata(SaveMetadataRP req) throws MyException {
        req.doOperation(this, this.getMetadataFields());
    }

    protected Value getFieldValue(String name) throws MyException {
        if (name.equals("Trail")) {
            return new Value(this.getTrail().toString());
        }
        throw Exceptions.unknownCase();
    }

    protected abstract FieldListMap getMetadataFields();

    public HtmlTable getMetadataTable() throws MyException {
        FieldListMap fields = this.getMetadataFields();
        HtmlTable table = new HtmlTable();
        table.setNoWrap(true);
        table.setAttr("trail", this.getTrail().toStringValue());
        HtmlRow header = new HtmlRow();
        header.setIsHeader(true);
        header.addCell("");
        header.addCell("");
        table.addRow(header);
        HtmlRow row = new HtmlRow();
        row.setAttr("itemName", "name");
        row.setAttr("gloss", "Full trail of this item");
        row.addCell("Full name");
        row.addCell(this.trail.toString());
        table.addRow(row);
        for (Field field : fields.values()) {
            row = new HtmlRow();
            row.setAttr("itemName", field.getName());
            row.setAttr("gloss", field.getGloss());
            row.addCell(field.getName());
            row.addCell(this.fieldToCell(field, field.getValue((Item)this).value));
            table.addRow(row);
        }
        return table;
    }

    protected HtmlCell fieldToCell(Field field, Object value) {
        HtmlCell cell = new HtmlCell(value);
        if (field.numeric) {
            cell.setAttr("numeric");
            cell.setAttr("justify", "right");
        }
        if (field.mutable) {
            cell.setAttr("mutable");
        }
        if (field.multiline) {
            cell.setAttr("multiline");
        }
        return cell;
    }

    public abstract void update(UpdateSpec var1, UpdateQueue.Priority var2) throws MyException;

    public void updateMeNow(UpdateSpec spec) throws MyException {
        this.update(spec, UpdateQueue.Priority.HIGH);
    }

    public ResponseObject handleOperation(OperationRP req, Permissions perm) throws MyException {
        String op = req.getOp();
        if (op.equals("getMetadataTable")) {
            this.updateMeNow(req.getUpdateSpec());
            String name = req.getReq("name");
            HtmlTable table = this.getMetadataTable();
            return new ResponseElement(this.putInBlock(table, name, op));
        }
        if (op.equals("saveMetadata")) {
            perm.checkCanModify();
            SaveMetadataRP saveReq = new SaveMetadataRP(req);
            this.saveMetadata(saveReq);
            return new ResponseParams("Saved " + saveReq.toString(this));
        }
        if (op.equals("copyItem")) {
            Trail destTrail = new Trail(req.getReq("destTrail"));
            View destView = Exceptions.cast(this.source.getDomainView().getItem(destTrail), View.class);
            destView.addSave(this);
            return new ResponseParams("Added " + this.getTrail().getName() + " to " + destView.getTrail().getName() + ", which now has " + destView.getItems().size() + " items");
        }
        throw new MyException("Unknown operation: " + req.getOp());
    }

    protected HtmlDiv putInBlock(HtmlTable table, String name, String op) {
        table.setId(name + ".table");
        HtmlDiv block = new HtmlDiv(new HtmlDiv(this.getType() + ": " + this.trail.getName()), new HtmlDiv(table));
        block.setId(name + ".block");
        block.setAttr("type", this.getType());
        block.setAttr("op", op);
        block.setAttr("trail", this.getTrail().toStringValue());
        return block;
    }

    protected boolean isHidden() {
        return false;
    }

    protected boolean isDead() {
        return false;
    }

    protected boolean isDivider() {
        return false;
    }

    protected String getDividerName() {
        return null;
    }

    protected boolean hasSent() {
        return this.hasSent;
    }

    protected void setSent() {
        this.hasSent = true;
    }

    public String toString() {
        if (this.isDivider()) {
            return this.getDividerName();
        }
        return this.getTrail().getName();
    }

    protected MyException unsupportedException(String op) {
        return Exceptions.unsupported(op, this.trail.toString());
    }

    protected Trail childTrail(String name) {
        return new Trail(this.trail, name);
    }

    public FileSource getSource() {
        return this.source;
    }
}

