/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.basic.OrderedMap;
import fig.exec.servlet.ArgumentException;
import fig.exec.servlet.Field;
import fig.exec.servlet.FieldListMap;
import fig.exec.servlet.Item;
import fig.exec.servlet.MyException;
import fig.exec.servlet.RequestParams;

public class SaveValuesRP
extends RequestParams {
    private String itemName = this.getReq("item");
    private String fieldName = this.getReq("field");
    private String value = this.getReq("value");

    public SaveValuesRP(RequestParams parent) throws ArgumentException {
        super(parent);
    }

    public void doOperation(OrderedMap<String, ? extends Item> items, FieldListMap fields) throws MyException {
        Item item = items.get(this.itemName);
        if (item == null) {
            throw new ArgumentException("Unknown item name: " + this.itemName);
        }
        Field field = (Field)fields.get(this.fieldName);
        if (field == null) {
            throw new ArgumentException("Unknown field name: " + this.fieldName);
        }
        field.changeValue(item, this.value);
    }

    public String getItemName() {
        return this.itemName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return String.format("(%s, %s) := %s", this.itemName, this.fieldName, this.value);
    }
}

