/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.basic.IOUtils;
import fig.basic.Pair;
import fig.servlet.ExecItem;
import fig.servlet.ExecView;
import fig.servlet.ExecViewDB;
import fig.servlet.FileUtils;
import fig.servlet.FilenameFilterBank;
import fig.servlet.GroundedExecView;
import fig.servlet.Item;
import fig.servlet.MyException;
import fig.servlet.ReadyExecView;
import fig.servlet.RootItem;
import fig.servlet.UpdateQueue;
import fig.servlet.UpdateSpec;
import fig.servlet.Value;
import fig.servlet.WebState;
import java.io.File;

public class AllExecView
extends ExecView {
    public AllExecView(Item parent, String name, String sourcePath) {
        super(parent, name, sourcePath);
    }

    @Override
    protected Value getIntrinsicFieldValue(String fieldName) throws MyException {
        if (fieldName.equals("description")) {
            return new Value("All executions");
        }
        return super.getIntrinsicFieldValue(fieldName);
    }

    @Override
    protected boolean hasMutableMetadata() {
        return false;
    }

    @Override
    protected String fileSourcePath() {
        return null;
    }

    @Override
    public void update(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        FileUtils.TraverseSpec tspec = new FileUtils.TraverseSpec(new FilenameFilterBank.Compose(new FilenameFilterBank.Regex(".*\\.exec", true), FilenameFilterBank.onlyDir()), new FilenameFilterBank.Compose(new FilenameFilterBank.Regex(".*\\.exec.*", false), FilenameFilterBank.onlyDir()));
        this.updateItemsFromDir(-1, tspec, false);
        ExecViewDB execViewDB = this.getExecViewDB();
        for (Item _item : this.items.values()) {
            if (!(_item instanceof ExecItem)) continue;
            ExecItem item = (ExecItem)_item;
            File path = new File(item.sourcePath, "addToView");
            for (String viewName : IOUtils.readLinesEasy(path.toString())) {
                GroundedExecView view = (GroundedExecView)execViewDB.getItemOrNewAdd(viewName);
                if (!view.hasUpdated || view.containsItem(item)) continue;
                WebState.logs("Adding %s to view %s", item, view);
                view.addItem(item);
                view.saveToDisk();
                path.delete();
            }
            if (!item.isThunk()) continue;
            Value value = item.getIntrinsicFieldValue("options.map:exec.thunkAutoQueue");
            if (!"true".equals(value.value)) continue;
            ReadyExecView readyExecView = ((RootItem)this.getRoot()).workerViewDB.readyExecView;
            readyExecView.addItem(item);
            readyExecView.saveToDisk();
        }
        this.updateChildren(spec, priority.next());
    }

    @Override
    protected Pair<String, Boolean> getDefaultSortSpec() {
        return new Pair<String, Boolean>("date", true);
    }
}

