/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.basic.Fmt;
import fig.basic.IOUtils;
import fig.servlet.CustomObjectInputStream;
import fig.servlet.FieldListMap;
import fig.servlet.FileException;
import fig.servlet.FileItem;
import fig.servlet.Item;
import fig.servlet.MyException;
import fig.servlet.OperationRP;
import fig.servlet.Permissions;
import fig.servlet.ResponseObject;
import fig.servlet.ResponseParams;
import fig.servlet.Value;
import fig.servlet.WebState;
import java.io.IOException;

public class ObjFileItem
extends FileItem {
    protected Object obj;

    public ObjFileItem(Item parent, String name, String sourcePath) {
        super(parent, name, sourcePath);
    }

    @Override
    protected Value getIntrinsicFieldValue(String name) throws MyException {
        if (name.equals("class")) {
            return this.obj == null ? new Value(null) : new Value(this.obj.getClass().toString());
        }
        return super.getIntrinsicFieldValue(name);
    }

    @Override
    public FieldListMap getMetadataFields() {
        FieldListMap fields = super.getMetadataFields();
        fields.add("class", "Class name");
        return fields;
    }

    public void load() throws MyException {
        this.load(null);
    }

    public void load(ClassLoader loader) throws MyException {
        if (this.obj != null) {
            return;
        }
        if (this.fileSize > 0xA00000L) {
            throw new MyException("File too big to load: " + Fmt.bytesToString(this.fileSize));
        }
        WebState.logs("Loading object " + this.sourcePath + ", class loader = " + loader);
        try {
            this.obj = loader == null ? IOUtils.readObjFile(this.sourcePath) : new CustomObjectInputStream(loader, this.sourcePath).readObject();
        }
        catch (ClassNotFoundException e) {
            throw new MyException(e.getMessage());
        }
        catch (IOException e) {
            throw new FileException(e);
        }
    }

    @Override
    public ResponseObject handleOperation(OperationRP req, Permissions perm) throws MyException {
        String op = req.op;
        if (op.equals("load")) {
            this.load();
            return new ResponseParams("Loaded.");
        }
        return super.handleOperation(req, perm);
    }

    public Object getObj() {
        return this.obj;
    }
}

