/*
 * Decompiled with CFR 0.152.
 */
package gep.comparisons;

import fig.basic.LogInfo;
import gep.comparisons.HeldoutReconstructionMethod;
import gep.timeseries.Measurements;
import java.util.List;
import nuts.util.Counter;

public class FlatReconstructionMethod
implements HeldoutReconstructionMethod {
    private int recon;

    public static FlatReconstructionMethod mleFlatRecon(List<Measurements> observations) {
        Counter<Integer> freqs = new Counter<Integer>();
        for (Measurements m : observations) {
            for (int i = 0; i < m.size(); ++i) {
                freqs.incrementCount(m.getValue(i), 1.0);
            }
        }
        freqs.normalize();
        LogInfo.logs("Frequencies:" + freqs);
        return new FlatReconstructionMethod((Integer)freqs.argMax());
    }

    public FlatReconstructionMethod(int recon) {
        this.recon = recon;
    }

    @Override
    public int reconstruct(int sIdx, int qIdx) {
        return this.recon;
    }
}

